// OptTree.h : header file
//

#if ! defined( OptionTree_H )
#  define OptionTree_H

/////////////////////////////////////////////////////////////////////////////
// OptionTree view


#include  "Report.h"
#include  "TreeData.h"


class CMainFrame;


class OptionTree : public CTreeView
{
protected:
	OptionTree();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(OptionTree)

// Attributes
public:
	void TextReport( const char *filename = NULL );
	HTREEITEM GetFirst();
	CString GetItemText( HTREEITEM item );
	int GetCount();
	void PrintPreview();
	void Print();
	void EditFont();
	void SetFontChars( const LOGFONT &lf, BOOL replaceOld = FALSE );
	void CollapseAll();
	BOOL Expanded() const;
	void ExpandAll( BOOL expanded );
	void SelectItem( HTREEITEM item );
	BOOL GetTreeData( HTREEITEM item, TreeData &treeData ) const;
	HTREEITEM GetSelectedItem() const;
	HTREEITEM PrevItem( HTREEITEM curItem );
	HTREEITEM NextItem( HTREEITEM curItem );
	HTREEITEM AddItem( int itemKey, const CString &itemText, HTREEITEM itemParent );

// Operations
public:
	CSplitterWnd *GetSplitter() const;
	CMainFrame *GetFrame() const;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(OptionTree)
	public:
	virtual void OnInitialUpdate();
	virtual BOOL Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext = NULL);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~OptionTree();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(OptionTree)
	afx_msg void OnSelchanged(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg HBRUSH CtlColor(CDC* pDC, UINT nCtlColor);
	afx_msg void OnSelchanging(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnItemexpanded(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnTextreport();
	//}}AFX_MSG
//	afx_msg void OnFilePrint();
//	afx_msg void OnFilePrintPreview();
	DECLARE_MESSAGE_MAP()
private:
	Report m_report;
	//CString m_printText;
	CFont * m_ourFont;
	HTREEITEM m_oldItem;
	HTREEITEM m_first;
	HTREEITEM m_selected;
	BOOL m_expanded;
	POSITION lastPos;
	CStringList strList;
	void DeleteTree( HTREEITEM item );
	CImageList m_imageList;
};

/////////////////////////////////////////////////////////////////////////////


#endif
