/***************************************************************************
 *                                                                         *
 *  OPTION.H                                                               *
 *                                                                         *
 *  WgsCnf configuration option struct                                     *
 *                                                                         *
 *                                                  - Paul Roub  08/20/96  *
 *                                                                         *
 ***************************************************************************/

#if ! defined( OPTION_H )
#  define OPTION_H

#include "gctypdef.h"
#include "msgrdr.h"

//--- Flags ---
const CHAR ANYCHG = 0x01;          // Has the value of this option changed? 
const CHAR ISHING = 0x02;           // Does this option hinge upon another? 
const CHAR ISHPAR = 0x04;             // is there a paragraph help message? 
const CHAR FILOAD = 0x08;                  // this file has been lodopt()'d 
const CHAR FILANG = 0x10;              // this file has new languages in it 

#define MAINFL "wgsmajor.msg"                 // main MAJORBBS message file 


                                                   // OPTION FILE STRUCTURE 
struct msgfil {                                    // --------------------- 
     struct msgfil *next;          // forward pointer                       
     CHAR name[12+1];              // file name                             
     FILE *fp;                     // file pointer                          
     struct option *fstopt;        // index into "option" list of first option 
     INT numopt;                   // number of options from this file      
     LONG bofopt;                  // position in MSG file where options start 
     LONG eofopt;                  // position in MSG file after last option 
     LONG boflng;                  // position in MSG file where options start 
     LONG eoflng;                  // position in MSG file after last option 
     CHAR flags;                   // uses ANYCHG mask, same as for options, see above 
     INT lngcnt;                   // number of languages in this .MSG file 
     INT *mslidx;                  // xlate:  0..nlingo-1 to 0..lngcnt-1 
     CString fullName;             // file name and relative path

     //   management
     //
     msgfil();
    ~msgfil();
     msgfil & operator = ( const option &msgfil );
     void clear();
     void ClearChanges();

private:
     int modCount;                 //number of modified options in file
     friend class CnfDoc;
}; 

                                                        // OPTION STRUCTURE 
struct option {                                          // ---------------- 
     //   option data
     //
     UINT index;                   // 0...totopt-1                  
     struct option *next,*prev;    // forward/backward pointers             
     struct msgfil *file;          // pointer to appropriate file           
     CHAR name[MOPTLEN+1];         // Name of option (name in .MSG file)    
     CString lineDesc;             // one-line description 
     CString curValue;             // value of option (see values for 'T' options) 
     altlng *values;               // array of values for text blocks

     CHAR flags;                   // (see below)                           
     CHAR type;                    // Type of option (C,S,H,N,L,B,E)        

     LONG floor,ceiling;           // Limits for N,L,H opts, maxlen of S opt 
     CString enList;               // List for type E options                 
     LONG parptr;                  // .MSG file pointer to description paragraph 
     INT parlen;                   // Length of description paragraph       
     CHAR hngop;                   // Hinge operator:  "=" for EQ, "#" for NE 
     struct option *hngptr;        // Option ptr to the "hinge" option      
     CString hngVal;               // Hinge value

     //   housekeeping
     //
     int  references;              // number of TreeData objects referencing us
     CString origValue;            // original value (at last save)
     CString *origValues;          // original values (for 'T' options)

     //   management
     //
     option();
     option & operator = ( const option &opt );
     void clear();
};

#endif
