////////////////////////////////////////////////////////////////////////////
//
//  OPTION.CPP
//
//  WGSCNF config option member functions
//
//                                                  - Paul Roub  09/17/96
//
/////////////////////////////////////////////////////////////////////////////

#include  "stdafx.h"
#include  "gcommlib.h"
#include  "option.h"


option::option()
{
     clear();
}


void
option::clear()                    // reset all data members
{
     index = 0;
     next = NULL;
     prev = NULL;
     file = NULL;
     name[0] = 0;
     values = NULL;
     flags = 0;
     type = '\0';
     floor = NULL;
     ceiling = NULL;
     parptr = 0;
     parlen = 0;
     hngop = '\0';
     hngptr = NULL;     
     references = 0;

     lineDesc.Empty();
     curValue.Empty();
     enList.Empty();
     hngVal.Empty();
     origValue.Empty();

     origValues = NULL;
}


option &                           //   reference to this
option::operator =(                // assignment operator
const option &opt)                 //   option to assign from
{
     if (&opt != this)
     {
          index = opt.index;
          next = opt.next;
          prev = opt.prev;
          file = opt.file;
          memcpy( name, opt.name, sizeof( name ) );
          values = opt.values;
          flags = opt.flags;
          type = opt.type;
          floor = opt.floor;
          ceiling = opt.ceiling;
          parptr = opt.parptr;
          parlen = opt.parlen;
          hngop = opt.hngop;
          hngptr = opt.hngptr;
          references = opt.references;
          lineDesc = opt.lineDesc;
          curValue = opt.curValue;
          enList = opt.enList;
          hngVal = opt.hngVal;

          origValue = opt.origValue;
          origValues = opt.origValues;
     }

     return( *this );
}


msgfil::msgfil()
{
     fp = NULL;
     mslidx = NULL;
     clear();
     strcpy( name, MAINFL );
}

msgfil::~msgfil()
{
     clear();
}


msgfil &                           //   reference to this
msgfil::operator =(                // assignment operator
const msgfil &oldfil)              //   msgfil to assign from
{
     if (&oldfil != this)
     {
          if (mslidx != NULL)
          {
               free( mslidx );
          }

          next = oldfil.next;
          memcpy( name, oldfil.name, sizeof( name ) );
          fp = oldfil.fp;
          fstopt = oldfil.fstopt;
          numopt = oldfil.numopt;
          bofopt = oldfil.bofopt;
          eofopt = oldfil.eofopt;
          boflng = oldfil.boflng;
          eoflng = oldfil.eoflng;
          flags = oldfil.flags;
          lngcnt = oldfil.lngcnt;
          mslidx = oldfil.mslidx;
          fullName = oldfil.fullName;
          modCount = oldfil.modCount;
     }

     return( *this );
}


void
msgfil::clear()                    // reset all data members
{
     if (fp != NULL) {
          fclose(fp);
     }

     if (mslidx != NULL) {
          free(mslidx);
     }

     next = NULL;
     name[ 0 ] = 0;
     fp = NULL;
     fstopt = NULL;
     numopt = 0;
     bofopt = eofopt = boflng = eoflng = 0;
     flags = 0;
     lngcnt = 0;
     mslidx = NULL;
     modCount = 0;
     fullName.Empty();
}


void
msgfil::ClearChanges()             // reset change flag
{
     flags &= ~ANYCHG;             // no longer modified vs. disk
     modCount = 0;                 // no modified options
}
