// OptEdit.h : header file
//

#if ! defined( OPTIONEDITVIEW_H )
#  define OPTIONEDITVIEW_H

/////////////////////////////////////////////////////////////////////////////
// OptionEditView view

class StringEdit;
class YesNoButton;
class EnumCombo;
class LangCombo;
class DrawButton;
class CMainFrame;

class OptionEditView : public CScrollView
{
protected:
     StringEdit *m_edit;
     static CBrush m_brush;
     OptionEditView();           // protected constructor used by dynamic creation
     DECLARE_DYNCREATE(OptionEditView)

// Attributes
public:
     void EditFont();
     CString m_key;
     void FinishExternal( int rc );
     virtual afx_msg HBRUSH OnCtlColor( CDC *pDC, CWnd *pWnd, UINT nCtlColor );
     BOOL ValidateCurrentItem();
     void CustomEdit();
     int GetCurLang() const;
     void SelectLanguage( int langNo );
     static void SetFontChars( const LOGFONT &lf, BOOL replaceOld = FALSE );

// Operations
public:

// Overrides
     // ClassWizard generated virtual function overrides
     //{{AFX_VIRTUAL(OptionEditView)
     public:
     virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);
     virtual BOOL Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext = NULL);
     protected:
     virtual void OnDraw(CDC* pDC);      // overridden to draw this view
     virtual void OnInitialUpdate();     // first time after construct
     virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
     virtual void OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView);
     //}}AFX_VIRTUAL

// Implementation
protected:
     virtual ~OptionEditView();
#ifdef _DEBUG
     virtual void AssertValid() const;
     virtual void Dump(CDumpContext& dc) const;
#endif

     // Generated message map functions
     //{{AFX_MSG(OptionEditView)
     afx_msg BOOL OnEraseBkgnd(CDC* pDC);
     afx_msg void OnSize(UINT nType, int cx, int cy);
     afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnFilePrint();
	afx_msg void OnFilePrintPreview();
	afx_msg void OnTextreport();
	//}}AFX_MSG
     DECLARE_MESSAGE_MAP()
private:
     CString m_origText;
     static char altbuf[];
     CMainFrame * GetFrame() const;
     int GetMaxWidth( CDC *dc, int tlen ) const;
     void RemoveOldControls();
     CStatic * m_limits;
     int m_curLang;
     LangCombo * m_langList;
     DrawButton * m_drawButton;
     BOOL hasButtons;
     BOOL hasCombo;
     BOOL hasEdit;
     BOOL hasMultiEdit;
     static CFont *m_ourFont;
     EnumCombo *m_combo;
     YesNoButton *m_radios;
     CStatic *m_description;
};

/////////////////////////////////////////////////////////////////////////////

#endif
