/***************************************************************************
 *                                                                         *
 *   MDLOGIC.H                                                             *
 *                                                                         *
 *   Copyright (c) 1992-1996 Galacticomm, Inc.    All rights reserved.     *
 *                                                                         *
 *   This is the header file for the callable ANSI screen builder          *
 *   utility for use with Worldgroup.                                      *
 *                                                                         *
 *                       - S. Brinker & T. Stryker    03/24/92             *
 *                                                                         *
 ***************************************************************************/

#ifndef __MDLOGIC_H
#define __MDLOGIC_H

extern
CHAR *scnbuf,                      // static buffer of our screen          
     *tmpbuf;                      // temporary screen buffer              

extern CHAR filnam[100];           // static buffer of our file name       

extern
INT mddone,                        // are we done yet?                     
    changed,                       // something changed in this file?      
    finalx,finaly,                 // final (x,y) cursor position          
    finalc,                        // final cursor color                   
    scropt,                        // current "scroll option" for window   
    savwcs,                        // save with clear screen?              
    lastx,lasty;                   // bottom of active screen              

struct marker {                    // "key required" marked area structure 
     INT line;                     //   line (0-24) marker is on           
     INT startx;                   //   starting x coordinate              
     INT endx;                     //   ending x coordinate                
     INT select;                   //   select character                   
};

extern struct marker *markers;     // static array of markers              
extern INT nmarks;                 // current total of markers             

#define MARKCH      255            // marker character                     
#define MXMARK      100            // max. number of markers in a file     

struct txtvar {                    // text variable on screen structure    
     INT line;                     //   line (0-24) marker is on           
     INT startx;                   //   starting x coordinate              
     INT endx;                     //   ending x coordinate                
     INT attr;                     //   attribute for this text variable   
     CHAR name[TVRSIZ];            //   text variable name                 
     CHAR just;                    //   justification formatting option    
     CHAR length;                  //   formatting length                  
};

#define TVARCH      1              // text variable character              
#define MXTXTV      256            // maximum number of text variables     

extern CHAR *justbl[];             // array of justification names         

#define YONSIZ      4              // size of yes/no edtval() fields       

#define IBMFIL      0              //   try .ibm file first                
#define ANSFIL      1              //   try .ans file first                
#define ASCFIL      2              //   try .asc file first                
extern CHAR *tryext[3][3];         // table of file extensions to try      

extern CHAR scntbl[][GVIDSCNSIZ];  // table of screens in memory           
#define HLPSCN      0              //   help screen                        
#define COLSCN      1              //   select colors screen               
#define INTSCN      2              //   intro/credits screen               
#define MSCSCN      3              //   miscellaneous pop-up boxes         
#define TXVSCN      4              //   text variable screen               
#define ERRSCN      5              //   error messages screen              

#define ULX    0                   // upper left window x position         
#define ULY    0                   // upper left window y position         
#define LRX    79                  // lower right window x position        
#define LRY    24                  // lower right window y position        

#define hidecursor()     locate(0,25)        // hide cursor trick          

VOID ibdraw(INT alwmrk);
VOID inimdl(VOID);
VOID mdesc(VOID);
INT xmdnow(VOID);
VOID mdmain(GBOOL accmrk,VOID (*xitrou)(INT c));
VOID shwqrf(VOID);
VOID keymrk(VOID);
VOID addtxv(VOID);
VOID ptvons(struct txtvar *vptr);
VOID zaptxv(VOID);
struct marker *kminxy(INT kx,INT ky);
struct txtvar *tvinxy(INT vx,INT vy);
VOID colbox(VOID);
VOID block(VOID);
VOID joilin(VOID);
VOID divlin(VOID);
INT empton(INT ex,INT ey);
INT cbrkpt(INT max);
VOID inslin(VOID);
VOID inlutl(INT iy);
VOID rmvlin(VOID);
VOID rmlutl(INT ry);
VOID delkm(struct marker *mptr);
VOID rstlin(VOID);
VOID withcs(VOID);
VOID cvt2asc(VOID);
VOID clrall(VOID);
VOID setfxyc(VOID);
VOID saveans(CHAR *savnam);
VOID fmttxv(CHAR *cptr,INT con);
VOID getload(VOID);
GBOOL valfln(INT c,CHAR *stg);
VOID rfrlin(VOID);
VOID rfrscn(VOID);
VOID adjbdr(VOID);
VOID shofxyc(VOID);
VOID shwkmk(VOID);
VOID hidqrf(VOID);
VOID intro(VOID);
INT mdload(INT isbuff,CHAR *fnorbf);
INT dwaatr(INT catr,CHAR *stg);
VOID dwamov(CHAR *stg);
VOID ldabyt(INT c);
VOID clrfxyc(VOID);
INT stoeol(INT lx,INT ly);
INT is80lin(INT line);
INT endscn(INT fromy);
INT blankl(CHAR *sp);
CHAR *xlta2a(INT old,INT newval);
VOID shfllf(VOID);
VOID movcur(INT dx,INT dy);
VOID updqrf(VOID);
VOID jmp2eol(VOID);
VOID putit(INT c);
VOID setbdr(INT color);
GBOOL blowoff(VOID);
VOID mdmtdraw(CHAR *fpassd,INT shoid,VOID (*exirou)(INT));
VOID exitmd(VOID);
VOID savemd(VOID);
INT needibm(VOID);
INT needans(VOID);
VOID savebin(CHAR *savnam);
VOID saveasc(CHAR *savnam);
INT getchq(VOID);

#endif                             // __MDLOGIC_H                          
