// MainFrm.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////

#if ! defined( MAINFRAME_H )
#  define MAINFRAME_H

#include  "Splitter.h"

class OptionTree;
class CnfDoc;

class CMainFrame : public CFrameWnd
{
protected: // create from serialization only
	CMainFrame();
	DECLARE_DYNCREATE(CMainFrame)

// Attributes
protected:
     Splitter m_wndSplitter;
     Splitter m_wndSplitter2;
public:
	void DontSaveSettings();
	void ActivateNextView( BOOL next );
	void SetExpandAll( BOOL expanded );
	void ForceStatusBarUpdate();
	void UpdateStatusBar();
	void OnUpdateProgress(CCmdUI* pCmdUI);
	void OnUpdateModified(CCmdUI* pCmdUI);
	void UpdateLoadGraph( int sofar, int total, int items );
	void SetHeaderStatus( const CString &text );

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMainFrame)
	public:
	virtual BOOL OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext);
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL DestroyWindow();
	virtual BOOL LoadFrame(UINT nIDResource, DWORD dwDefaultStyle = WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, CWnd* pParentWnd = NULL, CCreateContext* pContext = NULL);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMainFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
	void OnUpdateHeader(CCmdUI* pCmdUI);
	void RestorePosition();

protected:  // control bar embedded members
	CStatusBar  m_wndStatusBar;
	CToolBar    m_wndToolBar;

// Generated message map functions
protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnUpdateFileSave(CCmdUI* pCmdUI);
	afx_msg void OnClose();
	afx_msg void OnSearch();
	afx_msg void OnSearchNext();
	afx_msg void OnUpdateSearchagain(CCmdUI* pCmdUI);
	afx_msg void OnExpandall();
	afx_msg void OnUpdateExpandall(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCollapseall(CCmdUI* pCmdUI);
	afx_msg void OnCollapseall();
	afx_msg void OnUpdateSearchmenu(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAppExit(CCmdUI* pCmdUI);
	afx_msg void OnEditfont();
	afx_msg void OnTreefont();
	afx_msg void OnHelpfont();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	int m_total;
	int m_sofar;
private:
	BOOL m_saveSettings;
	void RecalcSplitterLayout();
	BOOL FullyLoaded();
	CnfDoc * GetDoc();
	void AdjustPaneWidth( int pane, const CString &st );
	BOOL GetExpanded();
	int m_items;
	BOOL progressCreated;
	CProgressCtrl m_progressCtrl;
	void GetHelpPaneSize( CSize &helpSize ) const;
	void GetTextPaneSize( CSize &textSize ) const;
	void GetTreePaneSize( CSize &treeSize ) const;
	void SavePosition() const;
};


extern CMainFrame *theMainFrame;

/////////////////////////////////////////////////////////////////////////////


#endif
