// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "gcommlib.h"
#include "WgsCnf.h"
#include "OptTree.h"
#include "CnfDoc.h"
#include "modifier.h"
#include "HelpView.h"
#include "YesNo.h"
#include "StrEdit.h"
#include "OptEdit.h"
#include "levels.h"
#include "MainFrm.h"
#include "afxpriv.h"
#include "CnfAsrt.h"
#include "edtoff.h"

#define FILREV "$Revision: $"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CWgsCnfApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
     //{{AFX_MSG_MAP(CMainFrame)
     ON_WM_CREATE()
     ON_WM_SIZE()
     ON_UPDATE_COMMAND_UI(ID_FILE_SAVE, OnUpdateFileSave)
     ON_WM_CLOSE()
     ON_COMMAND(IDM_SEARCHMENU, OnSearch)
     ON_COMMAND(IDM_SEARCHAGAIN, OnSearchNext)
     ON_UPDATE_COMMAND_UI(IDM_SEARCHAGAIN, OnUpdateSearchagain)
     ON_COMMAND(IDM_EXPANDALL, OnExpandall)
     ON_UPDATE_COMMAND_UI(IDM_EXPANDALL, OnUpdateExpandall)
     ON_UPDATE_COMMAND_UI(IDM_COLLAPSEALL, OnUpdateCollapseall)
     ON_COMMAND(IDM_COLLAPSEALL, OnCollapseall)
     ON_UPDATE_COMMAND_UI(IDM_SEARCHMENU, OnUpdateSearchmenu)
     ON_UPDATE_COMMAND_UI(ID_APP_EXIT, OnUpdateAppExit)
     ON_UPDATE_COMMAND_UI(ID_INDICATOR_HEADER, OnUpdateHeader)
     ON_UPDATE_COMMAND_UI(ID_INDICATOR_PROGRESS, OnUpdateProgress)
     ON_UPDATE_COMMAND_UI(ID_INDICATOR_MODIFIED, OnUpdateModified)
     ON_WM_PAINT()
     ON_COMMAND(IDM_EDITFONT, OnEditfont)
     ON_COMMAND(IDM_TREEFONT, OnTreefont)
     ON_COMMAND(IDM_HELPFONT, OnHelpfont)
     //}}AFX_MSG_MAP
     ON_WM_CTLCOLOR()
     // Global help commands
     ON_COMMAND(ID_HELP_FINDER, CFrameWnd::OnHelpFinder)
     ON_COMMAND(ID_HELP, CFrameWnd::OnHelp)
     ON_COMMAND(ID_CONTEXT_HELP, CFrameWnd::OnContextHelp)
     ON_COMMAND(ID_DEFAULT_HELP, CFrameWnd::OnHelpFinder)
END_MESSAGE_MAP()

static UINT indicators[] =
{
     ID_SEPARATOR,           // status line indicator
     ID_INDICATOR_HEADER,
     ID_INDICATOR_PROGRESS,
     ID_INDICATOR_MODIFIED,
     ID_INDICATOR_CAPS,
     ID_INDICATOR_NUM
};


CMainFrame *theMainFrame = NULL;

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
     // TODO: add member initialization code here
     progressCreated = FALSE; 

     m_sofar = 0;
     m_total = 0;
     m_items = 0;
     m_saveSettings = TRUE;

     CnfAssert( theMainFrame == NULL );
     theMainFrame = this;
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
     if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
          return -1;

     ShowWindow( SW_MINIMIZE );
     UpdateWindow();
     
     if (!m_wndToolBar.Create(this) ||
          !m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
     {
          TRACE0("Failed to create toolbar\n");
          return -1;      // fail to create
     }

     if (!m_wndStatusBar.Create(this) ||
          !m_wndStatusBar.SetIndicators(indicators,
            sizeof(indicators)/sizeof(UINT)))
     {
          TRACE0("Failed to create status bar\n");
          return -1;      // fail to create
     }
     else
     {
          UINT id;
          UINT style;
          int  width;

          m_wndStatusBar.GetPaneInfo( 1, id, style, width );
          m_wndStatusBar.SetPaneInfo( 1, id, style & ~SBPS_DISABLED,
                                       50
                                          );

          m_wndStatusBar.GetPaneInfo( 2, id, style, width );
          m_wndStatusBar.SetPaneInfo( 2, id, style & ~SBPS_DISABLED,
                                             50
                                          );

     }

     // TODO: Remove this if you don't want tool tips or a resizeable toolbar
     m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
          CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

     // TODO: Delete these three lines if you don't want the toolbar to
     //  be dockable
     m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
     EnableDocking(CBRS_ALIGN_ANY);
     DockControlBar(&m_wndToolBar);

     //   RestorePosition();

     CRect iRect;

     m_wndStatusBar.GetItemRect( 2, iRect );

     CString   caption = "" SVR_NAME " " + GetLevelDesc( NULL, level );

     SetWindowText( caption );

     CToolBarCtrl &bar = m_wndToolBar.GetToolBarCtrl();

     BOOL enabled = bar.IsButtonEnabled( ID_FILE_SAVE );

     bar.EnableButton( ID_FILE_SAVE, FALSE );

     enabled = bar.IsButtonEnabled( ID_FILE_SAVE );

     return 0;
}

BOOL CMainFrame::OnCreateClient( LPCREATESTRUCT /*lpcs*/,
     CCreateContext* pContext)
{
     BOOL   result = m_wndSplitter.CreateStatic( this, 2, 1 );

     result = m_wndSplitter2.CreateStatic( &m_wndSplitter,
                                                    1, 2,
                                                    WS_CHILD | WS_VISIBLE | WS_BORDER,
                                                    m_wndSplitter.IdFromRowCol(0, 0)
                                                  );

     CSize treePaneSize( 100, 100 );
     CSize textPaneSize( 150, 100 );
     CSize helpPaneSize( 250, 100 );
     int   width = 275;
     int   height = 200;

     CRect  cliSize;

     GetClientRect( cliSize );

     if ((cliSize.Width() > 0) && (cliSize.Height() > 0))
     {
          width  = cliSize.Width();
          height = cliSize.Height();

          treePaneSize = CSize( width * 2 / 5, height * 4 / 5 );
          textPaneSize = CSize( width * 3 / 5, height * 4 / 5 );
          helpPaneSize = CSize( width,         height / 5 );
     }

     GetTreePaneSize( treePaneSize );
     GetTextPaneSize( textPaneSize );
     GetHelpPaneSize( helpPaneSize );

     m_wndSplitter.SetRowInfo( 0, treePaneSize.cy, 0 );

     BOOL createOk = m_wndSplitter.CreateView( 1, 0, RUNTIME_CLASS( HelpView ),
                                               helpPaneSize, pContext 
                                             );

     CnfAssert( createOk );

     createOk = m_wndSplitter2.CreateView( 0, 0, pContext->m_pNewViewClass,
                                           treePaneSize, pContext
                                         );

     CnfAssert( createOk );

     createOk = m_wndSplitter2.CreateView( 0, 1, RUNTIME_CLASS( OptionEditView ),
                                           textPaneSize, pContext
                                         );

     CnfAssert( createOk );

     SetActiveView((CView*)m_wndSplitter2.GetPane(0,0));
                                
     return( result );
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
     // TODO: Modify the Window class or styles here by modifying
     //  the CREATESTRUCT cs

     return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
     CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
     CFrameWnd::Dump(dc);
}

#endif //_DEBUG


void CMainFrame::SetHeaderStatus( const CString &text )
{
     if (::IsWindow( m_wndStatusBar.m_hWnd ))
     {
          int  idx = m_wndStatusBar.CommandToIndex( ID_INDICATOR_HEADER );

          int       colpos = text.Find( ':' );

          CString   theText( text );

          if (colpos >= 0)
          {
               theText = text.Left( colpos );
          }

          AdjustPaneWidth( 1, theText );

          m_wndStatusBar.SetPaneText( idx, theText, TRUE );
     }
}


void CMainFrame::RestorePosition()
{
     int       winRight  = theApp.GetProfileInt( "Settings", "MainWinRight",  -1 );   
     int       winBottom = theApp.GetProfileInt( "Settings", "MainWinBottom", -1 );   
     int       winLeft   = theApp.GetProfileInt( "Settings", "MainWinLeft",   -1 );
     int       winTop    = theApp.GetProfileInt( "Settings", "MainWinTop",    -1 );
     int       showState = theApp.GetProfileInt( "Settings", "MainWinState",  -1 );

     if ((winRight > 0) && (winBottom > 0) &&
          (winLeft >=  0) && (winTop >=  0) &&
          (showState >= 0)
        )
     {
          WINDOWPLACEMENT place;
          place.length = sizeof( WINDOWPLACEMENT );

          if (GetWindowPlacement( &place ))
          {
               place.rcNormalPosition.left = winLeft;
               place.rcNormalPosition.top = winTop;
               place.rcNormalPosition.right = winRight;
               place.rcNormalPosition.bottom = winBottom;
               place.showCmd = showState;

               BOOL   placed = SetWindowPlacement( &place );
               CnfAssert( placed );
          }
     }
     else
     {
          WINDOWPLACEMENT place;
          place.length = sizeof( WINDOWPLACEMENT );

          if (GetWindowPlacement( &place ))
          {
               place.rcNormalPosition.left = 10;
               place.rcNormalPosition.top = 10;
               place.rcNormalPosition.right = 630;
               place.rcNormalPosition.bottom = 470;
               place.showCmd = SW_NORMAL;

               BOOL   placed = SetWindowPlacement( &place );
               CnfAssert( placed );
          }
     }

     RecalcSplitterLayout();

     UpdateWindow();

     return;
}

void CMainFrame::SavePosition() const
{
     if (! m_saveSettings)
     {
          return;
     }

     WINDOWPLACEMENT place;
     place.length = sizeof( WINDOWPLACEMENT );

     if (GetWindowPlacement( &place ))
     {
          int winLeft = place.rcNormalPosition.left;
          int winTop = place.rcNormalPosition.top;
          int winRight = place.rcNormalPosition.right;
          int winBottom = place.rcNormalPosition.bottom;
          int showState = place.showCmd;

          BOOL      wroteOk;

          wroteOk = theApp.WriteProfileInt( "Settings", "MainWinRight",  winRight   );
          CnfAssert( wroteOk );

          wroteOk = theApp.WriteProfileInt( "Settings", "MainWinBottom", winBottom  );
          CnfAssert( wroteOk );

          wroteOk = theApp.WriteProfileInt( "Settings", "MainWinLeft",   winLeft    );
          CnfAssert( wroteOk );

          wroteOk = theApp.WriteProfileInt( "Settings", "MainWinTop",    winTop     );
          CnfAssert( wroteOk );

          wroteOk = theApp.WriteProfileInt( "Settings", "MainWinState",  showState );
          CnfAssert( wroteOk );
     }

     int       theMin = -1;
     int       treeAndEditHeight = -1;
     int       treeWidth = -1;
     int       editWidth = -1;
     int       helpHeight = -1;
     int       helpWidth = -1;

     m_wndSplitter.GetRowInfo( 0, treeAndEditHeight, theMin );
     m_wndSplitter.GetRowInfo( 1, helpHeight, theMin );
     m_wndSplitter.GetColumnInfo( 0, helpWidth, theMin );

     m_wndSplitter2.GetColumnInfo( 0, treeWidth, theMin );
     m_wndSplitter2.GetColumnInfo( 1, editWidth, theMin );

     BOOL      wroteOk;

     wroteOk = theApp.WriteProfileInt( "Settings", "TreeWinWidth", treeWidth );
     CnfAssert( wroteOk );

     wroteOk = theApp.WriteProfileInt( "Settings", "TreeWinHeight", treeAndEditHeight );
     CnfAssert( wroteOk );

     wroteOk = theApp.WriteProfileInt( "Settings", "EditWinWidth", treeWidth );
     CnfAssert( wroteOk );

     wroteOk = theApp.WriteProfileInt( "Settings", "EditWinHeight", treeAndEditHeight );
     CnfAssert( wroteOk );

     wroteOk = theApp.WriteProfileInt( "Settings", "HelpWinWidth", helpWidth );
     CnfAssert( wroteOk );

     wroteOk = theApp.WriteProfileInt( "Settings", "HelpWinHeight", helpHeight );
     CnfAssert( wroteOk );

     CToolBarCtrl &tool = m_wndToolBar.GetToolBarCtrl();

     tool.SaveState( HKEY_CURRENT_USER, "Software\\Galacticomm\\WgsCnf\\Settings",
                     "ToolBarState"
                   );

     return;
}

BOOL CMainFrame::DestroyWindow() 
{
     // TODO: Add your specialized code here and/or call the base class
     SavePosition();
     
     return CFrameWnd::DestroyWindow();
}

void CMainFrame::GetTreePaneSize( CSize &treeSize ) const
{
     int      treeHeight = theApp.GetProfileInt( "Settings", "TreeWinHeight", -1 );  
     int      treeWidth  = theApp.GetProfileInt( "Settings", "TreeWinWidth",  -1 );  

     if ((treeHeight >= 0) && (treeWidth >= 0))
     {
          treeSize.cx = treeWidth;
          treeSize.cy = treeHeight;
     }

     return;
}

void CMainFrame::GetTextPaneSize( CSize &textSize ) const
{
     int      textHeight = theApp.GetProfileInt( "Settings", "EditWinHeight", -1 );  
     int      textWidth  = theApp.GetProfileInt( "Settings", "EditWinWidth",  -1 );  

     if ((textHeight >= 0) && (textWidth >= 0))
     {
          textSize.cx = textWidth;
          textSize.cy = textHeight;
     }

     return;
}

void CMainFrame::GetHelpPaneSize( CSize &helpSize ) const
{
     int      helpHeight = theApp.GetProfileInt( "Settings", "HelpWinHeight", -1 );  
     int      helpWidth  = theApp.GetProfileInt( "Settings", "HelpWinWidth",  -1 );  

     if ((helpHeight >= 0) && (helpWidth >= 0))
     {
          helpSize.cx = helpWidth;
          helpSize.cy = helpHeight;
     }

     return;
}

void CMainFrame::OnSize(UINT nType, int cx, int cy) 
{
     CFrameWnd::OnSize(nType, cx, cy);
     
     if (progressCreated)
     {
          CRect iRect;
          m_wndStatusBar.GetItemRect( 2, iRect );

          WINDOWPLACEMENT wp;

          BOOL   gotPlace = m_progressCtrl.GetWindowPlacement( &wp );
          wp.rcNormalPosition = iRect;
          BOOL   setPlace = m_progressCtrl.SetWindowPlacement( &wp );

          CnfAssert( gotPlace );
          CnfAssert( setPlace );
     }
}

void CMainFrame::UpdateStatusBar()
{
     CRect iRect;
     static BOOL dontBother = FALSE;
     static int oldDoneWidth = -1;

     if (dontBother)
          return;

     m_wndStatusBar.GetItemRect( 2, iRect );

     int       vBord;
     int       hBord;
     int       sepSize;

     CStatusBarCtrl &ctl = m_wndStatusBar.GetStatusBarCtrl();
          
     ctl.GetBorders( hBord, vBord, sepSize );

     int     paneHeight = iRect.Height() + 1;
     int       paneWidth  = iRect.Width() + 1;

     if ((paneHeight <= 4) || (paneWidth <= 4))
          return;

     iRect.top    += 2;
     iRect.bottom -= 2;
     iRect.left   += 2;
     iRect.right  -= 2;

     paneHeight -= 4;
     paneWidth  -= 4;;

     int       doneWidth = 0;

     if (m_total > 0)
          doneWidth = (m_sofar * paneWidth) / m_total;

     if (doneWidth != oldDoneWidth)
     {
          CDC *dc = m_wndStatusBar.GetDC();

          if (dc != NULL)
          {
               CBrush *foreBrush = CBrush::FromHandle( (HBRUSH)::GetStockObject( LTGRAY_BRUSH ) );
               CBrush *backBrush = CBrush::FromHandle( (HBRUSH)::GetStockObject( WHITE_BRUSH ) );

               if (doneWidth > 0)
               {
                    CRect   doneRect( iRect.left, iRect.top, 
                                          iRect.left + doneWidth - 1, iRect.bottom
                                        );
                    dc->FillRect( doneRect, foreBrush );
               }

               if (doneWidth < paneWidth)
               {
                    CRect     notDoneRect( iRect.left + doneWidth, iRect.top,
                                             iRect.right, iRect.bottom
                                           );
                    dc->FillRect( notDoneRect, backBrush );
               }
          }

          oldDoneWidth = doneWidth;
     }

     if ((m_total == m_sofar) && (m_sofar > 0))
     {
          CString dispStr;
     
          dispStr.Format( "%i options loaded", m_items );

          AdjustPaneWidth( 2, dispStr );

          m_wndStatusBar.SetPaneText( 2, dispStr, TRUE );
          dontBother = TRUE;
     }

}

BOOL CMainFrame::LoadFrame(UINT nIDResource, DWORD dwDefaultStyle, CWnd* pParentWnd, CCreateContext* pContext) 
{
     // TODO: Add your specialized code here and/or call the base class

     DWORD     style = dwDefaultStyle & ~FWS_ADDTOTITLE;
     
     return CFrameWnd::LoadFrame(nIDResource, style, pParentWnd, pContext);
}


void CMainFrame::ForceStatusBarUpdate()
{
     m_wndStatusBar.SendMessage( WM_IDLEUPDATECMDUI );
     m_wndStatusBar.UpdateWindow();
}


BOOL CMainFrame::GetExpanded() 
{
     BOOL      expanded = FALSE;

     CnfDoc *theDoc = static_cast< CnfDoc *>(GetActiveDocument());
     
     if (theDoc != NULL)
     {
          OptionTree *tview = theDoc->GetTreeView();

          if (tview != NULL)
          {    
               expanded = tview->Expanded();
          }
     }

     return( expanded );
}

void CMainFrame::SetExpandAll( BOOL expanded )
{
}

void CMainFrame::ActivateNextView( BOOL next )
{
     CWnd      *curAct = (CWnd *)GetActiveView();

     if (curAct == m_wndSplitter2.GetPane(0,0)) // tree
     {
          if (next)
          {
               SetActiveView( (CView *)m_wndSplitter2.GetPane(0,1) );
          }
          else
          {
               SetActiveView( (CView *)m_wndSplitter.GetPane(1,0) );
          }
     }
     else if (curAct == m_wndSplitter2.GetPane(0,1)) // form
     {
          if (next)
          {
               SetActiveView( (CView *)m_wndSplitter.GetPane(1,0) );
          }
          else
          {
               SetActiveView( (CView *)m_wndSplitter2.GetPane(0,0) );
          }
     }
     else if (curAct == m_wndSplitter.GetPane(1,0)) // help
     {
          if (next)
          {
               SetActiveView( (CView *)m_wndSplitter2.GetPane(0,0) );
          }
          else
          {
               SetActiveView( (CView *)m_wndSplitter2.GetPane(0,1) );
          }
     }
     else
     {
          //   no active view? go to tree pane
          //
          SetActiveView((CView*)m_wndSplitter2.GetPane(0,0));
     }
}





void CMainFrame::UpdateLoadGraph( int sofar, int total, int items )
{
     m_sofar = sofar;
     m_total = total;
     m_items = items;

     return;
}


/////////////////////////////////////////////////////////////////////////////
//   command handlers

void CMainFrame::OnClose() 
{
     if (ExternalEditorActive())
     {
          return;
     }

     // TODO: Add your message handler code here and/or call default
     CnfDoc *theDoc = static_cast< CnfDoc *>(GetActiveDocument());

     if (theDoc != NULL)
     {
          if (! theDoc->CanCloseFrame( this ))
               return;
     }

     CFrameWnd::OnClose();
}

void CMainFrame::OnSearch() 
{
     CnfDoc *theDoc = static_cast< CnfDoc *>(GetActiveDocument());

     if (theDoc != NULL)
     {
          theDoc->StartSearch();
     }
}

void CMainFrame::OnSearchNext() 
{
     CnfDoc *theDoc = static_cast< CnfDoc *>(GetActiveDocument());

     if (theDoc != NULL)
     {
          theDoc->SearchNext();
     }
}

void CMainFrame::OnExpandall() 
{
     CnfDoc *theDoc = static_cast< CnfDoc *>(GetActiveDocument());
     
     if (theDoc != NULL)
     {
          OptionTree *tview = theDoc->GetTreeView();

          if (tview != NULL)
          {
               if (tview->Expanded())
               {
                    SetExpandAll( FALSE );
                    tview->ExpandAll( FALSE );
               }
               else
               {
                    tview->ExpandAll( TRUE );
                    SetExpandAll( TRUE );
               }
          }

     }
}


void CMainFrame::OnCollapseall() 
{
     CnfDoc *theDoc = GetDoc();
     
     if (theDoc != NULL)
     {
          OptionTree *tview = theDoc->GetTreeView();

          if (tview != NULL)
          {
               tview->CollapseAll();
          }
     }
}


/////////////////////////////////////////////////////////////////////////////
//   UI command enable/disable stuff


void CMainFrame::OnUpdateHeader(CCmdUI* pCmdUI)
{
     pCmdUI->Enable();
}


void CMainFrame::OnUpdateProgress(CCmdUI* pCmdUI)
{
     pCmdUI->Enable();

     static BOOL done = FALSE;

     if (done || ((m_sofar > 0) && (m_sofar == m_total)))
     {
          CString itemStr;

          itemStr.Format( "%i options loaded", m_items );

          pCmdUI->SetText( itemStr );

          done = TRUE;
     }
     else
          UpdateStatusBar();
}


void CMainFrame::OnUpdateModified(CCmdUI* pCmdUI)
{
     BOOL      enabled = FALSE;

     CnfDoc *doc = GetDoc();

     if (doc != NULL)
     {
          enabled = doc->IsModified();
     }

     pCmdUI->Enable( enabled );
}


void CMainFrame::OnUpdateSearchagain(CCmdUI* pCmdUI) 
{
     BOOL      enabled = CnfDoc::m_searching;

     if (enabled)
     {
          enabled = ! ExternalEditorActive();
     }

     pCmdUI->Enable( enabled );
}


void CMainFrame::OnUpdateFileSave(CCmdUI* pCmdUI) 
{
     BOOL      enabled = FullyLoaded();

     if (enabled)
     {
          CnfDoc *doc = GetDoc();
          CnfAssert( doc != NULL );

          enabled = doc->IsModified();
     }

     if (enabled)
     {
          enabled = ! ExternalEditorActive();
     }

     pCmdUI->Enable( enabled );
}


void CMainFrame::OnUpdateExpandall(CCmdUI* pCmdUI) 
{
     BOOL      enabled = FullyLoaded();

     if (enabled)
     {
          enabled = ! ExternalEditorActive();
     }

     pCmdUI->Enable( enabled );
}


void CMainFrame::OnUpdateCollapseall(CCmdUI* pCmdUI) 
{
     BOOL      enabled = FullyLoaded();

     if (enabled)
     {
          enabled = ! ExternalEditorActive();
     }

     pCmdUI->Enable( enabled );
}


/////////////////////////////////////////////////////////////////////////////
//   helpers


const int MAXHEADERWIDTH = 250;

void CMainFrame::AdjustPaneWidth( int pane, const CString &st )
{
     CDC      *dc = m_wndStatusBar.GetDC();
     CnfAssert( dc != NULL );

     CFont    *sbFont = m_wndStatusBar.GetFont();
     CFont    *oldFont = dc->SelectObject( sbFont );

     CSize     ext = dc->GetTextExtent( st );

     dc->SelectObject( oldFont );

     int       twidth = min( ext.cx, MAXHEADERWIDTH );

     UINT id, style;
     int       width;
     m_wndStatusBar.GetPaneInfo( pane, id, style, width );

     if (twidth > width)
     {
          m_wndStatusBar.SetPaneInfo( pane, id, style & ~SBPS_DISABLED, twidth );
     }
}


CnfDoc * CMainFrame::GetDoc()
{
     return( static_cast< CnfDoc *>(GetActiveDocument()) );
}


BOOL CMainFrame::FullyLoaded()
{
     BOOL      enabled = FALSE;

     CnfDoc *theDoc = GetDoc();

     if (theDoc != NULL)
          enabled = theDoc->FullyLoaded();

     return( enabled );
}


void CMainFrame::OnUpdateSearchmenu(CCmdUI* pCmdUI) 
{
     BOOL      enabled = ! ExternalEditorActive();

     pCmdUI->Enable( enabled );
}

void CMainFrame::OnUpdateAppExit(CCmdUI* pCmdUI) 
{
     BOOL      enabled = ! ExternalEditorActive();

     pCmdUI->Enable( enabled );
}


void CMainFrame::OnEditfont() 
{
     CView     *view = static_cast< CView * >( m_wndSplitter2.GetPane(0,1) );
     CnfAssert( view->IsKindOf( RUNTIME_CLASS( OptionEditView ) ) );

     OptionEditView *sview = static_cast< OptionEditView * >( view );

     if (sview != NULL)
     {
          sview->EditFont();
     }
}

void CMainFrame::OnTreefont() 
{
     CView     *view = static_cast< CView * >( m_wndSplitter2.GetPane(0,0) );
     CnfAssert( view->IsKindOf( RUNTIME_CLASS( OptionTree ) ) );

     OptionTree *tview = static_cast< OptionTree * >( view );

     if (tview != NULL)
     {
          tview->EditFont();
     }
}

void CMainFrame::OnHelpfont() 
{
     CView     *view = static_cast< CView * >( m_wndSplitter.GetPane(1,0) );
     CnfAssert( view->IsKindOf( RUNTIME_CLASS( HelpView ) ) );

     HelpView  *hview = static_cast< HelpView * >( view );

     if (hview != NULL)
     {
          hview->EditFont();
     }
}

void CMainFrame::RecalcSplitterLayout()
{
     CSize treePaneSize( 100, 100 );
     CSize textPaneSize( 150, 100 );
     CSize helpPaneSize( 250, 100 );
     int   width = 275;
     int   height = 200;

     CRect  cliSize;

     GetClientRect( cliSize );

     if ((cliSize.Width() > 0) && (cliSize.Height() > 0))
     {
          width  = cliSize.Width();
          height = cliSize.Height();

          treePaneSize = CSize( width * 2 / 5, height * 4 / 5 );
          textPaneSize = CSize( width * 3 / 5, height * 4 / 5 );
          helpPaneSize = CSize( width,         height / 5 );
     }

     GetTreePaneSize( treePaneSize );
     GetTextPaneSize( textPaneSize );
     GetHelpPaneSize( helpPaneSize );

     m_wndSplitter.SetRowInfo( 0, treePaneSize.cy, 0 );
     m_wndSplitter.SetRowInfo(1, helpPaneSize.cy, 0 );
     m_wndSplitter2.SetRowInfo( 0, textPaneSize.cy, 0 );
     m_wndSplitter2.SetColumnInfo( 0, treePaneSize.cx, 0 );
     m_wndSplitter2.SetColumnInfo( 1, textPaneSize.cx, 0 );
     m_wndSplitter.RecalcLayout();
     m_wndSplitter2.RecalcLayout();
}

void CMainFrame::DontSaveSettings()
{
     m_saveSettings = FALSE;
}
