#include  "stdafx.h"
#include  <vector>
#include  "levels.h"
#include  "cstrutil.h"
#include "CnfAsrt.h"

#define FILREV "$Revision: $"

int level = AllLevels;


struct DescAssoc
{
     CString   fname;
     int       level;
     CString   desc;
};


vector< DescAssoc, allocator< DescAssoc > > levelDescs;


static CString FileLevelDesc( const char *filename, int level );
static BOOL AlreadyDescribed( const char *filename, int level );
static int LookupDesc( const char *filename, int level );
static void RegisterLevel( const char *filename, int level, const char *desc );

static BOOL hideSecrets = TRUE;


void RegisterLevel( const char *filename, const char *level, const char *desc )
{
     CnfAssert( level != NULL );
     CnfAssert( isdigit( level[ 0 ] ) );

     RegisterLevel( filename, atoi( level ), desc );
}

static void RegisterLevel( const char *filename, int level, const char *desc )
{
     CnfAssert( filename != NULL );
     CnfAssert( desc != NULL );
     CnfAssert( ! AlreadyDescribed( filename, level ) );

     DescAssoc temp;
     temp.fname = filename;
     temp.level = level;

     if (strlen( desc ) > 0)
          temp.desc = desc;
     else
     {
          temp.desc = filename;
          
          int       dpos = temp.desc.Find( '.' );

          if (dpos >= 0)
          {
               temp.desc = temp.desc.Left( dpos );
          }

          temp.desc.MakeUpper();
     }

     lrTrim( temp.desc );

     int       sofar = levelDescs.size();

     levelDescs.resize( sofar + 1, temp );

     return;
}


CString GetLevelDesc( const char *filename, int level )
{
     CString   result;

     if (filename != NULL)
     {
          CnfAssert( strlen( filename ) > 0 );
          result = FileLevelDesc( filename, level );
     }
     else
     {
          switch (level)
          {
               case AllLevels:
                    result  = "Configuration Editor";
                    break;

               case 1:
                    result = "Hardware Setup";
                    break;

               case 3:
                    result = "Security and Accounting";
                    break;

               case 4:
                    result = "General Setup";
                    break;

               case 6:
                    result = "Text Blocks";
                    break;

               default:
                    result.Format( "Level %i Setup", level );
                    break;
          }
     }

     return( result );
}


BOOL IsSecretLevel( int level )
{
     return( hideSecrets && (level != 1) && (level != 3) && (level != 4) && (level != 6) );
}


BOOL IsSecretLevel( LPCTSTR st )
{
     return( IsSecretLevel( atoi( st ) ) );
}


static CString FileLevelDesc( const char *filename, int level )
{
     int       descPos = LookupDesc( filename, level );

     if (descPos < 0)
     {
          RegisterLevel( filename, level, "" );

          descPos = LookupDesc( filename, level );
     }

     CnfAssert( descPos >= 0 );
     CnfAssert( descPos < levelDescs.size() );

     return( levelDescs[ descPos ].desc );
}


static BOOL AlreadyDescribed( const char *filename, int level )
{
     return( LookupDesc( filename, level ) >= 0 );
}


static int LookupDesc( const char *filename, int level )
{
     int       result = -1;

     for ( int count = 0; count < levelDescs.size(); ++count )
     {
          DescAssoc &ld = levelDescs[ count ];          

          if ((ld.fname.CompareNoCase( filename ) == 0) &&
              (ld.level == level)
             )
          {
               result = count;
               break;
          }
     }

     return( result );
}


void HideSecrets( BOOL hide )
{
     hideSecrets = hide;
}
