// LangComb.cpp : implementation file
//

#include "stdafx.h"
#include "wgscnf.h"
#include "LangComb.h"
#include "OptEdit.h"
#include "CnfAsrt.h"

#define FILREV "$Revision: $"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// LangCombo

int LangCombo::m_selNo = 0;


LangCombo::LangCombo()
{
}

LangCombo::~LangCombo()
{
}


BEGIN_MESSAGE_MAP(LangCombo, CComboBox)
     //{{AFX_MSG_MAP(LangCombo)
     ON_CONTROL_REFLECT(CBN_SELCHANGE, OnSelchange)
     //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// LangCombo message handlers

BOOL LangCombo::Create( const CRect &rect, CWnd *parent, UINT id, CFont *font, int tsize, int nlingo, const char **chooselist )
{
     CRect     realRect( rect );

     int       frameAdd = (4 * GetSystemMetrics( SM_CYDLGFRAME )) +
                          (3 * GetSystemMetrics( SM_CYBORDER ));

     int       realHeight = ((nlingo + 1) * tsize) + frameAdd;

     realRect.bottom = realRect.top + realHeight;

     BOOL result = CComboBox::Create( WS_VISIBLE | WS_CHILD | CBS_DROPDOWNLIST,
                                      realRect, parent, id
                                    );
                         
     CnfAssert( result );

     if (font != NULL)
          SetFont( font );

     for ( int count = 0; count < nlingo; ++count )
          AddString( chooselist[ count ] );

     SetCurSel( m_selNo );

     return( result );
}

void LangCombo::OnSelchange() 
{
     // TODO: Add your control notification handler code here
     m_selNo = GetCurSel();

     OptionEditView *parent = static_cast< OptionEditView *>( GetParent() );

     parent->SelectLanguage( m_selNo );
}

void LangCombo::SelectLanguage( int nLang )
{
     CnfAssert( nLang >= 0 );
     CnfAssert( nLang < GetCount() );

     SetCurSel( nLang );
}
