// HelpView.h : header file
//

#if ! defined( HelpView_H )
#  define HelpView_H

/////////////////////////////////////////////////////////////////////////////
// HelpView view

class HelpView : public CEditView
{
protected:
	HelpView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(HelpView)

// Attributes
public:
	void EditFont();
	CFont * GetCurFont();
	static void SetFontChars( const LOGFONT &lf, BOOL replaceOld = FALSE );
	static CFont * ourFont;
//	static CBrush m_brush;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(HelpView)
	public:
	virtual BOOL Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext = NULL);
	protected:
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

//	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
//	virtual BOOL OnChildNotify(UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pLResult);

// Implementation
protected:
	virtual ~HelpView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(HelpView)
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnFilePrint();
	afx_msg void OnFilePrintPreview();
	afx_msg void OnTextreport();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
//	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
//	afx_msg HBRUSH CtlColor(CDC* pDC, UINT nCtlColor);
private:
	void Redraw( const CString &theText );
	static BOOL m_fontSet;
	static CString Reflow( const CString &sourceText );
};

/////////////////////////////////////////////////////////////////////////////

#endif
