// HelpView.cpp : implementation file
//

#include "stdafx.h"
#include "WgsCnf.h"
#include "CnfDoc.h"
#include "HelpView.h"
#include "Modifier.h"
#include "cstrutil.h"
#include "CnfAsrt.h"
#include "mainfrm.h"
#include "regutil.h"

#define FILREV "$Revision: $"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// HelpView

IMPLEMENT_DYNCREATE(HelpView, CEditView)


//const COLORREF backColor = RGB( 210, 255, 255 );
//const COLORREF textColor = RGB( 0,   0,   0   );


//CBrush HelpView::m_brush( backColor );
CFont *HelpView::ourFont = NULL;
BOOL HelpView::m_fontSet = NULL;


HelpView::HelpView()
{
     m_fontSet = FALSE;
}

HelpView::~HelpView()
{
     if (ourFont != NULL)
     {
          LOGFONT   lf;

          ourFont->GetLogFont( &lf );

          SaveLogfont( "settings", "HelpViewFontInfo", lf );

          delete ourFont;
          ourFont = NULL;
     }
}

//   ON_WM_ERASEBKGND()
//   ON_WM_CTLCOLOR_REFLECT()

BEGIN_MESSAGE_MAP(HelpView, CEditView)
     //{{AFX_MSG_MAP(HelpView)
     ON_WM_CONTEXTMENU()
     ON_COMMAND(ID_FILE_PRINT, OnFilePrint)
     ON_COMMAND(ID_FILE_PRINT_PREVIEW, OnFilePrintPreview)
     ON_COMMAND(IDD_TEXTREPORT, OnTextreport)
     //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// HelpView drawing

//void HelpView::OnDraw(CDC* pDC)
//{
//     CDocument* pDoc = GetDocument();
//     // TODO: add draw code here
//
//     COLORREF color = pDC->GetBkColor();
//
//     return;
//}

/////////////////////////////////////////////////////////////////////////////
// HelpView diagnostics

#ifdef _DEBUG
void HelpView::AssertValid() const
{
     CEditView::AssertValid();
}

void HelpView::Dump(CDumpContext& dc) const
{
     CEditView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// HelpView message handlers

void HelpView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
     if (lHint == SelectionChanged)
     {
          Modifier *hint = static_cast< Modifier * >( pHint );

          CString theText;
          
          if (hint->treeData->lineDesc.GetLength() > 0)
          {
               theText = hint->treeData->lineDesc;

               theText += "\r\n"
                         "\r\n";
          }

          theText += Reflow( hint->treeData->helpText );

          Redraw( theText );
     }

     return;
}

BOOL HelpView::PreCreateWindow(CREATESTRUCT& cs) 
{
     // TODO: Add your specialized code here and/or call the base class
     cs.style &= ~WS_HSCROLL;
     
     BOOL res = CEditView::PreCreateWindow(cs);

     cs.style &= ~WS_HSCROLL;
     cs.style &= ~ES_AUTOHSCROLL;

     return( res );
}


//BOOL HelpView::OnChildNotify(UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pLResult) 
//{


     // TODO: Add your specialized code here and/or call the base class



// If "message" is not the message you're after, do default processing: 

// For 16-bit applications change WM_CTLCOLOREDIT to WM_CTLCOLOR 

//   if (message != WM_CTLCOLOREDIT)
//   {
//      return( CEditView::OnChildNotify(message, wParam, lParam, pLResult) );
//   }


// Set the text foreground to blue
//   HDC hdcChild = (HDC)wParam;
////   SetTextColor(hdcChild, textColor );


// Set the text background to cyan:
//   SetBkColor(hdcChild, backColor );


// Send what would have been the return value of OnCtlColor() - the // brush handle - back in pLResult: 

//   *pLResult = (LRESULT)(m_brush.GetSafeHandle());


// Return TRUE to indicate that the message was handled:
//   return TRUE;     
//}


CString HelpView::Reflow( const CString &sourceText )
{
     const char *inText = sourceText;
     CString   outText;

     if (inText[ 0 ] == ' ')
     {
          ++inText;
     }

     while (inText[ 0 ] == ' ')
     {
          outText += ' ';
          ++inText;
     }

     while (inText[ 0 ] != 0)
     {
          const char *crLf = strstr( inText, "\r\n" );

          int       crLfPos = -1;

          if (crLf != NULL)
               crLfPos = crLf - inText;

          if (crLfPos < 0)
          {
               outText += inText;
               inText += strlen( inText );
          }
          else
          {
               for ( int count = 0; count < crLfPos; ++count )
               {
                    outText += inText[ count ];
               }
               inText += crLfPos;

               //   double CRLF pairs are paragraph separators;
               //   we like them.  we keep them.
               //
               if ((strlen( inText ) >= 4) &&
                    (strncmp( inText + 2, "\r\n", 2 ) == 0)
                  ) 
               {
                    outText += "\r\n\r\n";
                    inText += 4;

                    if (inText[ 0 ] == ' ')
                    {
                         ++inText;
                    }
               }
               else // replace single CRLF pairs with spaces
               {
                    inText += 2;

                    if (inText[ 0 ] == ' ')
                    {
                         ++inText;
                    }

                    if (inText[ 0 ] == ' ')
                    {
                         outText += "\r\n";

                         while (inText[ 0 ] == ' ')
                         {
                              outText += ' ';
                              ++inText;
                         }
                    }
                    else
                    {
                         outText += ' ';
                    }
               }
          }
     }

     return( outText );
}

void HelpView::SetFontChars( const LOGFONT &lf, BOOL replaceOld )
{
     if ((ourFont != NULL) && replaceOld)
     {
          delete ourFont;
          ourFont = NULL;
     }

     if (ourFont == NULL)
     {
          ourFont = new CFont;

          BOOL      fontCreated = ourFont->CreateFontIndirect( &lf );
          CnfAssert( fontCreated );

          m_fontSet = FALSE;

     }
}

CFont * HelpView::GetCurFont()
{
     return( ourFont );
}

void HelpView::Redraw( const CString &theText )
{
     CEdit &ec = GetEditCtrl();

     if (! m_fontSet)
     {
          if (ourFont != NULL)
          {
               ec.SetFont( ourFont );
               m_fontSet = TRUE;
          }
     }

     ec.SetWindowText( theText );

     ec.SetReadOnly( TRUE );
}

void HelpView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
     (void)pWnd;
     (void)point;

     EditFont();
}

BOOL HelpView::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
     BOOL result = CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);

     if (result)
     {
          LOGFONT   lf;

          if (ReadLogfont( "settings", "HelpViewFontInfo", lf ))
          {
               SetFontChars( lf, TRUE );
          }
     }

     return( result );
}

void HelpView::EditFont()
{
     CEdit    &ec = GetEditCtrl();
     CFont    *font = ec.GetFont();

     CnfAssert( font != NULL );

     LOGFONT   lf;
     font->GetLogFont( &lf );

     CFontDialog dlg( &lf, CF_SCREENFONTS, NULL, this );

     if (dlg.DoModal() == IDOK)
     {
          SetFontChars( lf, TRUE );

          CString theText;
          GetWindowText( theText );
          Redraw( theText );
     }
}


void HelpView::OnFilePrint() 
{
     CnfDoc *doc = static_cast< CnfDoc * >( GetDocument() );

     if (doc != NULL)
     {
          OptionTree *tv = doc->GetTreeView();
          CnfAssert( tv != NULL );

          tv->Print();
     }
}

void HelpView::OnFilePrintPreview() 
{
     CnfDoc *doc = static_cast< CnfDoc * >( GetDocument() );

     if (doc != NULL)
     {
          OptionTree *tv = doc->GetTreeView();
          CnfAssert( tv != NULL );

          tv->PrintPreview();
     }
}

void HelpView::OnTextreport() 
{
     CnfDoc *doc = static_cast< CnfDoc * >( GetDocument() );

     if (doc != NULL)
     {
          OptionTree *tv = doc->GetTreeView();
          CnfAssert( tv != NULL );

          tv->TextReport();
     }
}
