/***************************************************************************
 *                                                                         *
 *  EnumComb.H                                                            *
 *                                                                         *
 *  Combo box class for WgsCnf enums                                       *
 *                                                                         *
 *                                                  - Paul Roub  08/20/96  *
 *                                                                         *
 ***************************************************************************/

// EnumComb.h : header file
//

#if ! defined( ENUMCOMBO_H )
#  define ENUMCOMBO_H

/////////////////////////////////////////////////////////////////////////////
// EnumCombo window

class EnumCombo : public CComboBox
{
// Construction
public:
	void SetOriginalValue( const CString &oval );
     void SetKey( const CString &key );
     EnumCombo();
     BOOL Create(
          CWnd       *parent, 
          int         left, 
          int         right, 
          int         top,
          int         tsize,
          int         frameHeight,
          int         frameWidth,
          UINT        id,
          const char *enlist,
          CFont      *font,
          CDC        *dc
     );
     static CString NextPart( CString &comboList );
     static int ComboCount( const CString &st );

// Attributes
public:

// Operations
public:

// Overrides
     // ClassWizard generated virtual function overrides
     //{{AFX_VIRTUAL(EnumCombo)
     //}}AFX_VIRTUAL

// Implementation
public:
     virtual ~EnumCombo();

     // Generated message map functions
protected:
     //{{AFX_MSG(EnumCombo)
     afx_msg void OnSelchange();
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG

     DECLARE_MESSAGE_MAP()
private:
	CnfDoc * GetDocument();
	CString m_origValue;
     Modifier m_count;
};

/////////////////////////////////////////////////////////////////////////////

#endif
