// EnumComb.cpp : implementation file
//

#include "stdafx.h"
#include "WgsCnf.h"
#include "CnfDoc.h"
#include "Modifier.h"
#include "EnumComb.h"
#include "OptEdit.h"
#include "CStrUtil.h"
#include "CnfAsrt.h"

#define FILREV "$Revision: $"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// EnumCombo

EnumCombo::EnumCombo()
{
}

EnumCombo::~EnumCombo()
{
}


BEGIN_MESSAGE_MAP(EnumCombo, CComboBox)
     //{{AFX_MSG_MAP(EnumCombo)
     ON_CONTROL_REFLECT(CBN_SELCHANGE, OnSelchange)
     ON_WM_CHAR()
     //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// EnumCombo message handlers

void EnumCombo::SetKey( const CString &key )
{    
     m_count.itemKey = key;
}

void EnumCombo::OnSelchange() 
{
     int       curSel = GetCurSel();

     CString value;
     GetLBText( curSel, value );

     BOOL      changed = ! (value == m_origValue);

     OptionEditView *theView = static_cast< OptionEditView * >( GetParent() );
     CnfDoc *theDoc = GetDocument();

     if (changed)
     {
          theDoc->UpdateAllViews( theView, ItemModified, &m_count );
     }
     else
     {
          theDoc->UpdateAllViews( theView, ItemUnModified, &m_count );
     }

     TreeData ourData;

     theDoc->Lookup( m_count.itemKey, ourData );

     theDoc->Set( m_count.itemKey, ourData );

     ourData.opPtr->curValue = value;

     //   ourData.opPtr->flags |= ANYCHG;
     //   ourData.opPtr->file->flags |= ANYCHG;

     //   trigger hinging as necessary
     //
     m_count.oldKey = m_count.itemKey;
     m_count.treeData = &ourData;
     theDoc->UpdateAllViews( theView, SelectionChanged, &m_count );

     return;
}


BOOL
EnumCombo::Create(
CWnd       *parent, 
int         left, 
int         right, 
int         top,
int         tsize,
int         frameHeight,
int         frameWidth,
UINT        id,
const char *enlist,
CFont      *font,
CDC        *theDC
)
{
     CString   comboList( enlist );
     int       comboCount = ComboCount( comboList );

     CnfAssert( theDC != NULL );

     int       borderHeight = GetSystemMetrics( SM_CYBORDER );
     int       boxHeight = (tsize * (comboCount + 1)) + (4 * frameHeight) + (3 * borderHeight);

     int       textWidth = 0;

     for ( int count = 0; count < comboCount; ++count )
     {
          CString item = NextPart( comboList );

          CSize     itemSize = theDC->GetTextExtent( item );

          if (itemSize.cx > textWidth)
          {
               textWidth = itemSize.cx;
          }
     }

     int       boxWidth = textWidth + (frameWidth * 4) + tsize;

     int       comboBottom = top + boxHeight;

     CRect comboRect( left,  top, left + boxWidth, comboBottom );

     BOOL result = CComboBox::Create( WS_VISIBLE | WS_CHILD | CBS_DROPDOWNLIST,
                                      comboRect,
                                      parent,
                                      ID_MYGROUP + 6
                                    );

     CnfAssert( result );

     if (result)
     {
          if (font != NULL)
               SetFont( font );

          comboList = enlist;

          for ( int count = 0; count < comboCount; ++count )
          {
               CString item = NextPart( comboList );

               AddString( item );
          }
     }

     return( result );
}


int EnumCombo::ComboCount( const CString &st )
{
     CString   victim( st );

     int       count = 0;

     while (NextPart( victim ) != "")
          ++count;

     return( count );
}

CString EnumCombo::NextPart( CString &comboList )
{
     CString result;

     lTrim( comboList );

     if (comboList.GetLength() > 0)
     {
          int       spacePos = comboList.Find( ' ' );

          if (spacePos > 0)
          {
               result = comboList.Left( spacePos );
               comboList = comboList.Mid( spacePos + 1 );
          }
          else
          {
               result = comboList;
               comboList = "";
          }
     }

     return( result );
}


void EnumCombo::SetOriginalValue( const CString &oval )
{
     m_origValue = oval;
}

void EnumCombo::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
     CComboBox::OnChar(nChar, nRepCnt, nFlags);

     if (nChar == VK_RETURN)
     {
          CnfDoc *doc = GetDocument();

          doc->UpdateAllViews( NULL, NextVisible );
     }
}

CnfDoc * EnumCombo::GetDocument()
{
     OptionEditView *theView = static_cast< OptionEditView * >( CWnd::GetParent() );
     CnfAssert( theView != NULL );

     CnfDoc *theDoc = static_cast< CnfDoc * >( theView->GetDocument() );
     CnfAssert( theDoc != NULL );

     return( theDoc );
}
