/***************************************************************************
 *                                                                         *
 *   EDTOFF.H                                                              *
 *                                                                         *
 *   Copyright (c) 1993-1996 Galacticomm, Inc.    All rights reserved.     *
 *                                                                         *
 *   Offline editor registration and centralized handling routines, as     *
 *   used by CNF and Menu Tree (header).                                   *
 *                                                                         *
 *                                               - R. Stein  1/21/93       *
 *                                                                         *
 ***************************************************************************/

#ifndef __EDTOFF_H
#define __EDTOFF_H

//--- editor handler routine return codes ---
#define EONOTME -1             // I'm not the editor specified in "command" 
#define EOERROR 0   // some kind of error occurred (see about edterr below) 
#define EOABORT 1             // operator aborted editing, recover old data 
#define EONOCHG 2                                      // no change to data 
#define EOTRUNC 3                            // data truncated (ref ibsize) 
#define EOSAVE  4                           // Done editing, save this data 
#define EOLATER 5
#define EOWHICH 0x07                         // mask for above return codes 
#define EOPGUP  0x80     // in add'n to SAVE or NOCHG, skip to option above 
#define EOPGDN  0x40     // in add'n to SAVE or NOCHG, skip to option below 
                // (when EONOCHG/EOTRUNC/EOSAVE is unknown, EOSAVE is used) 

extern INT nedts;                  // number of editor routines            
extern LONG ibsize;                // bytes read in by impbuf()            
                                   // set whenever anyone returns EOTRUNC 
extern INT edtskp;                 // 1=allow PgUp or PgDn to end edit session
extern INT edtkey;                 // if edtskp and the retval is >= EONOCHG, 
                                   // then this can be the aborting character 
extern CHAR edterr[];       // editor error message                 

typedef INT EDTHANDLER(                           // Editor Handler routine 
     CHAR *command,                  // editor command line (per .MDF file) 
     CHAR *txtbuf,        // in-place editing buffer (NULL=already on disk) 
     UINT sizbuf);               // size of buffer in bytes (includes '\0') 

extern EDTHANDLER **edthandlers;// array of ptrs to editor handler routines 

VOID
regedtoff(                                    // register an offline editor 
EDTHANDLER *edthdl);    // ptr to editor handler (see EOXXXXX return codes) 

VOID
eospawn(VOID);  // register DLL, spawn(.exe), and system() editors handlers 
  // be sure to call eospawn() after all other editors have been registered 

INT
edtoff(                                                  // edit this stuff 
CHAR *command,                       // editor command line (per .MDF file) 
CHAR *txtbuf,             // in-place editing buffer (NULL=already on disk) 
UINT sizbuf,                     // size of buffer in bytes (includes '\0') 
CHAR *tfn);                                 // name to use for file, if any 
               // see EOXXXXX return codes (EONOTME means no handler found) 

BOOL
ExternalEditorActive();

BOOL
Finish(
int &rc
);

#endif                             // __EDTOFF_H                           
