// CnfDoc.h : interface of the CnfDoc class
//
//   this is our 'pseudo-document' -- there's no real document file,
//   but this is where the various options and there relationships get
//   presented in a way that fits the MFC document-view architecture.
//
//   all change notifications, etc. are funnelled through here
//
/////////////////////////////////////////////////////////////////////////////

#if ! defined( CnfDoc_H )
#  define CnfDoc_H

#include "option.h"
#include "OptTree.h"
#include "treedata.h"


class CnfDoc : public CDocument
{
protected: // create from serialization only
     CnfDoc();
     virtual ~CnfDoc();
     DECLARE_DYNCREATE(CnfDoc)

// Attributes
public:
     static BOOL m_searching;      // is there a search in progress?
     CString m_selected;           // the currently-selected item

// Operations
public:

// Overrides
     // ClassWizard generated virtual function overrides
     //{{AFX_VIRTUAL(CnfDoc)
     public:
     virtual BOOL OnNewDocument();
     virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);
     protected:
     virtual BOOL SaveModified();
     //}}AFX_VIRTUAL

// Implementation
public:
#ifdef _DEBUG
     virtual void AssertValid() const;
     virtual void Dump(CDumpContext& dc) const;
#endif

     OptionTree *                  //   opt tree view or NULL
     GetTreeView() const;          // get the option tree view

     void
     FinishExternal(               // notify that external editor has finished
     int rc);                      //   result code

     BOOL                          //   TRUE if the item is visible
     IsVisible(                    // check whether an option is visible
     const CString &key) const;    //   option's key

     void
     SearchNext();                 // look for the next matching entry

     void 
     StartSearch();                // begin a new search

     BOOL                          //   TRUE if item is valid
     ValidateCurrentItem();        // check current opt value's validity

     BOOL                          //   TRUE if loading is complete
     FullyLoaded() const;          // check where loading is finished

     void 
     SetFullyLoaded(               // notify that we are fully loaded
     BOOL loaded);

     void
     UpdateAllViews(               // update all views (MFC override)
     CView* pSender, 
     LPARAM lHint = 0L, 
     CObject* pHint = NULL);

     void 
     AddOption(                    // add an option to our list
     LPCTSTR filename,             //   option's name
     struct option *ldrop,         //   option's data
     const CString &helpText,      //   help text
     long bytesSoFar,              //   bytes read (all files)
     long totalBytes,              //   bytes to read (all files)
     int level,                    //   option's level
     FILE *fp = NULL,              //   option's file pointer
     const CString *levelHelpTextPtr = NULL);     // option's level description

     BOOL                          //   TRUE if we found it
     Lookup(                       // lookup an option by key
     const CString &key,           //   key to lookup
     TreeData &treeData) const;    //   option data (returned)

     BOOL                          //   TRUE if set successfully
     Set(                          // set an option's data
     const CString &key,           //   opt key
     const TreeData &treeData);    //   new tree data


// Generated message map functions
protected:
     //{{AFX_MSG(CnfDoc)
     afx_msg void OnFileSave();
     afx_msg void OnFileSaveAs();
     //}}AFX_MSG
     DECLARE_MESSAGE_MAP()

private:
     BOOL TreeItemContains( HTREEITEM item, const CString &text ) const;
     void AddHingee( const CString &hinge, const CString &hingee );
     BOOL CheckValid();

     int m_entries;
     int m_modFileCount;
     BOOL m_searchInHelpText;
     BOOL m_searchInValue;
     BOOL m_searchInNameAndDesc;
     int m_searchCount;
     BOOL m_searchingForward;
     BOOL m_fullyLoaded;
     CString m_searchText;
     CMapStringToOb map;
};

/////////////////////////////////////////////////////////////////////////////

//   hints passed to CnfDoc::UpdateAllViews()
//
const LPARAM NewDocument      = 1;
const LPARAM SelectionChanged = 2;
const LPARAM ItemModified     = 3;
const LPARAM ItemAdded        = 4;
const LPARAM ItemUnModified   = 5;
const LPARAM VisibleChange    = 6;
const LPARAM FileSaved        = 7;
const LPARAM NextVisible      = 8;
const LPARAM FocusOnEdit      = 9;


#endif
