/***************************************************************************
 *                                                                         *
 *  CnfAsrt.H                                                            *
 *                                                                         *
 *  Variable assertion handling for WgsCnf                                 *
 *                                                                         *
 *                                                  - Paul Roub  08/26/96  *
 *                                                                         *
 ***************************************************************************/

#if ! defined( CNFASSERT_H )
#  define CNFASSERT_H

#if defined( _DEBUG )    // let MFC handle it if debugging
#    define    CnfAssert(c)        ASSERT(c)
#elif defined( BETA )    // else catastro() if beta
#    define    CnfAssert(c)        ((c) ? ((VOID)0) :   \
                                    ThrowAssertion(__FILE__,__LINE__,#c))

void ThrowAssertion( const char *filename, int line, char *msg );

#else                    // else shut up and hope for the best
#    define    CnfAssert(c)   ((void)0)
#endif


#endif
