////////////////////////////////////////////////////////////////////////////
//
//  CnfAsrt.CPP
//
//  Assertion handling for WGSCNF (GUI version)
//
//  For debug builds, we use MFC asserts
//  For beta builds, we throw an exception
//  For release builds, we hope for the best
//
//                                                  - Paul Roub  08/30/96
//
/////////////////////////////////////////////////////////////////////////////

#include  "stdafx.h"

#if defined( BETA )

#include  "gcommlib.h"
#include  "CnfAsrt.h"

void ThrowAssertion( const char *filename, int line, char *msg )
{
     DWORD argList;
     static CHAR errMsg[512];
     static GBOOL recurs=FALSE;
     
     if (!recurs) {
          recurs=TRUE;
          if (strlen(msg) > sizeof(errMsg)-100) {
               msg[sizeof(errMsg)-100]='\0';
          }
          sprintf(errMsg,"\n%s %s ASSERTION FAILED: \"%s\", %s, line %lu\n",
                       ncdate(today()),nctime(now()),msg,filename,line);
          argList=(DWORD)errMsg;
          RaiseException(GCEXCEPTION_ASSERT,0,1,&argList);
          recurs=FALSE;
     }
}

#endif
