/***************************************************************************
 *                                                                         *
 *   WGSYSUP.C                                                             *
 *                                                                         *
 *   Copyright (c) 1996 Galacticomm, Inc.    All Rights Reserved.          *
 *                                                                         *
 *   This program controls the running of the " SVR_NAME " Server when       *
 *   running as an application.  This handles items prior to running       *
 *   WGSERVER.EXE.                                                         *
 *                                                                         *
 *                                        - Richard Skurnick 06/11/96      *
 *                                                                         *
 ***************************************************************************/

#include "stdafx.h"
#include "gcommlib.h"
#include "excphand.h"
#include "ShellCmd.h"
//#include "runapp.h"

#define FILREV "$Revision: 1 $"

Cffblk ffblk;

INT WINAPI
WinMain(
HINSTANCE hInstance,               // handle to current instance
HINSTANCE hPrevInstance,           // handle to previous instance
LPSTR lpCmdLine,                   // pointer to command line
INT nCmdShow)                      // show state of window
{
TRY
     CHAR *pTmp;
     CHAR path[2048];
     INT retVal;
     //struct ffblk ffblk;
     FILE *fp;
     HINSTANCE hInstance=GetModuleHandle(NULL);

     GetModuleFileName(hInstance,path,sizeof(path));
     if (!canRunGroup()) {
          MessageBox(NULL,NOPROCEED,
                    path,MB_ICONSTOP|MB_OK|MB_TASKMODAL);
          return(1);
     }
     if (! lpCmdLine[ 0 ]) {
          MessageBox(NULL,"WGSYSUP: YES/NO parameter missing!",path,
                     MB_ICONSTOP|MB_OK|MB_TASKMODAL);
          return(1);
     }
     if (!sameto(lpCmdLine,"YES") && !sameto(lpCmdLine,"NO")) {
          MessageBox(NULL,"WGSYSUP: Bad parameter passed!",path,
                     MB_ICONSTOP|MB_OK|MB_TASKMODAL);
          return(1);
     }
     if ((pTmp=strrchr(path,'\\')) != NULL
          || (pTmp=strrchr(path,'/')) != NULL) {
          *pTmp='\0';
          chdir(path);
          *pTmp='\\';
     }
     if (sameto(lpCmdLine,"YES")) {
          if (fnd1st(&ffblk,"wgsisup.flg",0)) {
               if ((fp=fopen("wgsabsd.flg",FOPWA)) != NULL) {
                    fprintf(fp,"The server shut down abnormally...\n");
                    fclose(fp);
               }
               unlink("wgsisup.flg");
          }
          if (fnd1st(&ffblk,"wgscata.flg",0)) {
               //runApp("wgsridx catastro","" SVR_NAME " Reindex Data Files",
               //       SW_SHOWDEFAULT,&retVal);

               ShellCommand( "wgsridx catastro", retVal, FALSE, "" SVR_NAME " Reindex Data Files" );

               if (retVal == 10) {
                    dfaVirgin("galfilk2",NULL);
                    //runApp("galfilkw",NULL,SW_SHOWDEFAULT,&retVal);
                    ShellCommand( "galfilkw", retVal, FALSE );
               }
               else if (retVal == 11) {
                    if ((fp=fopen("wgsridx.flg",FOPWA)) != NULL) {
                         fprintf(fp,"WGSRIDX error...\n");
                         fclose(fp);
                    }
                    unlink("wgsisup.flg");
                    return(1);
               }
               unlink("wgscata.flg");
          }
     }
     //App("wgsint",NULL,SW_SHOWDEFAULT,&retVal); // lpCmdLine == NO starts here
     ShellCommand( "wgsint", retVal, FALSE );
     if (retVal != 0) {
          return(retVal);
     }
     if (fnd1st(&ffblk,"wgscmaps.flg",0)) {
          //runApp("wgscmaps /m GALSSF","" SVR_NAME " Client Compress",
          //       SW_SHOWDEFAULT,&retVal);
          ShellCommand( "wgscmaps /m GALSSF", retVal, FALSE, "" SVR_NAME " Client Compress" );
          unlink("wgscmaps.flg");
     }
     if ((fp=fopen("wgsisup.flg",FOPWA)) != NULL) {
          fprintf(fp,"The server is up...\n");
          fclose(fp);
     }
     if ((fp=fopen("wgscata.flg",FOPWA)) != NULL) {
          fprintf(fp,"WGSRIDX may be required (for GALCAT fixup)...\n");
          fclose(fp);
     }
     //runApp("wgsup.bat",NULL,SW_SHOWDEFAULT,&retVal);
     if (fnd1st(&ffblk,"wgsup.bat",0)) {
          ShellCommand( "wgsup.bat", retVal, FALSE );
     }
     return(0);
EXCEPT
     return(1);
}