/***************************************************************************
 *                                                                         *
 *   WGSYSDN.C                                                             *
 *                                                                         *
 *   Copyright (c) 1996 Galacticomm, Inc.    All Rights Reserved.          *
 *                                                                         *
 *   This program controls the running of the " SVR_NAME " Server when       *
 *   running as an application.  This portion handles running items after  *
 *   WGSERVER.EXE shuts down.                                              *
 *                                                                         *
 *                                        - Richard Skurnick 06/11/96      *
 *                                                                         *
 *   Removed wgsevt?.bat and wgsclean.bat processing -- these functions    *
 *   are now handled by Event-?: and Cleanup: lines in WGSCLEAN.MDF        *
 *                                                                         *
 *                                               - Paul Roub 10/29/96      *
 *                                                                         *
 ***************************************************************************/

#include "stdafx.h"
#include "gcommlib.h"
#include "excphand.h"
#include "ShellCmd.h"

#define FILREV "$Revision: 1 $"

static DWORD                       //   return code
messageBoxTh(                      // open MessageBox
VOID *pInfo);                      //   argument

static BOOL                        //   TRUE if batch was run successfully
runBatch(                          // run and wait for a batch file
const char *cmdLine,               //   batch to run
int &retVal);                      //   batch file result code


INT WINAPI
WinMain(
HINSTANCE hInstance,               // handle to current instance
HINSTANCE hPrevInstance,           // handle to previous instance
LPSTR lpCmdLine,                   // pointer to command line
INT nCmdShow)                      // show state of window
{
TRY
     HANDLE hTh;
     DWORD thID;
     HWND hWin;
     DWORD exitCode;
     CHAR *pTmp;
     CHAR path[2048];
     INT retVal;
     CHAR msgBuffer[80];
     INT errcod;
     const CHAR *mbCaption= SVR_FULL " Failure!";

     (VOID)hPrevInstance;
     (VOID)lpCmdLine;
     (VOID)nCmdShow;
     GetModuleFileName(hInstance,path,sizeof(path));
     if (!canRunGroup()) {
          MessageBox(NULL,NOPROCEED,
                    path,MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(3);
     }
     if (lpCmdLine[0] == '\0') {
          MessageBox(NULL,"WGSYSDN: Option parameter missing!",path,
                     MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(3);
     }
     if ((pTmp=strrchr(path,'\\')) != NULL
          || (pTmp=strrchr(path,'/')) != NULL) {
          *pTmp='\0';
          chdir(path);
          *pTmp='\\';
     }
     //AllocConsole();
     switch (atoi(lpCmdLine)) {
     case 99:                      // Fault occured
          // this case is handled directly by WGSSVC that shows the same
          // MessageBox and waits 30 seconds so it is never executed
          // when run as a service
          hTh=CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)messageBoxTh,
                      (LPVOID)mbCaption,0,&thID);
          if (hTh == NULL) {
               errcod=0;   // should not happen
          }
          else if (WaitForSingleObject(hTh,30000) == WAIT_TIMEOUT) {
               if ((hWin=FindWindow(NULL,mbCaption)) != NULL) {
                    SendMessage(hWin,WM_CLOSE,0,0);
               }
               errcod=1;
          }
          else if (GetExitCodeThread(hTh,&exitCode) && exitCode == 0) {
               errcod=0;
          }
          else {
               errcod=1;
          }
          break;
     case 90:                      // Catastro occured with bad results
     case 80:
          runBatch("wgsdn.bat",retVal);
          errcod=0;
          break;
     case 70:                      // Catastro occured cleanly
     case 50:
          runBatch("wgsdn.bat",retVal);
          unlink("wgsisup.flg");
          errcod=0;
          break;
     case 49:                      // Out of memory
          runBatch("wgsdn.bat",retVal);
          unlink("wgsisup.flg");
          unlink("wgscata.flg");
          errcod=2;
          break;
     case 8:                       // System killed via remote sysop
     case 1:                       // System killed
          runBatch("wgsdn.bat",retVal);
          unlink("wgsisup.flg");
          unlink("wgscata.flg");
          errcod=0;
          break;
     case 14:                      // Timed Event 4
          runBatch("wgsdn.bat",retVal);
          ShellCommand("wgsfndo Event-4",retVal,FALSE,"WGSFNDO");
          errcod=1;
          break;
     case 13:                      // Timed Event 3
          runBatch("wgsdn.bat",retVal);
          ShellCommand("wgsfndo Event-3",retVal,FALSE,"WGSFNDO");
          errcod=1;
          break;
     case 12:                      // Timed Event 2
          runBatch("wgsdn.bat",retVal);
          ShellCommand("wgsfndo Event-2",retVal,FALSE,"WGSFNDO");
          errcod=1;
          break;
     case 11:                      // Timed Event 1
          runBatch("wgsdn.bat",retVal);
          ShellCommand("wgsfndo Event-1",retVal,FALSE,"WGSFNDO");
          errcod=1;
          break;
     case 0:                      // Auto Cleanup
          unlink("wgsabsd.flg");
          runBatch("wgsdn.bat",retVal);
          ShellCommand("wgsfndo Cleanup",retVal,FALSE,"WGSFNDO");
          errcod=1;
          break;
     default:                      // Unexpected code!
          // HACK that may cause problems if run as a service or unattended
          sprintf(msgBuffer,"Unrecognized errorlevel=%d returned from WGSERVER.EXE!",
                            retVal);
          MessageBox(NULL,msgBuffer,path,MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          errcod=99;
     }
     //FreeConsole();
     return(errcod);
EXCEPT
     FreeConsole();
     return(3);
}

static DWORD                       //   return code
messageBoxTh(                      // open MessageBox
VOID *pInfo)                       //   argument
{
     CHAR *mbText="The server will attempt to auto restart itself in 30 seconds.  "
                  "Click on OK to restart it immediately or CANCEL to abort the restart.";
     CHAR *mbCaption=(CHAR *)pInfo;

     if (MessageBox(NULL,mbText,mbCaption,
                    MB_ICONQUESTION|MB_OKCANCEL|MB_SETFOREGROUND) == IDCANCEL) {
          return(0);
     }
     return(1);
}


static BOOL                        //   TRUE if batch was run successfully
runBatch(                          // run and wait for a batch file
const char *cmdLine,               //   batch to run
int &retVal)                       //   batch file result code
{
     BOOL      result = FALSE;
     Cffblk ffblk;

     if (fnd1st(&ffblk,cmdLine,0))
     {
          result = ShellCommand( cmdLine, retVal, FALSE );
     }

     return( result );
}



#if 0

     These error codes are used by WGSAPPGO and WGSYSDN

     0 = Successful shutdown, stop running WGSAPPGO
     1 = Successful shutdown, run server again
     2 = Unsuccessful shutdown, stop running WGSAPPGO
     3 = WGSYSDN Faulted or failed
     99 = invalid error code passed to WGSYSDN

#endif // if 0

