// wgsumenuDlg.cpp : implementation file
//

#include "stdafx.h"
#include "wgsumenu.h"
#include "wgsumenuDlg.h"
#include "gcommlib.h"  

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

struct utils                            /* utilities used structure        */
{                          
     CHAR utlName[10];                  /*   name of utility               */
     CHAR utlDesc[64];                  /*   description of utility        */
};

utils stdUtils[] =
{
     {"WGSMKWGM",   "Worldgroup Client packaging utility"                  },
#if ! defined( ACTIBASE )
     {"GALFOMAN",   "offline Forums management utility"                    },
     {"GALPNQR ",   "generate report on questionnaire results"             },
     {"GALFILIN",   "log files to a specified library using a script file" },
     {"GALFILKW",   "re-build file library keyword database"               },
#endif
     {"WGSRPT  ",   "menu of reports on the server, users, etc."           },
     {"WGSRIDX ",   "restore file integrity if questionable"               },
     {"WGSRDRLN",   "read release note files"                              },
     {"WGSSWTCL",   "move all users in one class to another"               },
     {"WGSDMOD ",   "disable or re-enable selected modules"                },
     {"WGSAREF ",   "App-ID reference by module name"                      },
     {"WGSMREF ",   "modem settings reference guide"                       },
     {"WGSCLRAT",   "clear Audit Trail"                                    },
     {"WGSZSTAT",   "clear statistics used in Sysop displays"              },     
#if ! defined( WEBCAST )
     {"WGSSETCL",   "re-establish basic underlying system type"            },
#endif
#if defined (WORLDGROUP)     
	 {"WGSCOLOR",   "change colors used online"                            },
#endif
	 {"WGSLANG ",   "add, delete, or export user languages"                },
     {"GALRFC  ",   "combine RIP files for online viewing"                 }
};

#define STDCNT      (sizeof(stdUtils)/sizeof(struct utils))

#define UTILINC     5              /* number increment counter             */

struct xitList {
     CHAR utilName[9];
};

static struct xitList xit1List[]={
     {"WGSMKWGM"    }
};

static struct xitList xit2List[]={
     {"GALFOMAN"    },
     {"WGSRPT"      }
};

static INT  numUtils,              /* number of offline utilities in use   */
            maxIndex;              /* maximum number of utilities allocated*/
static CHAR **utilList;            /* list of offline utilities            */


/////////////////////////////////////////////////////////////////////////////
// CWgsumenuDlg dialog

CWgsumenuDlg::CWgsumenuDlg(CWnd* pParent /*=NULL*/)
     : CDialog(CWgsumenuDlg::IDD, pParent)
{
     //{{AFX_DATA_INIT(CWgsumenuDlg)
          // NOTE: the ClassWizard will add member initialization here
     //}}AFX_DATA_INIT
     // Note that LoadIcon does not require a subsequent DestroyIcon in Win32
     m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
     exitcode = -1;
}

void CWgsumenuDlg::DoDataExchange(CDataExchange* pDX)
{
     CDialog::DoDataExchange(pDX);
     //{{AFX_DATA_MAP(CWgsumenuDlg)
     DDX_Control(pDX, IDC_UTILLIST, m_utilList);
     //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWgsumenuDlg, CDialog)
     //{{AFX_MSG_MAP(CWgsumenuDlg)
     ON_WM_PAINT()
     ON_WM_QUERYDRAGICON()
     ON_BN_CLICKED(IDC_RUN, OnRun)
     ON_LBN_DBLCLK(IDC_UTILLIST, OnDblclkUtillist)
     ON_BN_DOUBLECLICKED(IDCANCEL, OnDoubleclickedCancel)
     //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWgsumenuDlg message handlers

BOOL                               //   TRUE if init went OK
CWgsumenuDlg::OnInitDialog()       // set dialog size and contents
{
     CWaitCursor cur;

     CDialog::OnInitDialog();

     CDC       *ourDC = m_utilList.GetDC();

     SetWindowText(SVR_NAME " Utility Menu");
     if (ourDC != NULL)
     {
          CSize     ex = ourDC->GetTextExtent( "WWWWWWWWW" );
          int       hdu = ::GetDialogBaseUnits() & 0x0000FFFF;

          m_utilList.SetTabStops( (ex.cx * 4) / hdu );
     }

     SetIcon(m_hIcon, TRUE);            // Set big icon
     SetIcon(m_hIcon, FALSE);      // Set small icon

     setStdUtils();
     getOthUtils();

     return TRUE;
}


void CWgsumenuDlg::OnPaint() 
{
     if (IsIconic())
     {
          CPaintDC dc(this); // device context for painting

          SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

          // Center icon in client rectangle
          int cxIcon = GetSystemMetrics(SM_CXICON);
          int cyIcon = GetSystemMetrics(SM_CYICON);
          CRect rect;
          GetClientRect(&rect);
          int x = (rect.Width() - cxIcon + 1) / 2;
          int y = (rect.Height() - cyIcon + 1) / 2;

          // Draw the icon
          dc.DrawIcon(x, y, m_hIcon);
     }
     else
     {
          CDialog::OnPaint();
     }
}

HCURSOR CWgsumenuDlg::OnQueryDragIcon()
{
     return (HCURSOR) m_hIcon;
}


VOID
CWgsumenuDlg::setStdUtils(VOID)    /* preset standard Galacticomm utils    */
{
     INT i;

     utilList=(CHAR **)alczer(STDCNT*sizeof(CHAR *));
     for (i=0 ; i < STDCNT ; i++) {
          utilList[i]=(CHAR *)alczer(sizeof(struct utils));
          strcpy(utilList[i],stdUtils[i].utlName);
          strcat(utilList[i]," -- ");
          strcat(utilList[i],stdUtils[i].utlDesc);

          CString   st;
          st = stdUtils[ i ].utlName;
          st += '\t';
          st += stdUtils[ i ].utlDesc;
          m_utilList.AddString( st );
     }
     numUtils=STDCNT;
     maxIndex=numUtils-1;
}

VOID
CWgsumenuDlg::getOthUtils(VOID)    /* read in additional utilities as need */
{
     FILE *reffp,*mdffp;
     CHAR mdfbuf[80],refbuf[40];

     if ((reffp=fopen("wgsutl.ref",FOPRA)) != NULL) {
          while (fscanf(reffp,"%12s\n",&refbuf) == 1) {
               if ((mdffp=fopen(refbuf,FOPRA)) == NULL) {
                    catastro("getOthUtils: Unable to open %s file",refbuf);
               }
               while (fgets(mdfbuf,sizeof(mdfbuf),mdffp) != NULL) {
                    if (sameto("Add-On Utility:",mdfbuf)) {
                         unpad(mdfbuf);
                         if (mdfbuf[15] != '\0') {
                              if (numUtils >= maxIndex) {
                                   utilList=(CHAR **)alcrsz(utilList,
                                        numUtils*sizeof(CHAR *),
                                        (numUtils+UTILINC)*sizeof(CHAR *));
                                   maxIndex+=UTILINC;

                                   for ( int count = numUtils; count <= maxIndex; ++count )
                                   {
                                        utilList[ count ] = NULL;
                                   }
                              }
                              utilList[numUtils++]=alcdup(skpwht(mdfbuf+15));

                              char      *mb = skpwht(mdfbuf + 15);

                              CString   name = firstwd(mb);
                              CString   desc = skpwht( mb + strlen( name ) + 1 );

                              //   pad name to 8 chars
                              //
                              while (name.GetLength() < 8)
                              {
                                   name += ' ';
                              }

                              //   trim leading space and dashes from desc
                              //
                              while ((desc.GetLength() > 0 ) &&
                                     ((desc[ 0 ] == '-') || isspace( desc[ 0 ] ))
                                    )
                              {
                                   desc = desc.Mid( 1 );
                              }

                              m_utilList.AddString( name + "\t" + desc );
                         }
                    }
               }
               fclose(mdffp);
          }
          fclose(reffp);
     }
}

GBOOL                              //   returns true if item is type 1       
CWgsumenuDlg::isExit1Type(         // is selected utility exit type 1?
const CHAR *chkItem)               //   utility item to check for
{
     INT i;

     for (i=0 ; i < nelems(xit1List) ; i++) {
          if (sameto(chkItem,xit1List[i].utilName)) {
               return(TRUE);
          }
     }
     return(FALSE);
}

GBOOL                       /*   returns true if item is type 2     */
CWgsumenuDlg::isExit2Type(                       /* is selected utility exit type 2?     */
const CHAR *chkItem)                     /*   utility item to check for          */
{
     INT i;

     for (i=0 ; i < nelems(xit2List) ; i++) {
          if (sameto(chkItem,xit2List[i].utilName)) {
               return(TRUE);
          }
     }
     return(FALSE);
}

void 
CWgsumenuDlg::OnRun()              // "Run" button handler
{
     int       chosen = m_utilList.GetCurSel();

     if (chosen == LB_ERR)
     {
          ::MessageBeep( MB_ICONASTERISK );
     }
     else
     {
          RunApp( chosen );
     }

     return;
}

void
CWgsumenuDlg::OnDblclkUtillist()   // handle listbox double-click
{
     int       chosen = m_utilList.GetCurSel();

     if (chosen == LB_ERR)
     {
          ::MessageBeep( MB_ICONASTERISK );
     }
     else
     {
          RunApp( chosen );
     }

     return;
}
 
void 
CWgsumenuDlg::RunApp(              // select the app to run
int chosen)                        //   index of chosen app
{
     m_utilList.EnableWindow( FALSE );

     CString   uname = utilList[ chosen ];
     uname = uname.Left( 8 );

     if (isExit1Type(uname)) {
          exitcode=1;
     }
     else if (isExit2Type(uname)) {
          exitcode=2;
     }
     else if (sameto("WGSCLRAT",uname)) {
          exitcode=4;
     }
     else if (sameto("WGSRIDX",uname)) {
          exitcode=5;
     }
     else {
          exitcode=3;
     }

     m_runName = uname;            // main app will retrieve this later

     EndDialog( IDOK );
}


void CWgsumenuDlg::OnCancel() 
{
     exitcode = 0;
     
     CDialog::OnCancel();
}

void CWgsumenuDlg::OnDoubleclickedCancel() 
{
     OnCancel();    
}

int CWgsumenuDlg::GetExitCode()
{
     return( exitcode );
}

CWgsumenuDlg::~CWgsumenuDlg()
{
     if (utilList != NULL)
     {
          for ( int count = 0; count <= maxIndex; ++count )
          {
               if (utilList[ count ] != NULL)
               {
                    free( utilList[ count ] );
                    utilList[ count ] = NULL;
               }
          }

          free( utilList );
          utilList = NULL;
     }
}

CString                            //   app name (no extension)
CWgsumenuDlg::GetRunName()         // get name of selected app
{
     return( m_runName );
}
