/***************************************************************************
 *                                                                         *
 *   WGSUTMEN.C                                                            *
 *                                                                         *
 *   Copyright (c) 1996 Galacticomm, Inc.    All Rights Reserved.          *
 *                                                                         *
 *   Offline utility to handle WGSUTMEN under NT.                          *
 *                                                                         *
 *                                        - Richard Skurnick 05/31/96      *
 *                                                                         *
 ***************************************************************************/

#include "stdafx.h"
#include "gcommlib.h"
#include "excphand.h"
#include "ShellCmd.h"
#include "resource.h"
#include "Wgsumenu.h"
#include "WgsumenuDlg.h"
#include "ClearAuditDialog.h"
#include "BuildingDialog.h"
#include "anychg.h"

#define FILREV "$Revision: 3 $"

Cffblk fbptr;
CString runNameS;
const char *runName;
CHAR path[2048];

static void ShowMenu( int &retVal );
static void Message( const char *s1, const char *s2, const char *s3,
                     const char *title
                   );

static int
MainLoop(
HINSTANCE hInstance,               // handle to current instance
HINSTANCE hPrevInstance,           // handle to previous instance
LPSTR lpCmdLine,                   // pointer to command line
INT nCmdShow);                     // show state of window

static BOOL ClearAuditTrail();
static void WaitCursor();
static void RestoreCursor();
static void StartBuilding();
static void EndBuilding();

static HCURSOR oldCursor = NULL;
static HCURSOR waitCur = NULL;
static BuildingDialog *bd = NULL;

/////////////////////////////////////////////////////////////////////////////
// CWgsumenuApp:
// See wgsumenu.cpp for the implementation of this class
//

BEGIN_MESSAGE_MAP(CWgsumenuApp, CWinApp)
     //{{AFX_MSG_MAP(CWgsumenuApp)
     //}}AFX_MSG_MAP
END_MESSAGE_MAP()


CWgsumenuApp theApp;


CWgsumenuApp::CWgsumenuApp() : CWinApp()
{
     m_exCode = -1;
}


BOOL CWgsumenuApp::InitInstance()
{
     CWinApp::InitInstance();
#ifdef _AFXDLL
     Enable3dControls();           // Call this when using MFC in a shared DLL
#else
     Enable3dControlsStatic();     // Call this when linking to MFC statically
#endif

     waitCur = ::LoadCursor( NULL, IDC_WAIT );

     m_exCode = MainLoop(m_hInstance, m_hPrevInstance, m_lpCmdLine, m_nCmdShow);

     return( FALSE );
}


int CWgsumenuApp::ExitInstance()
{
     return( m_exCode );
}


static int
MainLoop(
HINSTANCE hInstance,               // handle to current instance
HINSTANCE hPrevInstance,           // handle to previous instance
LPSTR lpCmdLine,                   // pointer to command line
INT nCmdShow)                      // show state of window
{
TRY
     CHAR *pTmp;
     INT retVal;
     GBOOL isDone=FALSE;
     GBOOL appRes;

     (VOID)hPrevInstance;
     (VOID)lpCmdLine;
     (VOID)nCmdShow;
     GetModuleFileName(hInstance,path,sizeof(path));
     if (!canRunGroup()) {
          Message(NOPROCEED, NULL, NULL,
                    path);
          return(1);
     }
     if ((pTmp=strrchr(path,'\\')) != NULL
          || (pTmp=strrchr(path,'/')) != NULL) {
          *pTmp='\0';
          chdir(path);
          *pTmp='\\';
     }
     do {
          if (anychg(TRUE)) {
               WaitCursor();
               StartBuilding();
               appRes = ShellCommand( "wgsint", retVal );
               EndBuilding();
               RestoreCursor();

               if (! appRes) {
                    Message("Unable to execute WGSINT!",NULL,NULL,path);
                    return(1);
               }
               if (retVal == 200) {
                    return(1);
               }
          }

          ShowMenu( retVal );

          switch (retVal) {
          case 1:
          case 2:
          case 3:
               if (!ShellCommand(runName, retVal, FALSE, runName)) {
                    Message("Unable to execute ", runName, "!",path);
                    //FreeConsole();
                    return(1);
               }
               if (retVal == 1) {
                    Message("An error occured while running ",runName,"!",path);

                    //FreeConsole();
                    return(1);
               }
               break;
          case 4:
               if (! ClearAuditTrail())
               {
                    return( 1 );
               }
               break;
          case 5:
               WaitCursor();
               ShellCommand("wgsridx *",retVal);
               if (fnd1st(&fbptr,"galfilk2.dat",NULL)) {
                    dfaVirgin("galfilk2",NULL);
               }
               ShellCommand("galfilkw",retVal);
               copyfile("wgsmajor.mcv","junk.jnk");
               ShellCommand("del *.mcv",retVal);
               rename("junk.jnk","wgsmajor.mcv");
               ShellCommand("wgsmsx wgsmajor",retVal);
               ShellCommand("wgsmsx",retVal);
               unlink("wgsint.ref");
               unlink("wgsmdf.ref");
               dfaVirgin("wgsxrf2",NULL);
               ShellCommand("wgsrbx",retVal);
               ShellCommand("wgsrbk",retVal);
               RestoreCursor();
               break;
          default:
               isDone=TRUE;
          }
          //FreeConsole();
     } while (!isDone);
     return(0);
EXCEPT
     return(1);
}


static void
ShowMenu(                          // display utility menu, set runName
int &retVal)                       //   dialog exit code
{
     CWgsumenuDlg dlg;
     dlg.DoModal();

     retVal = dlg.GetExitCode();
     runNameS = dlg.GetRunName();
     runName = runNameS;
}


static void
Message(                           // display multi-part msg
const char *s1,                    //   part 1
const char *s2,                    //   part 2
const char *s3,                    //   part 3
const char *title)                 //   message box title
{
     CString   msg;

     msg = s1;
     if (s2 != NULL)
          msg += s2;
     if (s3 != NULL)
          msg += s3;

     MessageBox( NULL, msg, title, MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
}


static BOOL ClearAuditTrail()
{
     ClearAuditDialog clearDlg;
     CWaitCursor cur;

     clearDlg.Create( IDD_CLEARAUDITDIALOG );

     if (isfile("wgsaudit.old")) {
          if (!chmod("wgsaudit.old",S_IWRITE|S_IREAD)) {
               if (unlink("wgsaudit.old")) {
                    Message("An error occured while deleting WGSAUDIT.OLD!",NULL,NULL,path);
                    return(FALSE);
               }
          }
          else {
               Message("An error occured while modifing attributes on WGSAUDIT.OLD!",NULL,NULL,path);
               return(FALSE);
          }
     }

     clearDlg.SetProgress( 50 );
     clearDlg.UpdateWindow();

     if (isfile("wgsaudit.adt") && rename("wgsaudit.adt","wgsaudit.old")) {
          Message(
               "An error occured while renaming WGSAUDIT.OLD!",NULL,NULL,path);
          return(FALSE);
     }

     clearDlg.SetProgress( 100 );
     clearDlg.UpdateWindow();
     Sleep( 1000 );

     return( TRUE );
}


static void WaitCursor()
{
     oldCursor = GetCursor();
     SetCursor( waitCur );
}


static void RestoreCursor()
{
     if (oldCursor != NULL)
     {
          SetCursor( oldCursor );
          oldCursor = NULL;
     }
}


static void StartBuilding()
{
     bd = new BuildingDialog();
     bd->Create( IDD_BUILDING );
}


static void EndBuilding()
{
     if (bd != NULL)
     {
          delete bd;
          bd = NULL;
     }
}

