// WizardDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Wizard.h"
#include "WizardDlg.h"
#include "WizardProgress.h"
#include "MyPropertySheet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID revclean(VOID);
VOID clrlst(VOID);
VOID prcgcs(VOID);
VOID prcmdf(CHAR *spec);
CHAR *gmdname(CHAR *mdfnam);
GBOOL inlist(CHAR *filnam);
VOID CopyTypeFiles(const CHAR *fromdir,const CHAR *todir);

#define ARTMSG "galart.msg"
#define OLDMSG "galartms.old"
#define NEWMSG "bbsmainm.msg"
#define NEWMCV "bbsmainm.mcv"
#define ARTDIR "galart/"
#define NEWDEF "wgshps/"
#define LAUMDF "galaunch.mdf"
#define MNUDAT "bbsmenu.dat"

#define MAXFIL 200                 // max no. of files to store (per MDF)
#define MNOSET 12                  // module name offset in MDF file
#define CLIEXE "Client app EXE:"   // MDF file prefix for app file name
#define CLISUP "Client app support files:" // MDF prefix for support files
#define SHRSUP "Shared support files:" // MDF prefix for shared spt files
#define MODNAM "Module Name:"      // MDF file prefix for module's name
#define MDFSPC "*.mdf"             // MDF file spec to process
#define DMDSPC "*.dmd"             // DMD file spec to process
#define ALLFIL STAR                // all files spec
#define DELIMS ", \t;"             // valid delimiters for support lists
#define GCSDIR "gcsvcman"          // name of GCSVCMAN subdirectory
#define GCSLST "gcsvcman.lst"      // name of list file used by WGM
#define GCSFLS "Worldgroup Manager Files" // desc. for files in GCSLST

#define VIR_PUBLIC  "GCVIRDAT\\PUBLIC\\"
#define VIR_PROFIT  "GCVIRDAT\\PROFIT\\"
#define WEB_PUBLIC  "GALACTH\\GALWEBV\\PUBLIC\\"
#define WEB_PROFIT  "GALACTH\\GALWEBV\\PROFIT\\"

#define VIR_FINAL   "GCVIRDAT\\"
#define WEB_FINAL   "GALACTH\\GALWEBV\\"

BOOL mustFinish=FALSE;

VOID setopt(CHAR *,BOOL);
VOID mmcvt(VOID);
VOID movart(VOID);
VOID movlau(VOID);
VOID noinet(VOID);
VOID yesinet(VOID);
BOOL canCancel(VOID);
VOID goodunlink(const CHAR *);
VOID massunlink(const CHAR **);
VOID massdisable(const CHAR **);

const CHAR *byelist[]={
     "GALDUP.*",
     "GALREC.*",
     "GALSLISP.*",
     "GALSCP*.*",
     "WIN31USR.TXT",
     "WIN95USR.TXT",
     "WIN95LOG.SCP",
     "LOGIN.CMD",
     "PPPSYSOP.TXT",
     "BBS.BAT",
     "WG.BAT",
     "BBSINTRO.EXE",
     "WGSINTRO.EXE",
     (CHAR *)NULL
};

const CHAR *mdfdisable[]={
     "GALLAN",
     "EQXSST",
     "EQXDIAG",
     (CHAR *)NULL
};

INT numfls;                        // number of files in current MDF/LST
CHAR savdir[GCMAXPTH];             // saved directory name to return to
CHAR lstbuf[BUFSIZ];               // list file input buffer
CHAR **newfls;                     // dynamic array of 'new' files
FILE *lstfp;                       // file pointer to GCSLST
Cffblk fb;                         // for fnd1st()/fndnxt()
static CHAR inbuf[BUFSIZ];

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWizardDlg dialog

CWizardDlg::CWizardDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWizardDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWizardDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDI_GCOMM);
}

void CWizardDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWizardDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWizardDlg, CDialog)
	//{{AFX_MSG_MAP(CWizardDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(ID_NEXT0, OnNext0)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWizardDlg message handlers

BOOL CWizardDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

#ifdef WEBCAST
     m_bitmapPicture.LoadBitmap(IDB_BITMAP7);
#else
#ifdef ACTIBASE
     m_bitmapPicture.LoadBitmap(IDB_BITMAP8);
#else
     m_bitmapPicture.LoadBitmap(IDB_BITMAP6);
#endif // ACTIBASE
#endif // WEBCAST
     ((CStatic*)GetDlgItem(IDC_TITLE_BITMAP))->SetBitmap((HBITMAP)m_bitmapPicture);
     //m_staticPicture.SetBitmap((HBITMAP)m_bitmapPicture);

     SetWindowText(SVR_NAME " Setup Wizard");
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CWizardDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CWizardDlg::OnDestroy()
{
	WinHelp(0L, HELP_QUIT);
	CDialog::OnDestroy();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CWizardDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CWizardDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CWizardDlg::OnWizard()
{
     INT GetAccount(GBOOL *);
     VOID SetAccount(INT);

     struct usracc accrec;
	CMyPropertySheet propSheet;
     CWizardProgress myProg;
     CString tmpstr;
     DFAFILE *dfaAcc;
     FILE *lstfp;
     CHAR tmpbuf[10];
     CHAR tmpid[UIDSIZ];
     CHAR dmdnam[FNMLEN];
     CHAR *opval;
     CHAR *ptr;
     GBOOL hasrun;
     INT oldacct;
     INT prange;
     LONG outbsz;

     massunlink(byelist);               // Get rid of things we don't need.
     massdisable(mdfdisable);           // Disable troublesome little waifs.

     tmpstr.FormatMessage(IDS_TINFO1,SVR_NAME);
     propSheet.m_Page1.m_pinfo=tmpstr;
     tmpstr.LoadString(IDS_TINFO2);
     propSheet.m_Page2.m_pinfo=tmpstr;
     tmpstr.FormatMessage(IDS_TINFO3,SVR_NAME);
     propSheet.m_Page3.m_pinfo=tmpstr;
     tmpstr.LoadString(IDS_TINFO4);
     propSheet.m_Page4.m_pinfo=tmpstr;
     tmpstr.FormatMessage(IDS_TINFO5,SVR_NAME);
     propSheet.m_Page5.m_pinfo=tmpstr;


     // Fetch old pertinent message file information for modification
     myProg.m_text="Reading Current Settings....";
     myProg.Create(IDD_PROGDLG);
     myProg.m_progress.SetRange(0,24);
     myProg.m_progress.SetPos(0);
     myProg.m_progress.SetStep(1);
     if ((opval=mstscan((CHAR *)MSG_WGSMAJOR,(CHAR *)CNF_OUTBSZ,6)) != NULL)
     {
          stlcpy(tmpbuf,opval,6);
     }
     outbsz=atol(tmpbuf);

     SetMSGText(&strWebDirectory,MSG_GALWEBD,CNF_WEBROOT,34);

     myProg.m_progress.StepIt();
     SetMSGText(&propSheet.m_Page1.m_sysname,MSG_WGSMAJOR,CNF_BBSTTL,51);
     myProg.m_progress.StepIt();
     SetMSGText(&propSheet.m_Page1.m_cmpname,MSG_WGSMAJOR,CNF_COMPANY,47);
     myProg.m_progress.StepIt();
     SetMSGText(&propSheet.m_Page1.m_addr1,MSG_WGSMAJOR,CNF_ADDRES1,45);
     myProg.m_progress.StepIt();
     SetMSGText(&propSheet.m_Page1.m_addr2,MSG_WGSMAJOR,CNF_ADDRES2,45);
     myProg.m_progress.StepIt();
     SetMSGText(&propSheet.m_Page1.m_mphone,MSG_WGSMAJOR,CNF_DATAPH,33);
     myProg.m_progress.StepIt();

     // Fetch old accounting system type so they know what they have
     oldacct=GetAccount(&hasrun);
     propSheet.m_Page3.m_oldacct=oldacct;
     myProg.m_progress.StepIt();
     if (!hasrun) {
          mustFinish=TRUE;
     }
     // Fetch old sysop account information for modification
     dfaAcc=dfaOpen(DAT_WGSUSR2,sizeof(accrec),NULL);
     dfaSetBlk(dfaAcc);
     memset(&accrec,0,sizeof(accrec));
     if (dfaAcqEQ(&accrec,FLD_SYSOP,0)) {
          SetString(&propSheet.m_Page2.m_userid,accrec.userid,NADSIZ);
          myProg.m_progress.StepIt();
          SetString(&propSheet.m_Page2.m_ename,accrec.usrnam,NADSIZ);
          myProg.m_progress.StepIt();
          SetString(&propSheet.m_Page2.m_cname,accrec.usrad1,NADSIZ);
          myProg.m_progress.StepIt();
          SetString(&propSheet.m_Page2.m_adr1,accrec.usrad2,NADSIZ);
          myProg.m_progress.StepIt();
          SetString(&propSheet.m_Page2.m_adr2,accrec.usrad3,NADSIZ);
          myProg.m_progress.StepIt();
          SetString(&propSheet.m_Page2.m_cntry,accrec.usrad4,NADSIZ);
          myProg.m_progress.StepIt();
          SetString(&propSheet.m_Page2.m_phone,accrec.usrpho,PHOSIZ);
          myProg.m_progress.StepIt();
          SetString(&propSheet.m_Page2.m_pass,accrec.psword,PSWSIZ);
          myProg.m_progress.StepIt();
          SetString(&propSheet.m_Page2.m_vpass,accrec.psword,PSWSIZ);
          myProg.m_progress.StepIt();
          dfaClose(dfaAcc);
     }
     else {
          CString tmp;
          tmp.LoadString(IDS_ERROR5);
          ::MessageBox(this->GetSafeHwnd(),(LPCTSTR)tmp,WIZARD_CAPTION,MB_ICONEXCLAMATION|MB_OK
               |MB_APPLMODAL);
     }

     //  Fetch old e-mail setup information
     SetMSGValue(&tmpstr,MSG_GALME,CNF_SUPU2S,4);
     if (sameas((CHAR *)(LPCTSTR)(tmpstr),"yes")) {
          propSheet.m_Page4.m_notify=0;
     }
     else {
          propSheet.m_Page4.m_notify=1;
     }
     myProg.m_progress.StepIt();
     SetMSGValue(&tmpstr,MSG_GALME,CNF_SUPE2U,4);
     if (sameas((CHAR *)(LPCTSTR)(tmpstr),CNFVAL_YES)) {
          propSheet.m_Page4.m_unotify=0;
     }
     else {
          propSheet.m_Page4.m_unotify=1;
     }
     myProg.m_progress.StepIt();
     SetMSGText(&propSheet.m_Page4.m_enotto,MSG_GALME,CNF_NUEMTO,UIDSIZ);
     myProg.m_progress.StepIt();
     SetMSGText(&propSheet.m_Page4.m_eadrto,MSG_GALME,CNF_E2UFRM,UIDSIZ);
     myProg.m_progress.StepIt();

     // Fetch initial ICO setup information
     SetMSGText(&propSheet.m_Page6.m_msgip,MSG_GALTCPIP,CNF_IPADDR,16);
     myProg.m_progress.StepIt();
     SetMSGText(&propSheet.m_Page6.m_msgdns,MSG_GALDNS,CNF_IPNSVR,16);
     myProg.m_progress.StepIt();
     SetMSGText(&propSheet.m_Page6.m_msghst,MSG_GALDNS,CNF_HOSTNAM,19);
     myProg.m_progress.StepIt();
     SetMSGText(&propSheet.m_Page6.m_msgdmn,MSG_GALDNS,CNF_DOMAIN,28);
     myProg.m_progress.StepIt();

     myProg.DestroyWindow();

	if (propSheet.DoModal() == ID_WIZFINISH) {
	     // This is where you would retrieve information from the property
	     // sheet if propSheet.DoModal() returned IDOK.

          // This saves out the CNF information regarding system customization. (Page 1)
          // Note, parameters of setcnf() and applyem() cast away const!
          // NEED TO RE-ARCHITECT these functions to take const char * instead.
          myProg.m_text="Saving New Settings....";
          myProg.Create(IDD_PROGDLG);
          prange=((propSheet.m_Page5.m_inet != FALSE) ? 14 : 12);
          myProg.m_progress.SetRange(0,prange);
          myProg.m_progress.SetPos(0);
          myProg.m_progress.SetStep(1);
          if (outbsz < atol(VAL_OUTBSZ)) {
               setcnf((CHAR *)CNF_OUTBSZ,(CHAR *)VAL_OUTBSZ);
          }
          setcnf((CHAR *)CNF_BBSTTL,(CHAR *)(LPCTSTR)(propSheet.m_Page1.m_sysname));
          setcnf((CHAR *)CNF_COMPANY,(CHAR *)(LPCTSTR)(propSheet.m_Page1.m_cmpname));
          setcnf((CHAR *)CNF_ADDRES1,(CHAR *)(LPCTSTR)(propSheet.m_Page1.m_addr1));
          setcnf((CHAR *)CNF_ADDRES2,(CHAR *)(LPCTSTR)(propSheet.m_Page1.m_addr2));
          setcnf((CHAR *)CNF_DATAPH,(CHAR *)(LPCTSTR)(propSheet.m_Page1.m_mphone));
          applyem((CHAR *)MSG_WGSMAJOR);
          myProg.m_progress.StepIt();

          // This saves out the Btrieve data regarding sysop customization.     (Page 2)
          dfaAcc=dfaOpen(DAT_WGSUSR2,sizeof(accrec),NULL);
          dfaSetBlk(dfaAcc);
          memset(&accrec,0,sizeof(accrec));
          if (dfaAcqEQ(&accrec,FLD_SYSOP,0)) {
               stzcpy(accrec.usrnam,(LPCTSTR)(propSheet.m_Page2.m_ename),NADSIZ);
               myProg.m_progress.StepIt();
               stzcpy(accrec.usrad1,(LPCTSTR)(propSheet.m_Page2.m_cname),NADSIZ);
               myProg.m_progress.StepIt();
               stzcpy(accrec.usrad2,(LPCTSTR)(propSheet.m_Page2.m_adr1),NADSIZ);
               myProg.m_progress.StepIt();
               stzcpy(accrec.usrad3,(LPCTSTR)(propSheet.m_Page2.m_adr2),NADSIZ);
               myProg.m_progress.StepIt();
               stzcpy(accrec.usrad4,(LPCTSTR)(propSheet.m_Page2.m_cntry),NADSIZ);
               myProg.m_progress.StepIt();
               stzcpy(accrec.usrpho,(LPCTSTR)(propSheet.m_Page2.m_phone),PHOSIZ);
               myProg.m_progress.StepIt();
               stzcpy(accrec.psword,(LPCTSTR)(propSheet.m_Page2.m_pass),PSWSIZ);
               myProg.m_progress.StepIt();
               dfaUpdate(&accrec);
               myProg.m_progress.StepIt();
               dfaClose(dfaAcc);
          }
          else {
               CString tmp;
               tmp.LoadString(IDS_ERROR5);
               ::MessageBox(this->GetSafeHwnd(),(LPCTSTR)tmp,WIZARD_CAPTION,
                    MB_ICONEXCLAMATION|MB_OK|MB_APPLMODAL);
          }

          // This does the class switching based on the new accounting model    (Page 3)
          if ((!hasrun) || (hasrun && (oldacct != (propSheet.m_Page3.m_oldacct)))) {
               INT iAccount=propSheet.m_Page3.m_oldacct;
               SetAccount(iAccount);
#ifdef WEBCAST
               CopyTypeFiles((iAccount == 0 ? VIR_PUBLIC : VIR_PROFIT),VIR_FINAL);
               CopyTypeFiles((iAccount == 0 ? WEB_PUBLIC : WEB_PROFIT),WEB_FINAL);
#endif // WEBCAST
          }
          stlcpy(dmdnam,MDF_GALSUPAH,FNMLEN);
          if ((ptr=strrchr(dmdnam,'.')) != NULL) {
               *ptr='\0';
               stlcat(dmdnam,EXT_DMD,FNMLEN);
          }
          if (propSheet.m_Page3.m_oldacct == 3) {
               if (access(dmdnam,0) != -1 && access(MDF_GALSUPAH,0) != -1) {
                    unlink(MDF_GALSUPAH);
               }
               else {
                    rename(MDF_GALSUPAH,dmdnam);
               }
          }
          else if (propSheet.m_Page5.m_inet != FALSE) {
               if (access(dmdnam,0) != -1 && access(MDF_GALSUPAH,0) != -1) {
                    unlink(dmdnam);
               }
               else {
                    rename(dmdnam,MDF_GALSUPAH);
               }
          }
          myProg.m_progress.StepIt();
          // Save new e-mail setup information                                  (Page 4)
          if (propSheet.m_Page4.m_notify == 0) {
               setcnf(CNF_SUPU2S,CNFVAL_YES);
          }
          else {
               setcnf(CNF_SUPU2S,CNFVAL_NO);
          }
          if (propSheet.m_Page4.m_unotify == 0) {
               setcnf(CNF_SUPE2U,CNFVAL_YES);
          }
          else {
               setcnf(CNF_SUPE2U,CNFVAL_NO);
          }
          dfaAcc=dfaOpen(DAT_WGSUSR2,sizeof(accrec),NULL);
          dfaSetBlk(dfaAcc);
          memset(&accrec,0,sizeof(accrec));
          if (!dfaAcqEQ(&accrec,(VOID *)(LPCTSTR)propSheet.m_Page4.m_enotto,0)) {
               CString tmp;
               tmp.FormatMessage(IDS_EMAILERROR,SVR_NAME);
               ::MessageBox(this->GetSafeHwnd(),(LPCTSTR)tmp,WIZARD_CAPTION,MB_ICONEXCLAMATION
                    |MB_OK|MB_APPLMODAL);
          }
          else {
               setcnf(CNF_NUEMTO,(CHAR *)(LPCTSTR)(propSheet.m_Page4.m_enotto));
          }
          dfaClose(dfaAcc);
          setcnf(CNF_E2UFRM,(CHAR *)(LPCTSTR)(propSheet.m_Page4.m_eadrto));
          applyem((CHAR *)MSG_GALME);
          myProg.m_progress.StepIt();

          revclean();
          myProg.m_progress.StepIt();
          if (propSheet.m_Page5.m_inet != FALSE) {
               // Set final ICO setup information                               (Page 6)
               setcnf(CNF_IPADDR,(CHAR *)(LPCTSTR)propSheet.m_Page6.m_ipval);
               applyem((CHAR *)MSG_GALTCPIP);
               myProg.m_progress.StepIt();
               setcnf(CNF_IPNSVR,(CHAR *)(LPCTSTR)propSheet.m_Page6.m_msgdns);
               setcnf(CNF_HOSTNAM,(CHAR *)(LPCTSTR)propSheet.m_Page6.m_msghst);
               setcnf(CNF_DOMAIN,(CHAR *)(LPCTSTR)propSheet.m_Page6.m_msgdmn);
               applyem((CHAR *)MSG_GALDNS);
               yesinet();
               myProg.m_progress.StepIt();
          }
          else {
               noinet();
          }
          if ((lstfp=fopen(RUN_WGSINT,FOPWA)) != NULL) {
               fprintf(lstfp,"Run it again!\n");
               fclose(lstfp);
          }
          myProg.DestroyWindow();
     }
}

void CWizardDlg::SetString(
CString *ostr,
const CHAR *newstr,
INT len)
{
     LPTSTR pstr;

     pstr=ostr->GetBuffer(len);
     stlcpy(pstr,newstr,len);
     ostr->ReleaseBuffer();
}

void CWizardDlg::SetMSGText(
CString *ostr,
const CHAR *msgfil,
const CHAR *varnam,
INT len)
{
     LPTSTR pstr;
     CHAR *opval;

     opval=mstscan((CHAR *)msgfil,(CHAR *)varnam,len);
     if (opval != NULL) {
          pstr=ostr->GetBuffer(len);
          stlcpy(pstr,opval,len);
          ostr->ReleaseBuffer();
     }
}

void CWizardDlg::SetMSGValue(
CString *ostr,
const CHAR *msgfil,
const CHAR *varnam,
INT len)
{
     LPTSTR pstr;
     CHAR *opval;

     opval=msgscan((CHAR *)msgfil,(CHAR *)varnam);
     if (opval != NULL) {
          pstr=ostr->GetBuffer(len);
          stlcpy(pstr,opval,len);
          ostr->ReleaseBuffer();
     }
}

void CWizardDlg::OnNext0()
{
     CDialog::OnOK();
     OnWizard();
}

void CWizardDlg::noinet()
{
     FILE *lstfp;
     CHAR *ptr;
     CHAR dmdnam[FNMLEN];
     CHAR gpnum[2];
     INT iloop;
     GBOOL needapply;
     CString msgopt;
     CString chkopt;

     if ((lstfp=fopen(LST_GALINTAP,FOPRA)) == NULL) {
          CString tmp;
          tmp.LoadString(IDS_ERROR4);
          ::MessageBox(this->GetSafeHwnd(),(LPCTSTR)tmp,WIZARD_CAPTION,MB_ICONEXCLAMATION|MB_OK
               |MB_APPLMODAL);
          return;
     }
     while (fgets(inbuf,BUFSIZ,lstfp) != NULL) {
          depad(inbuf);
          stlcpy(dmdnam,inbuf,FNMLEN);
          if ((ptr=strrchr(dmdnam,'.')) != NULL) {
               *ptr='\0';
               stlcat(dmdnam,EXT_DMD,FNMLEN);
          }
          if (access(dmdnam,0) != -1 && access(inbuf,0) != -1) {
               unlink(inbuf);
          }
          else {
               rename(inbuf,dmdnam);
          }
     }
     fclose(lstfp);
     needapply=FALSE;
     gpnum[1]='\0';
     for (iloop=0; iloop < 16; iloop++) {
          gpnum[0]='1'+(CHAR)iloop;
          msgopt="GROUP";
          msgopt+=gpnum;
          SetMSGValue(&chkopt,MSG_WGSMAJOR,(LPCTSTR)msgopt,7);
          if (sameas((CHAR *)(LPCTSTR)chkopt,"TCP/IP")) {
               setcnf((CHAR *)(LPCTSTR)msgopt,"<NONE>");
               needapply=TRUE;
          }
     }
     if (needapply) {
          applyem((CHAR *)MSG_WGSMAJOR);
     }
}

void CWizardDlg::yesinet()
{
     FILE *lstfp;
     CHAR *ptr;
     CHAR dmdnam[FNMLEN];

     if (access(DMD_GALTCPIP,0) != -1) {
          if ((lstfp=fopen(LST_GALINTAP,FOPRA)) == NULL) {
               CString tmp;
               tmp.LoadString(IDS_ERROR3);
               ::MessageBox(this->GetSafeHwnd(),(LPCTSTR)tmp,WIZARD_CAPTION,MB_ICONEXCLAMATION
                    |MB_OK|MB_APPLMODAL);
               return;
          }
          while (fgets(inbuf,BUFSIZ,lstfp) != NULL) {
               depad(inbuf);
               stlcpy(dmdnam,inbuf,FNMLEN);
               if ((ptr=strrchr(dmdnam,'.')) != NULL) {
                    *ptr='\0';
                    stlcat(dmdnam,EXT_DMD,FNMLEN);
               }
               unlink(inbuf);
               rename(dmdnam,inbuf);
          }
          fclose(lstfp);
     }
}

VOID
goodunlink(
const CHAR *fname)
{
     Cffblk fblk;

     if (fnd1st(&fblk,fname,0)) {
          if (fblk.ff_attrib&FAMRON) {
               chmod(fblk.ff_name,_S_IWRITE);
          }
          unlink(fblk.ff_name);
     }
     while (fndnxt(&fblk)) {
          if (fblk.ff_attrib&FAMRON) {
               chmod(fblk.ff_name,_S_IWRITE);
          }
          unlink(fblk.ff_name);
     }
}

VOID
massunlink(
const CHAR **flist)
{
     INT fcnt;

     fcnt=0;
     while (flist[fcnt] != NULL ) {
          goodunlink(flist[fcnt++]);
     }
}

VOID
massdisable(
const CHAR **mlist)
{
     INT mcnt;
     CHAR namorg[30];
     CHAR nammdf[30];
     Cffblk fb;

     mcnt=0;
     while (mlist[mcnt] != NULL) {
          strcpy(nammdf,mlist[mcnt]);
          strcat(nammdf,".MDF");
          if (fnd1st(&fb,nammdf,0)) {
               strcpy(namorg,mlist[mcnt]);
               strcat(namorg,".DMD");
               rename(nammdf,namorg);
               unlink(nammdf);
          }
          mcnt++;
     }
}

VOID
mmcvt(VOID)                         // convert multimedia files
{
     Cffblk fb;

     if (fnd1st(&fb,ARTMSG,0)) {
          setopt("SPLASHF",TRUE);
          setopt("TBBOPT",TRUE);
          setopt("TMRVAL",TRUE);
          setopt("BUTEXT",FALSE);
          setopt("SPLASHS",TRUE);
          setopt("ARTPRG",TRUE);
          setopt("ICOLFORE",TRUE);
          setopt("ICOLBACK",TRUE);
          applyem(NEWMSG);
          rename(ARTMSG,OLDMSG);
     }
     if (fnd1st(&fb,NEWMSG,0)) {
          movart();
     }
     movlau();
}

VOID
setopt(                            // copy option values between files
CHAR *optnam,                      //   name of option
BOOL justlast)                     //   whether to do just last word
{
     CHAR *s;

     if ((s=mstscan(ARTMSG,optnam,OPTSIZE)) != NULL) {
          setcnf(optnam,justlast ? lastwd(s) : s);
     }
}



VOID
movart(VOID)                       // move files from art dir to hps dir
{
     Cffblk fb;
     Cffblk fb2;
     CHAR *s;
     CHAR c;
     static CHAR newdir[MAXPATH],src[MAXPATH],dst[MAXPATH];

     if ((s=mstscan(NEWMSG,"HPSPP",OPTSIZE)) != NULL) {
          stlcpy(newdir,s,MAXPATH);
     }
     else {
          stlcpy(newdir,NEWDEF,MAXPATH);
     }
     if (strlen(newdir) > 0) {
          c=newdir[strlen(newdir)-1];
          if (c != '/' && c != '\\' && c != ':') {
               stlcat(newdir,"/",MAXPATH);
          }
          if (fnd1st(&fb,ARTDIR"*.*",0)) {
               mkdir(newdir);
               do {
                    sprintf(src,ARTDIR"%s",fb.ff_name);
                    sprintf(dst,"%s%s",newdir,fb.ff_name);
                    if (!fnd1st(&fb2,dst,0)) {
                         if (rename(src,dst) != 0) {
                              if (copyfile(src,dst)) {
                                   unlink(src);
                              }
                         }
                    }
               } while (fndnxt(&fb));
          }
     }
}

VOID
movlau(VOID)                       // move launch assignments
{
     Cffblk fb;
     DFAFILE *bb=NULL;             // btrieve block for menu data file
     struct mnupag *mnupg;         // menu page structure
     char modnam[MNMSIZ];

     if (!fnd1st(&fb,MNUDAT,0) || !fnd1st(&fb,LAUMDF,0)) {
          return;
     }
     stzcpy(modnam,gmdnam(LAUMDF),MNMSIZ);
     mnupg=(struct mnupag *)alczer(sizeof(struct mnupag));
     dfaMode(PRIMBV);
     bb=dfaOpen(MNUDAT,sizeof(struct mnupag),NULL);
     mnupg->menutype[0]='C';
     while (dfaAcqGT(mnupg,mnupg,0)) {
          if ((mnupg->flags&CSMPAG) && sameas(mnupg->modnam,modnam)) {
               memset(mnupg->modnam,0,MNMSIZ);
               mnupg->flags=(mnupg->flags&(CNGOTO|DISABL))|NOFPHD|FILPAG;
               stzcpy(mnupg->fname,skpwht(skpwrd(mnupg->cmdstg)),FNMSIZ);
               memset(mnupg->cmdstg,0,CMDSIZ);
               dfaUpdate(mnupg);
          }
     }
     dfaClose(bb);
     free(mnupg);
}

BOOL
canCancel(
VOID)
{
     return(!mustFinish);
}

VOID revclean(VOID)
{
     INT i;

     newfls=(CHAR **)alcmem(MAXFIL*sizeof(CHAR *));
     for (i=0 ; i < MAXFIL ; i++) {
          newfls[i]=(CHAR *)alczer(FNEXSZ);
     }
     getcwd(savdir,GCMAXPTH);
     prcgcs();
     prcmdf(MDFSPC);
     prcmdf(DMDSPC);
     for (i=0 ; i < MAXFIL ; i++) {
          free(newfls[i]);
     }
     free(newfls);
}

VOID
clrlst(VOID)                       // clears new file list
{
     INT i;

     numfls=0;
     for (i=0 ; i < MAXFIL ; i++) {
          setmem(newfls[i],FNEXSZ,0);
     }
}

GBOOL                              //   return TRUE if file is in list
inlist(                            // is file name in new files list?
CHAR *filnam)                      //   file name to look for
{
     INT i;

     for (i=0 ; i < numfls ; i++) {
          if (sameas(newfls[i],filnam)) {
               return(TRUE);
          }
     }
     return(FALSE);
}

VOID
prcgcs(VOID)                       // process files in gcsvcman.lst
{
     CHAR fptmp[GCMAXFNM];

     if (chdir(GCSDIR) == -1) {
          catastro("PRCGCS: Error changing to %s!",fnmcse("gcsvcman"));
     }
     if ((lstfp=fopen(GCSLST,FOPRA)) == NULL) {
          catastro("PRCGCS: Error opening %s for input!",fnmcse("gcsvcman.lst"));
     }
     clrlst();
     while (fgets(lstbuf,BUFSIZ,lstfp) != NULL && numfls < MAXFIL) {
          stlcpy(newfls[numfls++],unpad(fileparts(GCPART_FNAM,lstbuf,fptmp,GCMAXFNM)),
               FNEXSZ);
     }
     if (fnd1st(&fb,ALLFIL,0)) {
          do {
               if (!sameas(fb.ff_name,GCSLST) && !inlist(fb.ff_name)) {
                    unlink(fb.ff_name);
               }
          } while (fndnxt(&fb));
     }
     if (chdir(savdir) == -1) {
          catastro("PRCGCS: Error restoring current directory!");
     }
     fclose(lstfp);
}

VOID
prcmdf(                            // process files in all .MDF/.DMD files
CHAR *spec)                        //   file spec to search (*.MDF, *.DMD)
{
     CHAR *filnam;
     CHAR *mdfnam;
     CHAR fptmp[GCMAXFNM];
     GBOOL revcln;
     Cffblk appfb;

     if (fnd1st(&fb,spec,0)) {
          do {
               mdfnam=gmdname(fb.ff_name);
               clrlst();
               revcln=FALSE;
               if (tfsopn(fb.ff_name)) {
                    while (tfsrdl() != TFSDUN) {
                         if (tfstate == TFSLIN) {
                              if (tfspfx(CLIEXE)) {
                                   stlcpy(newfls[numfls++],tfspst,FNEXSZ);
                                   revcln=TRUE;
                              }
                              else if (tfspfx(CLISUP) || tfspfx(SHRSUP)) {
                                   if ((filnam=strtok(tfspst,DELIMS)) != NULL) {
                                        do {
                                             stlcpy(newfls[numfls++],filnam,
                                                    FNEXSZ);
                                        } while ((filnam=strtok(NULL,DELIMS))
                                              != NULL && numfls < MAXFIL);
                                   }
                              }
                         }
                    }
                    if (revcln) {
                         fileparts(GCPART_FILE,fb.ff_name,fptmp,GCMAXFNM);
                         if (chdir(fptmp) == 0) {
                              if (fnd1st(&appfb,ALLFIL,0)) {
                                   do {
                                        if (!inlist(appfb.ff_name)) {
                                             unlink(appfb.ff_name);
                                        }
                                   } while (fndnxt(&appfb));
                              }
                              if (chdir(savdir) == -1) {
                                   catastro("PRCMDF: Error restoring current "
                                            "directory!");
                              }
                         }
                    }
               }
          } while (fndnxt(&fb));
     }
}

CHAR *
gmdname(                           // get module name from .MDF/.DMD file
CHAR *mdfnam)                      //   name of module's .MDF file
{
     FILE *fp;
     static CHAR tmpbuf[40];

     if ((fp=fopen(mdfnam,FOPRA)) != NULL) {
          while (fgets(tmpbuf,sizeof(tmpbuf),fp) != NULL) {
               if (sameto(MODNAM,tmpbuf)) {
                    unpad(tmpbuf);
                    fclose(fp);
                    return(skpwht(tmpbuf+MNOSET));
               }
          }
          fclose(fp);
     }
     return("");
}

BOOL CWizardDlg::PreTranslateMessage(MSG* pMsg)
{
	if ((pMsg->message == WM_CHAR) || (pMsg->message == WM_KEYDOWN)) {
          if (pMsg->wParam == VK_ESCAPE) {
               return(TRUE);
          }
     }
	return CDialog::PreTranslateMessage(pMsg);
}

VOID
CopyTypeFiles(
const CHAR *fromdir,
const CHAR *todir)
{
     CHAR filename[GCMAXPTH];
     CHAR fromfile[GCMAXPTH];
     CHAR tofile[GCMAXPTH];
     Cffblk fb;

     sprintf(fromfile,"%s*.*",fromdir);
     if (fnd1st(&fb,fromfile,0)) {
          do {
               sprintf(tofile,"%s%s",todir,fb.ff_name);
               if (access(tofile,0) == -1) {
                    sprintf(filename,"%s%s",fromdir,fb.ff_name);
                    cpyutl(filename,tofile,FOPRB,FOPWB);
                }
          } while (fndnxt(&fb));
     }
}
