/***************************************************************************
 *                                                                         *
 *   WGSSETCL.C                                                            *
 *                                                                         *
 *   Copyright (c) 1991-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the utility to set up the files WGSCLAS2.DAT and WGSKEY2.DAT  *
 *   for default accounting class set and keyring definitions.             *
 *                                                                         *
 *                                                 - C. Robert 2/17/92     *
 *                                                                         *
 ***************************************************************************/

#include "stdafx.h"

INT GetAccount(GBOOL *);
VOID SetAccount(INT);
static INT getold(DFAFILE *,GBOOL *);
static VOID savcls(DFAFILE *,INT,INT);
static VOID savstf(DFAFILE *,struct acclass *,INT,INT);
static VOID uporin(struct acclass *);
static VOID svmsgs(INT);
static VOID savkys(DFAFILE *);
static VOID kinsert(CHAR *);

static const INT xlts[]={1,2,3,4,0};    // choices below x-late to these #s
static const INT xlts2[]={4,0,1,2,3};   // (reverse translation)
#ifdef WEBCAST
static const CHAR *tstcls[]={"DEMO","BROADCASTER","PROSPECT","APPLICATION","DELETE_ACCOUNT"};
static const CHAR *clsset[]={"DEMO","BROADCASTER","PROSPECT","APPLICATION","MEMBER"};
#else
static const CHAR *tstcls[]={"DEMO","USER","PROSPECT","APPLICATION","DELETE_ACCOUNT"};
static const CHAR *clsset[]={"DEMO","USER","PROSPECT","APPLICATION","MEMBER"};
#endif // WEBCAST

INT
GetAccount(
GBOOL *wasrun)                     // get current Account information
{
     DFAFILE *clsbb;               // BTRIEVE pointer to the WGSCLAS2.DAT file
     INT oldtype=0;                // old system accounting type
     INT ctype=0;

     clsbb=dfaOpen(DAT_WGSCLAS2,sizeof(struct acclass),NULL);
     oldtype=getold(clsbb,wasrun);
     if (oldtype > 0) {
          ctype=xlts2[oldtype-1];
     }
     dfaClose(clsbb);
     return(ctype);
}

VOID
SetAccount(                        // main program loop
INT model)                         // Accounting model to set
{
     struct usracc tmpacc;
     DFAFILE *accbb;
     DFAFILE *keysbb;              // BTRIEVE pointer to the WGSKEY2.DAT file
     DFAFILE *clsbb;               // BTRIEVE pointer to the WGSCLAS2.DAT file
     INT oldtype=0;                // the old system type the guy had selected
     INT curtype=0;                // the current system type if exists

     keysbb=dfaOpen(DAT_WGSKEY2,RINGSZ,NULL);
     clsbb=dfaOpen(DAT_WGSCLAS2,sizeof(struct acclass),NULL);
     oldtype=getold(clsbb,NULL);
     if ((model != -ESC) && !(oldtype && (xlts[model] == oldtype-1))) {
          model=xlts[model];
          if (oldtype) {
               accbb=dfaOpen(DAT_WGSUSR2,sizeof(struct usracc),NULL);
               dfaSetBlk(accbb);
               stlcpy(tmpacc.userid,FLD_TEST,UIDSIZ);
               if (dfaAcqEQ(&tmpacc,tmpacc.userid,0)) {
                    stlcpy(tmpacc.curcls,tstcls[model],KEYSIZ);
                    stlcpy(tmpacc.prmcls,tstcls[model],KEYSIZ);
                    dfaUpdate(&tmpacc);
               }
               dfaClose(accbb);
          }
          savcls(clsbb,model,oldtype);
          savkys(keysbb);
          svmsgs(model);
     }
     dfaClose(clsbb);
     dfaClose(keysbb);
}

static INT
getold(
DFAFILE *cbb,
GBOOL *run)                        // get old system type from data file
{
     INT i=0;
     INT otype=0;
     struct acclass tmptype;

     if (run != NULL) {
          *run=FALSE;
     }
     dfaSetBlk(cbb);
     if (dfaAcqLO(&tmptype,0)) {
          if (run != NULL) {
               *run=TRUE;
          }
     }
     while (i < 5 && dfaAcqEQ(&tmptype,(void *)clsset[i++],0)) {
          if (!((tmptype.flags&HASCRD) && (tmptype.flags&NOCRED))) {
               otype=i;
               break;
          }
     }
     if (otype == 2) {
          if (dfaAcqEQ(&tmptype,"APPLICATION",0)) {
               if (!((tmptype.flags&HASCRD) && (tmptype.flags&NOCRED))) {
                    otype=4;
               }
          }
     }
     dfaRstBlk();
     return(otype);
}

static VOID
savcls(                            // save the class sets to WGSCLAS2.DAT
DFAFILE *clsbb,
INT keep,                          // which set # to keep?
INT otype)                         // old class setup
{
     struct acclass *curtype;

     dfaSetBlk(clsbb);
     curtype=(struct acclass *)alcmem(sizeof(struct acclass));
     memset(curtype,0,sizeof(struct acclass));
     strcpy(curtype->clname,"DEMO");
     savstf(clsbb,curtype,keep,otype);
     strcpy(curtype->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curtype->nxtcls[3],"PAYING");
          break;
     case 1:
#ifdef WEBCAST
          strcpy(curtype->nxtcls[3],"BROADCASTER");
#else
          strcpy(curtype->nxtcls[3],"USER");
#endif // WEBCAST
          break;
     case 2:
          strcpy(curtype->nxtcls[3],"PROSPECT");
          break;
     case 3:
          strcpy(curtype->nxtcls[3],"APPLICATION");
          break;
     case 4:
          strcpy(curtype->nxtcls[3],"DELETE_ACCOUNT");
          break;
     }
     curtype->limcal=10;
     curtype->dftday=curtype->limday=-1;
     curtype->dbtlmt=0L;
     curtype->idlday=60;
     if (keep == 0) {
          curtype->flags|=(IDLEXP|HASCRD|KCKOFF);
     }
     else {
          curtype->flags|=(HASCRD|NOCRED);
     }
     uporin(curtype);
     memset(curtype,0,sizeof(struct acclass));
     strcpy(curtype->clname,"PAYING");
     savstf(clsbb,curtype,keep,otype);
     strcpy(curtype->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curtype->nxtcls[3],"DEMO");
          break;
     case 1:
#ifdef WEBCAST
          strcpy(curtype->nxtcls[3],"BROADCASTER");
#else
          strcpy(curtype->nxtcls[3],"USER");
#endif // WEBCAST
          break;
     case 2:
          strcpy(curtype->nxtcls[3],"CUSTOMER");
          break;
     case 3:
#ifdef WEBCAST
          strcpy(curtype->nxtcls[3],"BROADCASTER");
#else
          strcpy(curtype->nxtcls[3],"USER");
#endif // WEBCAST
          break;
     case 4:
          strcpy(curtype->nxtcls[3],"MEMBER");
          break;
     }
     curtype->limcal=curtype->limday=curtype->dftday=-1;
     curtype->dbtlmt=0L;
     curtype->idlday=730;
     if (keep == 0) {
          curtype->flags|=(IDLEXP|NOCRED|KCKOFF);
     }
     else {
          curtype->flags|=(HASCRD|NOCRED);
     }
     uporin(curtype);
     memset(curtype,0,sizeof(struct acclass));
     strcpy(curtype->clname,"MONTHLY");
     savstf(clsbb,curtype,keep,otype);
     strcpy(curtype->nxtcls[0],"PAYING");
     strcpy(curtype->nxtcls[1],"DELETE_ACCOUNT");
     strcpy(curtype->nxtcls[2],"PAYING");
     switch (keep) {
     case 0:
          strcpy(curtype->nxtcls[3],"PAYING");
          break;
     case 1:
#ifdef WEBCAST
          strcpy(curtype->nxtcls[3],"BROADCASTER");
#else
          strcpy(curtype->nxtcls[3],"USER");
#endif // WEBCAST
          break;
     case 2:
          strcpy(curtype->nxtcls[3],"CUSTOMER");
          break;
     case 3:
#ifdef WEBCAST
          strcpy(curtype->nxtcls[3],"BROADCASTER");
#else
          strcpy(curtype->nxtcls[3],"USER");
#endif // WEBCAST
          break;
     case 4:
          strcpy(curtype->nxtcls[3],"MEMBER");
          break;
     }
     curtype->limcal=-1;
     curtype->limday=180;
     curtype->dftday=30;
     curtype->dbtlmt=0L;
     curtype->idlday=730;
     if (keep == 0) {
          curtype->flags|=(IDLEXP|DAYEXP|CRDXMT|CLSCHG);
     }
     else {
          curtype->flags|=(HASCRD|NOCRED);
     }
     uporin(curtype);
     setmem(curtype,0,sizeof(struct acclass));
     strcpy(curtype->clname,"WEEKLY");
     savstf(clsbb,curtype,keep,otype);
     strcpy(curtype->nxtcls[0],"PAYING");
     strcpy(curtype->nxtcls[1],"DELETE_ACCOUNT");
     strcpy(curtype->nxtcls[2],"PAYING");
     switch (keep) {
     case 0:
          strcpy(curtype->nxtcls[3],"PAYING");
          break;
     case 1:
#ifdef WEBCAST
          strcpy(curtype->nxtcls[3],"BROADCASTER");
#else
          strcpy(curtype->nxtcls[3],"USER");
#endif // WEBCAST
          break;
     case 2:
          strcpy(curtype->nxtcls[3],"CUSTOMER");
          break;
     case 3:
#ifdef WEBCAST
          strcpy(curtype->nxtcls[3],"BROADCASTER");
#else
          strcpy(curtype->nxtcls[3],"USER");
#endif // WEBCAST
          break;
     case 4:
          strcpy(curtype->nxtcls[3],"MEMBER");
          break;
     }
     curtype->limcal=-1;
     curtype->limday=180;
     curtype->dftday=7;
     curtype->dbtlmt=0L;
     curtype->idlday=730;
     if (keep == 0) {
          curtype->flags|=(IDLEXP|DAYEXP|CRDXMT|CLSCHG);
     }
     else {
          curtype->flags|=(HASCRD|NOCRED);
     }
     uporin(curtype);
     memset(curtype,0,sizeof(struct acclass));
     strcpy(curtype->clname,"BILLED");
     savstf(clsbb,curtype,keep,otype);
     strcpy(curtype->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curtype->nxtcls[3],"PAYING");
          break;
     case 1:
#ifdef WEBCAST
          strcpy(curtype->nxtcls[3],"BROADCASTER");
#else
          strcpy(curtype->nxtcls[3],"USER");
#endif // WEBCAST
          break;
     case 2:
          strcpy(curtype->nxtcls[3],"CUSTOMER");
          break;
     case 3:
#ifdef WEBCAST
          strcpy(curtype->nxtcls[3],"BROADCASTER");
#else
          strcpy(curtype->nxtcls[3],"USER");
#endif // WEBCAST
          break;
     case 4:
          strcpy(curtype->nxtcls[3],"MEMBER");
          break;
     }
     curtype->limcal=curtype->limday=curtype->dftday=-1;
     curtype->dbtlmt=-1L;
     curtype->idlday=730;
     if (keep == 0) {
          curtype->flags|=(IDLEXP|FSTMTH|REPDBT|KCKOFF);
     }
     else {
          curtype->flags|=(HASCRD|NOCRED);
     }
     uporin(curtype);
     memset(curtype,0,sizeof(struct acclass));
     strcpy(curtype->clname,"PROSPECT");
     savstf(clsbb,curtype,keep,otype);
     strcpy(curtype->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curtype->nxtcls[3],"DEMO");
          break;
     case 1:
#ifdef WEBCAST
          strcpy(curtype->nxtcls[3],"BROADCASTER");
#else
          strcpy(curtype->nxtcls[3],"USER");
#endif // WEBCAST
          break;
     case 3:
          strcpy(curtype->nxtcls[3],"APPLICATION");
          break;
     case 4:
          strcpy(curtype->nxtcls[3],"DELETE_ACCOUNT");
          break;
     }
     curtype->limcal=30;
     curtype->limday=-1;
     curtype->dftday=-1;
     curtype->dbtlmt=-1L;
     curtype->idlday=60;
     if (keep == 2) {
          curtype->flags|=(CRDXMT|IDLEXP|KCKOFF);
     }
     else {
          curtype->flags|=(HASCRD|NOCRED);
     }
     uporin(curtype);
     memset(curtype,0,sizeof(struct acclass));
     strcpy(curtype->clname,"CUSTOMER");
     savstf(clsbb,curtype,keep,otype);
     strcpy(curtype->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curtype->nxtcls[3],"PAYING");
          break;
     case 1:
#ifdef WEBCAST
          strcpy(curtype->nxtcls[3],"BROADCASTER");
#else
          strcpy(curtype->nxtcls[3],"USER");
#endif // WEBCAST
          break;
     case 3:
#ifdef WEBCAST
          strcpy(curtype->nxtcls[3],"BROADCASTER");
#else
          strcpy(curtype->nxtcls[3],"USER");
#endif // WEBCAST
          break;
     case 4:
          strcpy(curtype->nxtcls[3],"MEMBER");
          break;
     }
     curtype->limcal=curtype->limday=-1;
     curtype->dftday=-1;
     curtype->dbtlmt=-1L;
     curtype->idlday=730;
     if (keep == 2) {
          curtype->flags|=(IDLEXP|CRDXMT|KCKOFF);
     }
     else {
          curtype->flags|=(HASCRD|NOCRED);
     }
     uporin(curtype);
     memset(curtype,0,sizeof(struct acclass));
     strcpy(curtype->clname,"STAFF");
     savstf(clsbb,curtype,keep,otype);
     strcpy(curtype->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curtype->nxtcls[3],"PAYING");
          break;
     case 1:
#ifdef WEBCAST
          strcpy(curtype->nxtcls[3],"BROADCASTER");
#else
          strcpy(curtype->nxtcls[3],"USER");
#endif // WEBCAST
          break;
     case 3:
          strcpy(curtype->nxtcls[3],"SUPERVISOR");
          break;
     case 4:
          strcpy(curtype->nxtcls[3],"COORDINATOR");
          break;
     }
     curtype->limcal=curtype->limday=-1;
     curtype->dftday=-1;
     curtype->dbtlmt=-1L;
     curtype->idlday=9999;
     if (keep == 2) {
          curtype->flags|=(CRDXMT|KCKOFF);
     }
     else {
          curtype->flags|=(HASCRD|NOCRED);
     }
     uporin(curtype);
     memset(curtype,0,sizeof(struct acclass));
     strcpy(curtype->clname,"APPLICATION");
     savstf(clsbb,curtype,keep,otype);
     strcpy(curtype->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curtype->nxtcls[3],"DEMO");
          break;
     case 1:
#ifdef WEBCAST
          strcpy(curtype->nxtcls[3],"BROADCASTER");
#else
          strcpy(curtype->nxtcls[3],"USER");
#endif // WEBCAST
          break;
     case 2:
          strcpy(curtype->nxtcls[3],"PROSPECT");
          break;
     case 4:
          strcpy(curtype->nxtcls[3],"DELETE_ACCOUNT");
          break;
     }
     curtype->dftday=-1;
     curtype->dbtlmt=-1L;
     curtype->idlday=60;
     if (keep == 3) {
          curtype->flags|=(IDLEXP|KCKOFF);
     }
     else {
          curtype->flags|=(HASCRD|NOCRED);
     }
     uporin(curtype);
     memset(curtype,0,sizeof(struct acclass));
#ifdef WEBCAST
     strcpy(curtype->clname,"BROADCASTER");
#else
     strcpy(curtype->clname,"USER");
#endif // WEBCAST
     savstf(clsbb,curtype,keep,otype);
     strcpy(curtype->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curtype->nxtcls[3],"PAYING");
          break;
     case 2:
          strcpy(curtype->nxtcls[3],"CUSTOMER");
          break;
     case 4:
          strcpy(curtype->nxtcls[3],"MEMBER");
          break;
     }
     curtype->limcal=curtype->limday=-1;
     curtype->dftday=-1;
     curtype->dbtlmt=-1L;
     curtype->idlday=730;
     if (keep == 1 || keep == 3) {
          curtype->flags|=(IDLEXP|CRDXMT|KCKOFF);
     }
     else {
          curtype->flags|=(HASCRD|NOCRED);
     }
     uporin(curtype);
     memset(curtype,0,sizeof(struct acclass));
     strcpy(curtype->clname,"SUPERVISOR");
     savstf(clsbb,curtype,keep,otype);
     strcpy(curtype->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curtype->nxtcls[3],"PAYING");
          break;
     case 1:
#ifdef WEBCAST
          strcpy(curtype->nxtcls[3],"BROADCASTER");
#else
          strcpy(curtype->nxtcls[3],"USER");
#endif // WEBCAST
          break;
     case 2:
          strcpy(curtype->nxtcls[3],"STAFF");
          break;
     case 4:
          strcpy(curtype->nxtcls[3],"COORDINATOR");
          break;
     }
     curtype->limcal=curtype->limday=-1;
     curtype->dftday=-1;
     curtype->dbtlmt=-1L;
     curtype->idlday=9999;
     if (keep == 3) {
          curtype->flags|=(CRDXMT|KCKOFF);
     }
     else {
          curtype->flags|=(HASCRD|NOCRED);
     }
     uporin(curtype);
     memset(curtype,0,sizeof(struct acclass));
     strcpy(curtype->clname,"MEMBER");
     savstf(clsbb,curtype,keep,otype);
     strcpy(curtype->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curtype->nxtcls[3],"PAYING");
          break;
     case 1:
#ifdef WEBCAST
          strcpy(curtype->nxtcls[3],"BROADCASTER");
#else
          strcpy(curtype->nxtcls[3],"USER");
#endif // WEBCAST
          break;
     case 2:
          strcpy(curtype->nxtcls[3],"CUSTOMER");
          break;
     case 3:
#ifdef WEBCAST
          strcpy(curtype->nxtcls[3],"BROADCASTER");
#else
          strcpy(curtype->nxtcls[3],"USER");
#endif // WEBCAST
          break;
     }
     curtype->limcal=curtype->limday=-1;
     curtype->dftday=-1;
     curtype->dbtlmt=-1L;
     curtype->idlday=730;
     if (keep == 4) {
          curtype->flags|=(IDLEXP|CRDXMT|KCKOFF);
     }
     else {
          curtype->flags|=(HASCRD|NOCRED);
     }
     uporin(curtype);
     memset(curtype,0,sizeof(struct acclass));
     strcpy(curtype->clname,"COORDINATOR");
     savstf(clsbb,curtype,keep,otype);
     strcpy(curtype->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curtype->nxtcls[3],"PAYING");
          break;
     case 1:
#ifdef WEBCAST
          strcpy(curtype->nxtcls[3],"BROADCASTER");
#else
          strcpy(curtype->nxtcls[3],"USER");
#endif // WEBCAST
          break;
     case 2:
          strcpy(curtype->nxtcls[3],"STAFF");
          break;
     case 3:
          strcpy(curtype->nxtcls[3],"SUPERVISOR");
          break;
     }
     curtype->limcal=curtype->limday=-1;
     curtype->dftday=-1;
     curtype->dbtlmt=-1L;
     curtype->idlday=9999;
     if (keep == 4) {
          curtype->flags|=(CRDXMT|KCKOFF);
     }
     else {
          curtype->flags|=(HASCRD|NOCRED);
     }
     uporin(curtype);
     memset(curtype,0,sizeof(struct acclass));
     strcpy(curtype->clname,"SYSOP");
     savstf(clsbb,curtype,keep,otype);
     curtype->limcal=curtype->limday=curtype->dftday=-1;
     curtype->flags|=(CRDXMT|KCKOFF);
     curtype->dbtlmt=-1L;
     curtype->idlday=9999;
     if (!dfaQueryEQ("SYSOP",0)) {
          dfaInsert(curtype);
     }
     dfaRstBlk();
}

static VOID
savstf(                            // save some things from the old record
DFAFILE *clsbb,
struct acclass *clsptr,            // pointer to class to fill in
INT keep,                          // which class set is being kept?
INT otype)                         // old class setup
{
     static struct acclass tmpcls;

     dfaSetBlk(clsbb);
     if (dfaAcqEQ(&tmpcls,clsptr->clname,0)) {
          clsptr->seconds=tmpcls.seconds;
          clsptr->users=tmpcls.users;
     }
     else if (otype == 0) {
          if (sameas(clsptr->clname,"SYSOP")
              || sameas(clsptr->clname,tstcls[keep])) {
               clsptr->users=1;
          }
     }
     dfaRstBlk();
}

static VOID
uporin(                            // update or insert a class record
struct acclass *clsptr)            // pointer to record to update/ins
{
     if (dfaAcqEQ(NULL,clsptr->clname,0)) {
          dfaUpdate(clsptr);
     }
     else {
          dfaInsert(clsptr);
     }
}

static VOID
svmsgs(                            // save all the message options
INT keep)                          // which set # to keep?
{
     CHAR supcls[KEYSIZ];
     CHAR shwcrd[KEYSIZ];
     CHAR sampln[KEYSIZ];

     switch (keep) {
     case 0:
          strcpy(supcls,"DEMO");
          strcpy(shwcrd,"YES");
          strcpy(sampln,"256");
          break;
     case 1:
#ifdef WEBCAST
          strcpy(supcls,"BROADCASTER");
#else
          strcpy(supcls,"USER");
#endif // WEBCAST
          strcpy(shwcrd,"NO");
          strcpy(sampln,"256");
          break;
     case 2:
          strcpy(supcls,"PROSPECT");
          strcpy(shwcrd,"NO");
          strcpy(sampln,"256");
          break;
     case 3:
          strcpy(supcls,"APPLICATION");
          strcpy(shwcrd,"NO");
          strcpy(sampln,"256");
          break;
     case 4:
          strcpy(supcls,"MEMBER");
          strcpy(shwcrd,"NO");
          strcpy(sampln,"0");
          break;
     }
     setcnf("SUPCLS",supcls);
     setcnf("SHWCRD",shwcrd);
     applyem("wgssup.msg");
     setcnf("SAMPLN",sampln);
     applyem("wgsmajor.msg");
}

static VOID
savkys(
DFAFILE *kbb)                      // save keyring records to WGSKEY2.DAT
{
     CHAR holding[RINGSZ];

     dfaSetBlk(kbb);
     memset(holding,0,RINGSZ);
     strcpy(&holding[KLSTOF],"DEMO");
     stlcpy(holding,"&DEMO",30);
     kinsert(holding);
     stlcpy(holding,"&PROSPECT",30);
     kinsert(holding);
     stlcpy(holding,"&APPLICATION",30);
     kinsert(holding);
     memset(holding,0,RINGSZ);
     strcpy(&holding[KLSTOF],"DEMO NORMAL MODERATE");
     stlcpy(holding,"&PAYING",30);
     kinsert(holding);
     stlcpy(holding,"&MONTHLY",30);
     kinsert(holding);
     stlcpy(holding,"&WEEKLY",30);
     kinsert(holding);
     stlcpy(holding,"&BILLED",30);
     kinsert(holding);
     memset(holding,0,RINGSZ);
#ifdef WEBCAST
     strcpy(&holding[KLSTOF],"DEMO NORMAL BROADCASTER");
     stlcpy(holding,"&BROADCASTER",30);
#else
     strcpy(&holding[KLSTOF],"DEMO NORMAL");
     stlcpy(holding,"&USER",30);
#endif // WEBCAST
     kinsert(holding);
     stlcpy(holding,"&CUSTOMER",30);
     kinsert(holding);
     stlcpy(holding,"&MEMBER",30);
     kinsert(holding);
     memset(holding,0,RINGSZ);
     strcpy(&holding[KLSTOF],"DEMO NORMAL MODERATE MASS_MAILING SUPER");
     stlcpy(holding,"&STAFF",30);
     kinsert(holding);
     stlcpy(holding,"&SUPERVISOR",30);
     kinsert(holding);
     stlcpy(holding,"&COORDINATOR",30);
     kinsert(holding);
     if (!dfaQueryEQ("&SYSOP",0)) {
          setmem(holding,RINGSZ,0);
          strcpy(&holding[KLSTOF],
                 "DEMO NORMAL MODERATE MASS_MAILING SUPER SYSOP");
          stlcpy(holding,"&SYSOP",30);
          dfaInsertV((struct keyrec *)holding,KLSTOF+strlen(&holding[KLSTOF])+1);
     }
     dfaRstBlk();
}

static VOID
kinsert(                           // insert a keyring record (if needed)
CHAR *kysptr)                      // pointer to record to update/ins
{
     if (!dfaQueryEQ(kysptr,0)) {
          dfaInsertV((struct keyrec *)kysptr,KLSTOF+strlen(&kysptr[KLSTOF])+1);
     }
}
