// MyPropertyPage1.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "MyPropertyPage1.h"
#include "DlgCft.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define DIR_NEWPAGES     "NEWPAGES"
#define DIR_CLASSES      "CLASSES"
#define DIR_HELP         "HELP"

#define EXT_HTML         ".HTM"
#define STR_DOMAIN       "<domain name>"

#define CHGSIZ   80                // maximum bytes per old/new zstring    

CString strWebDirectory;

BOOL canCancel(VOID);
VOID finishmove(VOID);
VOID MsgLoop(VOID);
CHAR *changestr(CHAR *filein,CHAR *fileout,const CHAR *tobechgd,const CHAR *chgemto);
VOID moveweb(const CHAR *oldaddr,const CHAR *newaddr,const CHAR* fromdir,const CHAR* todir);
VOID movedir(const CHAR *oldaddr,const CHAR *newaddr,const CHAR* fromdir,const CHAR* todir);
VOID webunlink(const CHAR *fname);

IMPLEMENT_DYNCREATE(CMyPropertyPage1, CPropertyPage)
IMPLEMENT_DYNCREATE(CMyPropertyPage2, CPropertyPage)
IMPLEMENT_DYNCREATE(CMyPropertyPage3, CPropertyPage)
IMPLEMENT_DYNCREATE(CMyPropertyPage4, CPropertyPage)
IMPLEMENT_DYNCREATE(CMyPropertyPage5, CPropertyPage)
IMPLEMENT_DYNCREATE(CMyPropertyPage6, CPropertyPage)


/////////////////////////////////////////////////////////////////////////////
// CMyPropertyPage1 property page

CMyPropertyPage1::CMyPropertyPage1() : CPropertyPage(CMyPropertyPage1::IDD)
{
	//{{AFX_DATA_INIT(CMyPropertyPage1)
	m_sysname = _T("");
	m_mphone = _T("");
	m_cmpname = _T("");
	m_addr1 = _T("");
	m_addr2 = _T("");
	m_pinfo = _T("");
	//}}AFX_DATA_INIT
}

CMyPropertyPage1::~CMyPropertyPage1()
{
}

void CMyPropertyPage1::DoDataExchange(CDataExchange* pDX)
{    
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMyPropertyPage1)
	DDX_Text(pDX, IDC_ESYSNAME, m_sysname);
	DDV_MaxChars(pDX, m_sysname, 50);
	DDX_Text(pDX, IDC_EMPHONE, m_mphone);
	DDV_MaxChars(pDX, m_mphone, 32);
	DDX_Text(pDX, IDC_ECMPNAME, m_cmpname);
	DDV_MaxChars(pDX, m_cmpname, 46);
	DDX_Text(pDX, IDC_EADDR1, m_addr1);
	DDV_MaxChars(pDX, m_addr1, 44);
	DDX_Text(pDX, IDC_EADDR2, m_addr2);
	DDV_MaxChars(pDX, m_addr2, 44);
	DDX_Text(pDX, IDC_DSCPAGE1, m_pinfo);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMyPropertyPage1, CPropertyPage)
	//{{AFX_MSG_MAP(CMyPropertyPage1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMyPropertyPage2 property page

CMyPropertyPage2::CMyPropertyPage2() : CPropertyPage(CMyPropertyPage2::IDD)
{
	//{{AFX_DATA_INIT(CMyPropertyPage2)
	m_adr1 = _T("");
	m_adr2 = _T("");
	m_cname = _T("");
	m_cntry = _T("");
	m_ename = _T("");
	m_pass = _T("");
	m_vpass = _T("");
	m_phone = _T("");
	m_pinfo = _T("");
	m_userid = _T("");
	//}}AFX_DATA_INIT
}

CMyPropertyPage2::~CMyPropertyPage2()
{
}

void CMyPropertyPage2::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMyPropertyPage2)
	DDX_Text(pDX, IDC_ADR1, m_adr1);
	DDV_MaxChars(pDX, m_adr1, 29);
	DDX_Text(pDX, IDC_ADR2, m_adr2);
	DDV_MaxChars(pDX, m_adr2, 29);
	DDX_Text(pDX, IDC_CNAME, m_cname);
	DDV_MaxChars(pDX, m_cname, 29);
	DDX_Text(pDX, IDC_CNTRY, m_cntry);
	DDV_MaxChars(pDX, m_cntry, 29);
	DDX_Text(pDX, IDC_ENAME, m_ename);
	DDV_MaxChars(pDX, m_ename, 29);
	DDX_Text(pDX, IDC_PASS, m_pass);
	DDV_MaxChars(pDX, m_pass, 9);
	DDX_Text(pDX, IDC_VPASS, m_vpass);
	DDV_MaxChars(pDX, m_vpass, 9);
	DDX_Text(pDX, IDC_PHONE, m_phone);
	DDV_MaxChars(pDX, m_phone, 15);
	DDX_Text(pDX, IDC_DSCPAGE2, m_pinfo);
	DDX_Text(pDX, IDC_USERID, m_userid);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMyPropertyPage2, CPropertyPage)
	//{{AFX_MSG_MAP(CMyPropertyPage2)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMyPropertyPage3 property page

CMyPropertyPage3::CMyPropertyPage3() : CPropertyPage(CMyPropertyPage3::IDD)
{
	//{{AFX_DATA_INIT(CMyPropertyPage3)
	m_oldacct = -1;
	m_pinfo = _T("");
	//}}AFX_DATA_INIT
}

CMyPropertyPage3::~CMyPropertyPage3()
{
}

void CMyPropertyPage3::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMyPropertyPage3)
	DDX_Radio(pDX, IDC_RADIO1, m_oldacct);
	DDX_Text(pDX, IDC_DSCPAGE3, m_pinfo);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMyPropertyPage3, CPropertyPage)
	//{{AFX_MSG_MAP(CMyPropertyPage3)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMyPropertyPage4 property page

CMyPropertyPage4::CMyPropertyPage4() : CPropertyPage(CMyPropertyPage4::IDD)
{
	//{{AFX_DATA_INIT(CMyPropertyPage4)
	m_notify = -1;
	m_eadrto = _T("");
	m_enotto = _T("");
	m_pinfo = _T("");
	m_unotify = -1;
	//}}AFX_DATA_INIT
}

CMyPropertyPage4::~CMyPropertyPage4()
{
}

void CMyPropertyPage4::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMyPropertyPage4)
	DDX_Radio(pDX, IDC_RADIO1, m_notify);
	DDX_Text(pDX, IDC_EADRTO, m_eadrto);
	DDV_MaxChars(pDX, m_eadrto, 29);
	DDX_Text(pDX, IDC_ENOTTO, m_enotto);
	DDV_MaxChars(pDX, m_enotto, 29);
	DDX_Text(pDX, IDC_DSCPAGE4, m_pinfo);
	DDX_Radio(pDX, IDC_RADIO3, m_unotify);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMyPropertyPage4, CPropertyPage)
	//{{AFX_MSG_MAP(CMyPropertyPage4)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyPropertyPage5 property page

CMyPropertyPage5::CMyPropertyPage5() : CPropertyPage(CMyPropertyPage5::IDD)
{
	//{{AFX_DATA_INIT(CMyPropertyPage5)
	m_modem = FALSE;
	m_inet = TRUE;
	m_pinfo = _T("");
	//}}AFX_DATA_INIT
}

CMyPropertyPage5::~CMyPropertyPage5()
{
}

void CMyPropertyPage5::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMyPropertyPage5)
	DDX_Control(pDX, IDC_CHECK2, m_inetbox);
	DDX_Control(pDX, IDC_CHECK1, m_modembox);
	DDX_Check(pDX, IDC_CHECK1, m_modem);
	DDX_Check(pDX, IDC_CHECK2, m_inet);
	DDX_Text(pDX, IDC_DSCPAGE5, m_pinfo);
	//}}AFX_DATA_MAP
}

BOOL CMyPropertyPage5::OnSetActive()
{
     INT retval;

	retval=CPropertyPage::OnSetActive();
     CPropertySheet* pSheet=STATIC_DOWNCAST(CPropertySheet, GetParent());
     if (m_inet == TRUE) {
          pSheet->SetWizardButtons(PSWIZB_NEXT|PSWIZB_BACK);
     }
     else {
          pSheet->SetWizardButtons(PSWIZB_BACK|PSWIZB_FINISH);
     }
     return(retval);
}

BEGIN_MESSAGE_MAP(CMyPropertyPage5, CPropertyPage)
	//{{AFX_MSG_MAP(CMyPropertyPage5)
	ON_BN_CLICKED(IDC_CHECK1, OnCheck1)
	ON_BN_CLICKED(IDC_CHECK2, OnCheck2)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMyPropertyPage6 property page

CMyPropertyPage6::CMyPropertyPage6() : CPropertyPage(CMyPropertyPage6::IDD)
{
	//{{AFX_DATA_INIT(CMyPropertyPage6)
	m_hstval=m_msghst;
	m_dnsval=m_msgdns;
	m_dmnval=m_msgdmn;
	m_ipval = _T("");
	//}}AFX_DATA_INIT
     m_tcpip=TRUE;
}

CMyPropertyPage6::~CMyPropertyPage6()
{
}

void CMyPropertyPage6::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMyPropertyPage6)
	DDX_Control(pDX, IDC_DSCPAGE6, m_upinfo);
	DDX_Control(pDX, IDC_DNSCOMBO, m_dnsadr);
	DDX_Control(pDX, IDC_DMNCOMBO, m_dmnnam);
	DDX_Control(pDX, IDC_HSTCOMBO, m_hstnam);
	DDX_Control(pDX, IDC_IPCOMBO, m_ipadr);
	DDX_CBString(pDX, IDC_HSTCOMBO, m_hstval);
	DDV_MaxChars(pDX, m_hstval, 18);
	DDX_CBString(pDX, IDC_DNSCOMBO, m_dnsval);
	DDV_MaxChars(pDX, m_dnsval, 15);
	DDX_CBString(pDX, IDC_DMNCOMBO, m_dmnval);
	DDV_MaxChars(pDX, m_dmnval, 27);
	DDX_CBString(pDX, IDC_IPCOMBO, m_ipval);
	DDV_MaxChars(pDX, m_ipval, 15);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMyPropertyPage6, CPropertyPage)
	//{{AFX_MSG_MAP(CMyPropertyPage6)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CMyPropertyPage6::OnSetActive() 
{
     static BOOL once=TRUE;
     INT retval;
     CString tmpstr;

     retval=CPropertyPage::OnSetActive();
     if (once) {
          once=FALSE;
          m_ipadr.ResetContent();
          m_dnsadr.ResetContent();
          m_hstnam.ResetContent();
          m_dmnnam.ResetContent();
          if (findWin32IPAddr() == -1) {
               tmpstr.FormatMessage(IDS_TINFO6A,SVR_NAME);
               m_tcpip=FALSE;
          }
          else {
               //tmpstr.LoadString(IDS_TINFO6);
               tmpstr.FormatMessage(IDS_TINFO6,SVR_NAME);
          }
          m_upinfo.SetWindowText((LPCTSTR)tmpstr);
          readDNSSet();
     }
     CPropertySheet* pSheet=STATIC_DOWNCAST(CPropertySheet, GetParent());
     pSheet->SetWizardButtons(PSWIZB_BACK|PSWIZB_FINISH);
     return(retval); 
}

INT CMyPropertyPage6::findWin32IPAddr()
{
     INT i;
     INT pos;
     BOOL first=TRUE;
     CHAR hostName[256];
     CHAR tmpbuf[128];
     WORD verRequested;
     WSADATA wsaData;
     HOSTENT *pHostEnt;

     verRequested=MAKEWORD(1,1);
     if (WSAStartup(verRequested,&wsaData) == 0) {
          if (gethostname(hostName,sizeof(hostName)) == SOCKET_ERROR
          || (pHostEnt=gethostbyname(hostName)) == NULL) {
               //catastro("gethostxxx() failed. Unable to get IP address.\n"
                    //"Use CONTROL PANEL/NETWORK to install TCP/IP support");
               return(-1);
          }
          for (i=0 ; pHostEnt->h_addr_list[i] != NULL; i++) {
               sprintf(tmpbuf,"%u.%u.%u.%u",
                    (UCHAR)(pHostEnt->h_addr_list[i][0]&0xFF),
                    (UCHAR)(pHostEnt->h_addr_list[i][1]&0xFF),
                    (UCHAR)(pHostEnt->h_addr_list[i][2]&0xFF),
                    (UCHAR)(pHostEnt->h_addr_list[i][3]&0xFF));
               if (!sameas((CHAR *)(LPCTSTR)(m_msgip),tmpbuf)) {
                    if (first) {
                         first=FALSE;
                         pos=m_ipadr.AddString((const CHAR *)tmpbuf);
                    }
                    else {
                         m_ipadr.AddString((const CHAR *)tmpbuf);
                    }
               }
          }
          if ((m_msgip.GetLength() > 0) && !sameas(m_msgip,"AUTO")) {
               pos=m_ipadr.AddString((LPCTSTR)m_msgip);
          }
          if (m_ipadr.GetCount() == 1) {
               if (m_ipadr.FindString(-1,"AUTO") == CB_ERR) {
                    m_ipadr.AddString("AUTO");
               }
          }
          if (i == 0) {
               WSACleanup();
               return(-1);
          }
          else {
               if (pos >= 0) {
                    m_ipadr.SetCurSel(pos);
               }
          }
          WSACleanup();
     }
     return(pos);
}

VOID CMyPropertyPage6::readDNSSet()
{
     INT select;
     HKEY hKey;
     BOOL first=TRUE;
     DWORD vType;
     DWORD vSize;
     UCHAR tmpbuf[1024];
     UCHAR *pStart;
     UCHAR *pTmp;
     const CHAR *keyNameNT="SYSTEM\\CurrentControlSet\\Services\\Tcpip\\Parameters";
     const CHAR *keyNameWin95="SYSTEM\\CurrentControlSet\\Services\\VxD\\MSTCP";
     const CHAR *keyName;

     if (isWinNT()) {
          keyName=keyNameNT;
     }
     else {
          keyName=keyNameWin95;
     }
     if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,keyName,0,KEY_QUERY_VALUE,&hKey)
                                                            != ERROR_SUCCESS) {
          //catastro("Unable to locate Registry entry for TCP/IP.\n"
          //     "Use CONTROL PANEL/NETWORK to install TCP/IP support");
     }
     vSize=sizeof(tmpbuf);
     if (RegQueryValueEx(hKey,"Hostname",NULL,&vType,tmpbuf,&vSize) == ERROR_SUCCESS) {
          if (vSize > 1) {
               select=-1;
               if (!sameas((LPCTSTR)(m_msghst),(const CHAR *)tmpbuf)) {
                    select=m_hstnam.AddString((const CHAR *)tmpbuf);
               }
               if (m_msghst.GetLength() > 0) {
                    select=m_hstnam.AddString((LPCTSTR)m_msghst);
               }             
               m_hstnam.SetCurSel(select);
               vSize=sizeof(tmpbuf);
          }
     }
     if (RegQueryValueEx(hKey,"Domain",NULL,&vType,tmpbuf,&vSize) == ERROR_SUCCESS) {
          if (vSize > 1) {
               select=-1;
               if (!sameas((LPCTSTR)(m_msgdmn),(const CHAR *)tmpbuf)) {
                    select=m_dmnnam.AddString((const CHAR *)tmpbuf);
               }
               if (m_msgdmn.GetLength() > 0) {
                    select=m_dmnnam.AddString((LPCTSTR)m_msgdmn);
               }             
               m_dmnnam.SetCurSel(select);
               vSize=sizeof(tmpbuf);
          }
     }
     if (RegQueryValueEx(hKey,"NameServer",NULL,&vType,tmpbuf,&vSize)== ERROR_SUCCESS) {
          if (vSize > 1) {
               select=-1;
               pStart=pTmp=tmpbuf;
               while (*pTmp != '\0') {
                    while ((*pTmp != '\0') && (*pTmp != ' ') && (*pTmp !=',')) {
                         pTmp++;
                    }
                    if ((*pTmp == ' ') || (*pTmp == ',')) {
                         *pTmp='\0';
                         if (!sameas((LPCTSTR)(m_msgdns),(const CHAR *)pStart)) {
                              if (first) {
                                   first=FALSE;
                                   m_dnsadr.AddString((const CHAR *)pStart);
                              }    
                              else {
                                   m_dnsadr.AddString((const CHAR *)pStart);
                              }
                         }
                         pStart=++pTmp;
                    }
                    else if ((*pTmp == '\0') && (pStart != pTmp) 
                         && !sameas((LPCTSTR)(m_msgdns),(const CHAR *)pStart) ) {
                         if (first) {
                              m_dnsadr.AddString((const CHAR *)pStart);
                         }
                         else {
                              m_dnsadr.AddString((const CHAR *)pStart);
                         }
                    }
               }
               if (m_msgdns.GetLength() > 0) {
                    select=m_dnsadr.AddString((LPCTSTR)m_msgdns);                  
               }
               else {
                    select=0;
               }
               if (m_dnsadr.FindStringExact(-1,"NONE") == CB_ERR) {
                    m_dnsadr.AddString("NONE");
               }
               m_dnsadr.SetCurSel(select);
          }
     }
     RegCloseKey(hKey);
}

BOOL CMyPropertyPage1::OnSetActive() 
{
     INT retval;

	retval=CPropertyPage::OnSetActive();
     CPropertySheet* pSheet=STATIC_DOWNCAST(CPropertySheet, GetParent());
     pSheet->SetWizardButtons(PSWIZB_NEXT);
     return(retval);
}

BOOL CMyPropertyPage2::OnSetActive() 
{
     INT retval;

	retval=CPropertyPage::OnSetActive();
     CPropertySheet* pSheet=STATIC_DOWNCAST(CPropertySheet, GetParent());
     pSheet->SetWizardButtons(PSWIZB_NEXT|PSWIZB_BACK);
     return(retval);
}

BOOL CMyPropertyPage3::OnSetActive() 
{
     INT retval;

	retval=CPropertyPage::OnSetActive();
     CPropertySheet* pSheet=STATIC_DOWNCAST(CPropertySheet, GetParent());
     pSheet->SetWizardButtons(PSWIZB_NEXT|PSWIZB_BACK);
     return(retval);
}

BOOL CMyPropertyPage4::OnSetActive() 
{
     INT retval;

	retval=CPropertyPage::OnSetActive();
     CPropertySheet* pSheet=STATIC_DOWNCAST(CPropertySheet, GetParent());
     pSheet->SetWizardButtons(PSWIZB_NEXT|PSWIZB_BACK);
     return(retval);
}

BOOL CMyPropertyPage6::OnWizardFinish() 
{
	INT index;
     
	UpdateData();
	if (sameas((LPCTSTR)m_ipval,"AUTO")) {
		m_ipval="AUTO";
	}
	else {
	if (!ValidIP((LPCTSTR)m_ipval)) {
		CString tmp;
		tmp.LoadString(IDS_ERRORIP);
		::MessageBox(this->GetSafeHwnd(),(LPCTSTR)tmp,WIZARD_CAPTION,MB_ICONEXCLAMATION|MB_OK
					 |MB_APPLMODAL);
		return(FALSE);
	}
	}
	if ((index=m_ipadr.GetCurSel()) >= 0) {
		m_ipadr.GetLBText(index,m_msgip);
	}
	if ((index=m_dnsadr.GetCurSel()) >= 0) {
		m_dnsadr.GetLBText(index,m_msgdns);
	}
	else {
		m_msgdns=m_dnsval;
	}
	if ((index=m_hstnam.GetCurSel()) >= 0) {
		m_hstnam.GetLBText(index,m_msghst);
	}
	else {
		m_msghst=m_hstval;
	}
	if ((index=m_dmnnam.GetCurSel()) >= 0) {
		m_dmnnam.GetLBText(index,m_msgdmn);
	}
	else {
		m_msgdmn=m_dmnval;
	}
	m_newaddr=m_msghst+"."+m_msgdmn;
	if ((m_tcpip == TRUE) && (m_newaddr.GetLength() > 1)) {
		CDialog   infDlg;

		infDlg.Create(IDD_WEBINF);
		infDlg.ShowWindow(SW_SHOWNORMAL);
		MsgLoop();
		movedir(STR_DOMAIN,(LPCTSTR)(m_newaddr),DIR_NEWPAGES,(LPCTSTR)strWebDirectory);
		infDlg.DestroyWindow();
	}
	else {
		finishmove();
	}
	return CPropertyPage::OnWizardFinish();
}

VOID
finishmove(
VOID)
{
     CDialog   infDlg;

     infDlg.Create(IDD_WEBINF);
     infDlg.ShowWindow(SW_SHOWNORMAL);
	 MsgLoop();
     movedir("","",DIR_NEWPAGES,(LPCTSTR)strWebDirectory);
     infDlg.DestroyWindow();
}

VOID
moveweb(                           //   move web pages from NEWPAGES
const CHAR *oldaddr,               // old web address to replace
const CHAR *newaddr,               // new web address to replace with
const CHAR* fromdir,               // directory to start moving from
const CHAR* todir)                 // directory to start moving to
{
     CHAR*     pszFilespec1=new CHAR [GCMAXPTH];
     CHAR*     pszFilespec2=new CHAR [GCMAXPTH];
     Cffblk*   fbDirectory=new Cffblk;
     CHAR*     retval;
     BOOL      bOverWrite=FALSE;

     if (samein(DIR_NEWPAGES SLS DIR_CLASSES,fromdir) 
		 || samein(DIR_NEWPAGES SLS DIR_HELP,fromdir)) {
          bOverWrite=TRUE;
     }
     sprintf(pszFilespec1,"%s" SLS "*.*",fromdir);
     if (fnd1st(fbDirectory,pszFilespec1,0)) {
          do {
               sprintf(pszFilespec1,"%s" SLS "%s",todir,fbDirectory->ff_name);
               if ((access(pszFilespec1,0) == -1) || (bOverWrite == TRUE)
				   || samend(pszFilespec1,".OCX")) {
                    sprintf(pszFilespec1,"%s" SLS "%s",fromdir,fbDirectory->ff_name);
                    sprintf(pszFilespec2,"%s" SLS "%s",todir,fbDirectory->ff_name);
                    if (samend(fbDirectory->ff_name,EXT_HTML)) {
                         retval=changestr(pszFilespec1,pszFilespec2,oldaddr,newaddr);
                         if (retval != NULL) {
                              catastro("moveweb(): %s",retval);
                         }
                    }
                    else {
                         cpyutl(pszFilespec1,pszFilespec2,FOPRB,FOPWB);
                    }
                    unlink(pszFilespec1);
               }
			   MsgLoop();
          } while (fndnxt(fbDirectory));
     }

     delete fbDirectory;
     delete [] pszFilespec2;
     delete [] pszFilespec1;
}

VOID
movedir(
const CHAR *oldaddr,               // old web address to replace
const CHAR *newaddr,               // new web address to replace with
const CHAR* fromdir,               // directory to start moving from
const CHAR* todir)                 // directory to start moving to
{
     CHAR* chTempPath;
     CHAR* chFromPath;
     CHAR* chToPath;
     Cffblk* fbSearch;
     Cffblk* fbCheck;
     static INT iLevel=0;

     chTempPath=new CHAR [GCMAXPTH];
     chFromPath=new CHAR [GCMAXPTH];
     chToPath=new CHAR [GCMAXPTH];

     fbSearch=new Cffblk;
     fbCheck=new Cffblk;

     sprintf(chTempPath,"%s" SLS "*.*",fromdir);
     if (fnd1st(fbSearch,chTempPath,FAMDIR)) {
          do {
               MsgLoop();
			   if (((fbSearch->ff_attrib&FAMDIR) == FAMDIR) &&
                   (!sameas(fbSearch->ff_name,".")) && (!sameas(fbSearch->ff_name,".." ))) {
                    sprintf(chFromPath,"%s" SLS "%s",fromdir,fbSearch->ff_name);
                    sprintf(chToPath,"%s" SLS "%s",todir,fbSearch->ff_name);
                    GBOOL bMoveFiles=FALSE;
                    if (!isdir(chToPath)) {
                         if (!isfile(chToPath)) {
                              gmkdir(chToPath);
                              bMoveFiles=TRUE;
                         }
                         else {
                              CDlgCft* dlg=new CDlgCft;
                              dlg->SetPath(chToPath);
                              if (dlg->DoModal() == IDOK) {
                                   webunlink(chToPath);
                                   gmkdir(chToPath);
                                   bMoveFiles=TRUE;
                              }
                              delete dlg;                              
                         }
                    }
                    else {
                         bMoveFiles=TRUE;
                    }
                    if (bMoveFiles) {
                         moveweb(oldaddr,newaddr,chFromPath,chToPath);
                         movedir(oldaddr,newaddr,chFromPath,chToPath);
                    }
			   }
          } while (fndnxt(fbSearch));
          moveweb(oldaddr,newaddr,fromdir,todir);
     }

     delete fbCheck;
     delete fbSearch;

     delete [] chToPath;
     delete [] chFromPath;
     delete [] chTempPath;     
}

CHAR *                             //   return error message or NULL       
changestr(                         // substitute new zstgs for old in file 
CHAR *filein,                      //   filespec of input file             
CHAR *fileout,                     //   filespec of output file            
const CHAR *tobechgd,            //   array of zstrings to be changed    
const CHAR *chgemto)             //   array of zstrings to change 'em to 
{
     FILE *ifp,*ofp;
     INT i,j,c,endfile;
     static CHAR cbuf[256];

     if ((ifp=fopen(filein,FOPRB)) == NULL) {
          sprintf(cbuf,"Can't open \"%s\" for input!",filein);
          return(cbuf);
     }
     if ((ofp=fopen(fileout,FOPWB)) == NULL) {
          fclose(ifp);
          sprintf(cbuf,"Can't open \"%s\" for output!",fileout);
          return(cbuf);
     }
     endfile=0;
     for (i=0 ; i < CHGSIZ ; i++) {
          if ((c=fgetc(ifp)) == EOF) {
               endfile+=1;
          }
          cbuf[i]=c;
     }
     while (endfile < CHGSIZ) {
          if (memicmp(cbuf,tobechgd,strlen(tobechgd)) == 0) {
               for (j=0 ; j < strlen(chgemto) ; j++) {
                    fputc(chgemto[j],ofp);
               }
               for (j=0 ; j < strlen(tobechgd) ; j++) {
                    memmove(cbuf,cbuf+1,CHGSIZ-1);
                    if ((c=fgetc(ifp)) == EOF) {
                         endfile++;
                    }
                    cbuf[CHGSIZ-1]=c;
               }
          }
          fputc(cbuf[0],ofp);
          memmove(cbuf,cbuf+1,CHGSIZ-1);
          if ((c=fgetc(ifp)) == EOF) {
               endfile++;
          }
          cbuf[CHGSIZ-1]=c;
     }
     fclose(ifp);
     fclose(ofp);
	 setFileGMT(fileout,getFileGMT(filein));
     return(NULL);
}

LRESULT CMyPropertyPage2::OnWizardNext() 
{
     UpdateData();
	if (sameas(FLD_SYSOP,(CHAR *)(LPCTSTR)(m_pass))) {
          CString tmp;
          tmp.LoadString(IDS_ERROR1);
          ::MessageBox(this->GetSafeHwnd(),(LPCTSTR)tmp,WIZARD_CAPTION,MB_ICONEXCLAMATION|MB_OK
               |MB_APPLMODAL);
          return(-1);
     }
     else if (m_pass != m_vpass) {
          CString tmp;
          tmp.LoadString(IDS_ERROR2);
          ::MessageBox(this->GetSafeHwnd(),(LPCTSTR)tmp,WIZARD_CAPTION,MB_ICONEXCLAMATION|MB_OK
               |MB_APPLMODAL);
          return(-1);
     }	
	return CPropertyPage::OnWizardNext();
}

void CMyPropertyPage5::OnCheck1() 
{
     UpdateData();
}

void CMyPropertyPage5::OnCheck2() 
{
     UpdateData();
     CPropertySheet* pSheet=STATIC_DOWNCAST(CPropertySheet, GetParent());
     if (m_inet == TRUE) {
          pSheet->SetWizardButtons(PSWIZB_NEXT|PSWIZB_BACK);
     }
     else {
          pSheet->SetWizardButtons(PSWIZB_BACK|PSWIZB_FINISH);
     }
}

LRESULT CMyPropertyPage5::OnWizardNext() 
{
	if (m_modem == TRUE) {
          CString tmp;
          tmp.FormatMessage(IDS_MBOX2,SVR_NAME);
          ::MessageBox(this->GetSafeHwnd(),(LPCTSTR)tmp,WIZARD_CAPTION,MB_ICONINFORMATION|MB_OK
               |MB_APPLMODAL);
     }
	return CPropertyPage::OnWizardNext();
}

BOOL CMyPropertyPage5::OnWizardFinish() 
{
	if (m_modem == TRUE) {
          CString tmp;
          tmp.FormatMessage(IDS_MBOX2,SVR_NAME);
          ::MessageBox(this->GetSafeHwnd(),(LPCTSTR)tmp,WIZARD_CAPTION,MB_ICONINFORMATION|MB_OK
               |MB_APPLMODAL);
     }
     else { 
          if (m_inet == FALSE) {
               CString tmp;
               tmp.FormatMessage(IDS_MBOX1,SVR_NAME);
               ::MessageBox(this->GetSafeHwnd(),(LPCTSTR)tmp,WIZARD_CAPTION,MB_ICONINFORMATION
                    |MB_OK|MB_APPLMODAL);
          }
     }
	return CPropertyPage::OnWizardFinish();
}

BOOL CMyPropertyPage1::OnQueryCancel() 
{
	if(!canCancel()) {
          CString tmp;
          tmp.FormatMessage(IDS_MUSTFINISH,SVR_NAME);
          ::MessageBox(this->GetSafeHwnd(),(LPCTSTR)tmp,WIZARD_CAPTION,MB_ICONEXCLAMATION|MB_OK
               |MB_APPLMODAL);
          return(FALSE);
     }
     finishmove();
	return CPropertyPage::OnQueryCancel();
}

BOOL CMyPropertyPage2::OnQueryCancel() 
{
	if(!canCancel()) {
          CString tmp;
          tmp.FormatMessage(IDS_MUSTFINISH,SVR_NAME);
          ::MessageBox(this->GetSafeHwnd(),(LPCTSTR)tmp,WIZARD_CAPTION,MB_ICONEXCLAMATION|MB_OK
               |MB_APPLMODAL);
          return(FALSE);
     }	
     finishmove();
	return CPropertyPage::OnQueryCancel();
}

BOOL CMyPropertyPage3::OnQueryCancel() 
{
	if(!canCancel()) {
          CString tmp;
          tmp.FormatMessage(IDS_MUSTFINISH,SVR_NAME);
          ::MessageBox(this->GetSafeHwnd(),(LPCTSTR)tmp,WIZARD_CAPTION,MB_ICONEXCLAMATION|MB_OK
               |MB_APPLMODAL);
          return(FALSE);
     }
     finishmove();
	return CPropertyPage::OnQueryCancel();
}

BOOL CMyPropertyPage4::OnQueryCancel() 
{
	if(!canCancel()) {
          CString tmp;
          tmp.FormatMessage(IDS_MUSTFINISH,SVR_NAME);
          ::MessageBox(this->GetSafeHwnd(),(LPCTSTR)tmp,WIZARD_CAPTION,MB_ICONEXCLAMATION|MB_OK
               |MB_APPLMODAL);
          return(FALSE);
     }
     finishmove();
	return CPropertyPage::OnQueryCancel();
}

BOOL CMyPropertyPage5::OnQueryCancel() 
{
	if(!canCancel()) {
          CString tmp;
          tmp.FormatMessage(IDS_MUSTFINISH,SVR_NAME);
          ::MessageBox(this->GetSafeHwnd(),(LPCTSTR)tmp,WIZARD_CAPTION,MB_ICONEXCLAMATION|MB_OK
               |MB_APPLMODAL);
          return(FALSE);
     }
     finishmove();
	return CPropertyPage::OnQueryCancel();
}

BOOL CMyPropertyPage6::OnQueryCancel() 
{
	if(!canCancel()) {
          CString tmp;
          tmp.FormatMessage(IDS_MUSTFINISH,SVR_NAME);
          ::MessageBox(this->GetSafeHwnd(),(LPCTSTR)tmp,WIZARD_CAPTION,MB_ICONEXCLAMATION|MB_OK
               |MB_APPLMODAL);
          return(FALSE);
     }	
     finishmove();
	return CPropertyPage::OnQueryCancel();
}

BOOL CMyPropertyPage6::ValidIP(const char *ipval)
{
     INT i;
     INT j;
     INT len;
     CHAR *ptr;
     CHAR *secptr;
     CHAR savadr[16];

     stlcpy(savadr,ipval,16);
     for (i=0,ptr=savadr ; ptr != NULL ; i++,ptr=secptr) {
          if ((secptr=strchr(ptr,'.')) != NULL) {
               *secptr++='\0';
          }
          if ((len=strlen(ptr)) > 3 || len == 0) {
               return(FALSE);
          }
          for (j=0 ; j < len ; j++) {
               if (!isdigit(ptr[j])) {
                    return(FALSE);
               }
          }
          if (atoi(ptr) > 255) {
               return(FALSE);
          }
     }
     if (i == 4) {
          return(TRUE);
     }
     return(FALSE);
}

BOOL CMyPropertyPage3::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
#ifdef WEBCAST
     WINDOWPLACEMENT wstart;
     WINDOWPLACEMENT wend;
     GetDlgItem(IDC_RADIO2)->ShowWindow(SW_HIDE);
     GetDlgItem(IDC_RADIO3)->ShowWindow(SW_HIDE);
     GetDlgItem(IDC_RADIO4)->ShowWindow(SW_HIDE);
     GetDlgItem(IDC_RADIO2)->GetWindowPlacement(&wstart);
     GetDlgItem(IDC_RADIO5)->GetWindowPlacement(&wend);     
     wend.rcNormalPosition=wstart.rcNormalPosition;
     GetDlgItem(IDC_RADIO5)->SetWindowPlacement(&wend);     
#endif // WEBCAST	
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

VOID
webunlink(
const CHAR *fname)
{
     Cffblk fblk;

     if (fnd1st(&fblk,fname,0)) {
          if (fblk.ff_attrib&FAMRON) {
               chmod(fname,_S_IWRITE);
          }
          unlink(fname);
     }
}

VOID
MsgLoop(VOID)
{
	MSG       msg;
	while (::PeekMessage(&msg,NULL,0,0,PM_REMOVE)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
}