#include  "stdafx.h"
#include  "resource.h"
#include  "cli.h"
#include  "cmaps.h"
#include  "WgscmapsDlg.h"


CommandLineInfo::CommandLineInfo() : CCommandLineInfo()
{
     m_justQuit = FALSE;
}


void CommandLineInfo::ParseParam( LPCTSTR lpszParam, BOOL bFlag, BOOL bLast )
{
     if (bFlag)
     {
          char      cmdChar = tolower( lpszParam[ 0 ] );

          switch( cmdChar )
          {
               case 'q':
                    quiet = TRUE;
                    break;

               case '?':
                    dsphlp();
                    m_justQuit = TRUE;
                    break;

               case 'm':
                    AddLocalFiles();
                    break;

               case 'h':
                    AddHypermediaFiles();
                    break;

               case 'n':
                    if (stricmp( lpszParam, "nohide" ) == 0)
                    {
                         dontHide = TRUE;
                         break;
                    }
                    break;

               default:
                    //   invalid flag
                    m_justQuit = TRUE;
                    break;
          }
     }
     else
     {
          AddFile( lpszParam );
     }
}


BOOL CommandLineInfo::JustQuit()
{
     return( m_justQuit );
}
