////////////////////////////////////////////////////////////////////////////
//
//  THREADSHELL.H
//
//  Run a console app as a detached, hidden process
//
//                                                  - Paul Roub  09/09/96
//
/////////////////////////////////////////////////////////////////////////////

#if ! defined (THREADSHELL_H)
#  define THREADSHELL_H

class ThreadShell
{
public:
     ThreadShell();
    ~ThreadShell();

     BOOL                          //   TRUE if app started OK
     StartApp(                     // begin running a detached app
     const CString &cmdStr,        //   command line for app (incl. params)
     BOOL minimize,                //   run minimized and hidden?
     const char *title = NULL);    //   window title (if not in use)

     BOOL                          //   TRUE if done or no app running
     Complete();                   // check whether an app has completed

     CString                       //   description of last error detected
     Error();                      // get description of the last error

     BOOL                          //   TRUE if app canceled OK
     Cancel();                     // cancel the currently shelled app

     void
     KillConsole();                // kill the console window - shouldn't have to call this

     void
     WaitForCompletion();          // block until the current app completes

private:
     CString GetTempName();
     BOOL CreateBatchFile( const CString &cmdLine, CString &batName );
     CWnd *FindWindow( const char *st, DWORD maxMs = 1000 );

     BOOL m_consoleCreated;        // TRUE if we already have a console
     CString batName;              // current batch file name
     CString error;                // last error          
     HANDLE processHand;           // current process handle
     HANDLE threadHand;            // current process thread handle
     CString m_title;              // current console window title
};

#endif
     