/***************************************************************************
 *                                                                         *
 *   KEYAPI.CPP                                                            *
 *                                                                         *
 *   Copyright (c) 1996 Galacticomm, Inc.      All Rights Reserved.        *
 *                                                                         *
 *   Registry key semaphores API for GCOMMLIB.                             *
 *                                                                         *
 *                                           - Joe Delekto 8/20/96         *
 *                                                                         *
 ***************************************************************************/

#include "gcommlib.h"

GBOOL                              // returns TRUE if key exists, FALSE if does not
regKeyExist(                       //   check for existance of keyname
const CHAR *keyname)               // key name to look up in the registry
{
     HKEY hKey;
     CHAR tmpKey[KEYPTH_SIZE];

     sprintf(tmpKey,"%s%s",KEY_API_ROOT_KEY,keyname);
     if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,tmpKey,0,KEY_ALL_ACCESS,&hKey) == ERROR_SUCCESS) {
          RegCloseKey(hKey);
          return(TRUE);
     }
     return(FALSE);
}

GBOOL                              // returns TRUE if key set properly
regKeySet(                         //   create a registry key and set its value
const CHAR *keyname,               // keyname to add/change in the registry
const CHAR *keyval)                // value to store in the registry (string)
{
     HKEY hKey;
     DWORD disp;
     GBOOL done;
     CHAR tmpKey[KEYPTH_SIZE];
     
     sprintf(tmpKey,"%s%s",KEY_API_ROOT_KEY,keyname);
     if (RegCreateKeyEx(HKEY_LOCAL_MACHINE,tmpKey,0,"",REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
          NULL,&hKey,&disp) == ERROR_SUCCESS) {
          done=FALSE;
          if (RegSetValueEx(hKey,NULL,0,REG_SZ,(CONST BYTE *)keyval,strlen(keyval)+1)
               == ERROR_SUCCESS) {
               done=TRUE;
          }
          RegCloseKey(hKey);
          return(done);
     }
     return(FALSE);
}

GBOOL                              // returns TRUE if operation completed successfully
regKeyDelete(                      //   delete a key that may be in the registry
const CHAR *keyname)               // keyname to delete
{
     CHAR tmpKey[KEYPTH_SIZE];

     sprintf(tmpKey,"%s%s",KEY_API_ROOT_KEY,keyname);
     if (RegDeleteKey(HKEY_LOCAL_MACHINE,tmpKey) == ERROR_SUCCESS) {
          return(TRUE);
     }
     return(FALSE);
}

CHAR *                             // returns pointer to passed buffer or NULL
regKeyValue(                       //   retrieve the value from a registry key
const CHAR *keyname,               // keyname to retrieve value from
CHAR *keyval,                      // buffer to hold the value
DWORD length)                      // maximum length of value to get
{
     HKEY hKey;
     DWORD keyType;
     DWORD keySize;
     CHAR *retval;
     CHAR tmpKey[KEYPTH_SIZE];
     CHAR valBuf[KEYVAL_SIZE];

     retval=(CHAR *)NULL;
     sprintf(tmpKey,"%s%s",KEY_API_ROOT_KEY,keyname);
     if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,tmpKey,0,KEY_ALL_ACCESS,&hKey) == ERROR_SUCCESS) {
          keySize=KEYVAL_SIZE;
          if (RegQueryValueEx(hKey,NULL,NULL,&keyType,(BYTE *)valBuf,&keySize)
               == ERROR_SUCCESS) {
               if (keyType == REG_SZ) {
                    if (length < keySize) {
                         keySize=length;
                    }
                    stlcpy(keyval,(const CHAR *)valBuf,keySize);
                    retval=keyval;
               }
          }
          RegCloseKey(hKey);
     }
     return(retval);    
}