/***************************************************************************
 *                                                                         *
 *   AUDONL.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Utilities that require online context for managing Galacticomm-style  *
 *   audit trail files.                                                    *
 *                                                                         *
 *                                           - J. Alvrus    10/06/1997     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "remote.h"

#define FILREV "$Revision: 1 $"

INT                                /*   returns result code                */
audfAddEntry(                      /* add an entry to audit trail file     */
HAUDFILE haud,                     /*   audit trail file to use            */
const CHAR *brief,                 /*   brief description                  */
const CHAR *detail,                /*   detailed description/format string */
...)                               /*   arguments to be formatted          */
{
     va_list ap;
     INT rc;

     ASSERT(haud != NULL);
     ASSERT(brief != NULL);
     ASSERT(detail != NULL);
     va_start(ap,detail);
     rc=audfVAddEntry(haud,brief,detail,ap);
     va_end(ap);
     return(rc);
}

INT                                /*   returns result code                */
audfVAddEntry(                     /* add entry with variable argument list*/
HAUDFILE haud,                     /*   audit trail file to use            */
const CHAR *brief,                 /*   brief description                  */
const CHAR *detail,                /*   detailed description/format string */
va_list argList)                   /*   argument list                      */
{
     struct audEntry buf;
     CHAR chanStr[AUDCHANSIZ];

     audfChannelStr(chanStr,AUDCHANSIZ);
     audfFormatEntry(&buf,sizeof(buf),brief,chanStr,detail,argList);
     return(audfAddLowLevel(haud,&buf,sizeof(buf)));
}

CHAR *                             /*   returns pointer to buffer          */
audfChannelStr(                    /* generate channel description string  */
CHAR *buf,                         /*   buffer (must be AUDCHANSIZ long)   */
size_t bufSiz)                     /*   size of buffer                     */
                                   /*   (implicit inputs: usrnum, nterms,  */
{                                  /*    channel[], errcod)                */
     CHAR tmpBuf[AUDCHANSIZ];

     switch (usrnum) {
     case AUDCHAN_EVENT:
          sprintf(tmpBuf,"Event %1.1d",errcod-10);
          break;
     case AUDCHAN_CLEANUP:
          strcpy(tmpBuf,"Cleanup");
          break;
     case AUDCHAN_CONSOLE:
          strcpy(tmpBuf,"Console");
          break;
     default:
          if (usrnum >= 0 && usrnum < nterms) {
               sprintf(tmpBuf,"Chan %02X",channel[usrnum]);
          }
          else {
               sprintf(tmpBuf,"U# %04X",usrnum);
          }
          break;
     }
     return(stlcpy(buf,tmpBuf,bufSiz));
}
