/***************************************************************************
 *                                                                         *
 *   ALCBLOK.C                                                             *
 *                                                                         *
 *   Copyright(c) 1996 Galacticomm, Inc.  All Rights Reserved.             *
 *                                                                         *
 *   This is the GCOMM.LIB routine for allocating memory as an array       *       
 *   of structures, where the aggregate is bigger than 64K.                *
 *                                                                         *
 *   alcblok() and ptrblok() have been re-architected as cover functions   *
 *   for utilities ported to MSVC that still wish to use them              *
 *                                                                         *
 *                                 - Joe Delekto  7/24/97                  *
 *                                                                         *
 ***************************************************************************/

#include "gcommlib.h"

VOID *                             //   returns ptr to allocated block
alcblok(                           // allocate over 64K blocked memory rgn
USHORT qty,                        //   number of blocks
USHORT size)                       //   size of each block
{
     VOID *retptr;

     retptr=alczer(((ULONG)qty*size)+sizeof(USHORT *));
     *((USHORT *)retptr)=size;
     return(retptr);
}

VOID
freblok(                           // free region allocated with alcblok()
VOID *bigptr)                      //   alcblok() return value
{
     free(bigptr);
}

VOID *                             //   returns ptr to requested element
ptrblok(                           // get address of a blok in blocked rgn
VOID *bigptr,                      //   alcblok() return value
USHORT idx)                        //   index of the blok, 0..qty-1
{
     USHORT size;

     size=*(USHORT *)bigptr;
     return((VOID *)(((CHAR *)bigptr+sizeof(USHORT *))+size*idx));
}