/***************************************************************************
 *                                                                         *
 *   WCMATCH.C                                                             *
 *                                                                         *
 *   Copyright (c) 1995-1997 Galacticomm, Inc.     All Rights Reserved.    *
 *                                                                         *
 *   This is the function to perform wildcard matches.  It's like a        *
 *   sameas() that supports wildcards in the second argument.              *
 *                                                                         *
 *                                            - C. Robert   12/14/95       *
 *                                              T. Stryker                 *
 *                                              S. Thomas                  *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

#define cmtch(c,pc) ((pc) == '?' || (tolower(c) == tolower(pc)))

GBOOL
wcmatch(                           /* wild-card match input against picstg */
CHAR *inpstr,                      /*   candidate literal string           */
CHAR *picstg)                      /*   picture (wild-card) string         */
{
     CHAR c,pc;
     CHAR *lanypc,*lanyin;

     lanypc=NULL;
     while ((c=*inpstr++) != '\0') {
          if ((pc=*picstg++) == '*') {
               while ((pc=*picstg) == '*') {
                    picstg++;
               }
               while (!cmtch(c,pc)) {
                    if (c == '\0') {
                         return(FALSE);
                    }
                    c=*inpstr++;
               }
               lanypc=picstg-1;
               lanyin=inpstr;
               inpstr--;
          }
          else {
               if (!cmtch(c,pc)) {
                    if (lanypc != NULL) {
                         picstg=lanypc;
                         inpstr=lanyin;
                    }
                    else {
                         return(FALSE);
                    }
               }
          }
     }
     while (*picstg == '*') {
          picstg++;
     }
     return(*picstg == '\0');
}
