/***************************************************************************
 *                                                                         *
 *   USRACC.H                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the user account/billing header file.                         *
 *                                                                         *
 *                                            - T. Stryker 6/24/86         *
 *                                                                         *
 ***************************************************************************/

#ifndef __USRACC_H
#define __USRACC_H

#define UIDSIZ 30             // user-id size (including trailing zero)    
#define PSWSIZ 10             // password size (ditto)                     
#define NADSIZ 30             // name/address line size (ditto)            
#define PHOSIZ 16             // phone number field size (ditto)           
#define KEYSIZ 16             // key (and class) name size (ditto)         
#define XRFSIZ 15             // maximum size for uid cross ref strings    
#define XMSGSZ 640            // size for class exit messages              
#define AXSSIZ 7              // number of ints for "access" info          
#define DATSIZ 9              // size of a date in xx/xx/xx format         
                              // HACK THIS NUMBER DIFFERS FROM DOS DO WHAT?

struct usracc {
     CHAR userid[UIDSIZ];     // user-id                                   
     CHAR psword[PSWSIZ];     // password                                  
     CHAR usrnam[NADSIZ];     // user name                                 
     CHAR usrad1[NADSIZ];     // address line 1 (company)                  
     CHAR usrad2[NADSIZ];     // address line 2                            
     CHAR usrad3[NADSIZ];     // address line 3                            
     CHAR usrad4[NADSIZ];     // address line 4                            
     CHAR usrpho[PHOSIZ];     // phone number                              
     CHAR systyp;             // system type code                          
     CHAR usrprf;             // user preference flags                     
     CHAR ansifl;             // ANSI flags                                
     CHAR scnwid;             // screen width in columns                   
     CHAR scnbrk;             // screen length for page breaks             
     CHAR scnfse;             // screen length for FSE stuff               
     CHAR age;                // user's age                                
     CHAR sex;                // user's sex ('M' or 'F')                   
     USHORT credat;           // account creation date                     
     USHORT usedat;           // date of last use of account               
     SHORT csicnt;            // classified-ad counts used so far          
     SHORT flags;             // various saved bit flags                   
     SHORT access[AXSSIZ];    // array of remote sysop access bits         
     LONG emllim;             // e-mail limit reached so far (new/old bdy) 
     CHAR prmcls[KEYSIZ];     // class to return user to if necessary      
     CHAR curcls[KEYSIZ];     // current class of this user                
     LONG timtdy;             // time user has been online today (in secs) 
     USHORT daystt;           // days left in this class (if applicable)   
     USHORT fgvdys;           // days since debt was last "forgiven"       
     LONG creds;              // credits available or debt (if negative)   
     LONG totcreds;           // total credits ever posted (paid & free)   
     LONG totpaid;            // total credits ever posted (paid only)     
     CHAR birthd[DATSIZ];     // this user's birthday date                 
};

                              // ansifl bit definitions                    
#define ANSON       1         //   ANSI on=1; off=0                        
#define ANSMAN      2         //   ANSI manual override (0=auto sensing)   

                              // flags bit definitions                     
#define HASMST      1         //   user has the "MASTER" key for the svr   
#define UNDAXS      2         //   this account cannot be deleted          
#define SUSPEN      4         //   this account is "suspended"             
#define DELTAG      8         //   this account is tagged for deletion     
#define GOINVB      16        //   this account is "invisible" upon logon  

                              // usrprf bit definitions                    
#define PRFLIN      1         //   always use line editor?   yes=1         

extern struct usracc *usaptr;// user accting block pointer for usrnum
extern struct usracc *othuap;// gen purp other-user accting data ptr 
extern struct usracc acctmp;// temporary user account storage area    

struct keyrec {               // key (or keyring) structure                
     CHAR userid[UIDSIZ];     //   User-ID (or keyring name)               
     CHAR keys[1];            //   variable length list of key names       
};

extern
struct uidxrf {                    // user-id cross reference structure    
     CHAR xrfstg[XRFSIZ+1];        //   cross reference string             
     CHAR userid[UIDSIZ];          //   user-id for this cross reference   
} uidxrf;

struct acclass {              // accounting class structure                
     CHAR clname[KEYSIZ];     //   class name                              
     CHAR nxtcls[4][KEYSIZ];  //   class to return to when expires         
     SHORT limcal;            //   limit per call (-1=no limit)            
     SHORT limday;            //   limit per day (-1=no limit)             
     SHORT dftday;            //   default days before expiring (-1=never) 
     LONG dbtlmt;             //   debt limit (0=none)                     
     SHORT fgvday;            //   wait how many days before "forgiving"   
     SHORT idlday;            //   inactive days before delete (-1=never)  
     SHORT flags;             //   general bit flags                       
     LONG seconds;            //   seconds used so far this month          
     USHORT users;            //   total number of users in this class     
     CHAR msgs[2][XMSGSZ];    //   exiting class messages                  
};
                              // indexes for nxtcls[] when a user...       
#define DOUTTIM 0             //   is out of time for the day              
#define DLOAFER 1             //   hasn't logged in for x number of days   
#define DEXPIRE 2             //   has been around x number of days        
#define DCREDIT 3             //   has/doesn't have credits                

                              // struct acclass bit flag definitions       
#define KCKOFF 1              //   out of time: knock the user offline     
#define CLSCHG 2              //   out of time: temporarily change class   
#define NOCRED 4              //   expire when: credits < 1                
#define DBTLMT 8              //   expire when: user reaches a debt limit  
#define HASCRD 16             //   expire when: credits > 0                
#define DAYEXP 32             //   expire when: x number of days passes    
#define IDLEXP 64             //   expire when: no log on for x # of days  
#define MONDAY 128            //   forgive: every Monday                   
#define FSTMTH 256            //   forgive: on the first of each month     
#define NUMDAY 512            //   forgive: every x number of days         
#define HITLMT 1024           //   forgive: when they hit their debt limit 
#define REPDBT 2048           //   report debt when forgiven?              
#define CRDXMT 4096           //   this class exempt from credit charges?  

struct clstab {               // structure for in-memory class table       
     CHAR clname[KEYSIZ];     //   class name                              
     CHAR nxtcls[4][KEYSIZ];  //   class to return to when expires         
     SHORT limcal;            //   limit per call (-1=no limit)            
     SHORT limday;            //   limit per day (-1=no limit)             
     SHORT dftday;            //   default days before expiring (-1=never) 
     LONG dbtlmt;             //   debt limit (-1=none)                    
     USHORT fgvday;           //   wait how many days before "forgiving"   
     SHORT idlday;            //   inactive days before delete (-1=never)  
     SHORT flags;             //   general bit flags                       
     LONG seconds;            //   seconds used so far this month          
     USHORT users;            //   total number of users in this class     
     struct clstab *next;     //   ptr to next element in linked list      
};

extern INT numcls;     // total number of classes in system         
extern USHORT dtrack;  // days tracked so far (for statistic avgs)  

extern struct clstab *clshead;// head record for class table       
extern struct clstab *clsptr; // general ptr to class table entry  

                              // csbump() return values for immediate bump 
#define BMPDEL -1             //   user account deleted due to bad class   
#define BMPAOK  0             //   user account OK: no immediate bump      
#define BMPTIM  1             //   out of time for today                   
#define BMPLNV  2             //   user not validated to logon yet         
#define BMPSNV  3             //   user not validated to logon after signup

extern DFAFILE* accbb;// user account database BTRIEVE file ptr    

                              //-- options for decevy() and (*decusr)() ---
extern INT decusn;     // user number                               
extern struct user *decusp;// user online information (MAJORBBS.H) 
extern struct usracc *decuap;// user account information (USRACC.H)
extern LONG deccst;    // cost of online time since last (*decusr)()
extern VOID (*decusr)(VOID);    // decevy() service vector         

// ACCOUNT.C 03/04/92 11.19.18
VOID iniacc(VOID);
struct usracc *uacoff(INT unum);
INT crtclass(struct acclass *cptr);
struct clstab *fndcls(CHAR *clsname);
VOID swtcls(struct usracc *uacc,INT makprm,CHAR *clsnam,INT dest,INT days);
INT namacls(CHAR *clsname);
LONG tfcchg(LONG nbytes,LONG credpk);
INT dedcrd(LONG amt,INT asmuch);
INT rdedcrd(LONG amt,INT asmuch);
INT odedcrd(INT unum,LONG amt,INT real,INT asmuch);
INT ndedcrd(CHAR *uid,LONG amt,INT real,INT asmuch);
INT gdedcrd(CHAR *uid,LONG amt,INT real,INT asmuch);
INT ldedcrd(struct usracc *uptr,LONG amt,INT real,INT asmuch);
LONG hdedcrd(struct usracc *uptr,LONG amt,INT real,INT asmuch);
INT tstcrd(LONG amt);
INT rtstcrd(LONG amt);
INT otstcrd(INT unum,LONG amt,INT real);
INT ntstcrd(CHAR *uid,LONG amt,INT real);
INT gtstcrd(CHAR *uid,LONG amt,INT real);
INT ltstcrd(struct usracc *uptr,LONG amt,INT real);
VOID dltcls(struct clstab *tabptr);
INT addcrd(CHAR *keyuid,CHAR *tckstg,INT real);
INT crdusr(CHAR *keyuid,CHAR *tckstg,INT real,INT affall);
INT saycrd(CHAR *tckstg,INT real);
VOID cpykey(CHAR *dest,CHAR *src,INT len);
VOID decevy(VOID);
INT declog(VOID);
INT decsup(VOID);
INT dectdy(VOID);
INT deccal(VOID);
VOID dec15s(VOID);
VOID deccrd(LONG surdsc);
VOID chkliu(VOID);
VOID savvbl(VOID);
INT imbump(INT logon);
INT csbump(INT logon);
INT wtwait(INT lomin,INT himin);
INT nliniu(VOID);
VOID updacc(VOID);
INT accmcu(VOID);
VOID accacct(struct usracc *accptr,INT plusor);
INT delacct(CHAR *userid);
INT kiluid(CHAR *userid);
VOID howbuy(VOID);
VOID clsacc(VOID);

#endif                             // __USRACC_H