/***************************************************************************
 *                                                                         *
 *   TFSCAN.H                                                              *
 *                                                                         *
 *   Copyright (c) 1993-1996 Galacticomm, Inc.   All Rights Reserved.      *
 *                                                                         *
 *   Text file scanning routines.  May use wildcards, but you must stay    *
 *   in the current directory (no path prefixes)                           *
 *                                                                         *
 *                                    - Robert N. Stein 1/8/93             *
 *                                                                         *
 ***************************************************************************/

#ifndef __TFSCAN_H
#define __TFSCAN_H

#if defined( __cplusplus )
extern "C" {
#endif


#define MAXTFS 129              // max number of characters per line + NUL

extern INT tfstate;           // tfsrdl() state code and return value 
extern CHAR tfsbuf[MAXTFS];   // line when tfsrdl() returns TFSLIN    
extern CHAR *tfspst;          // buf after skpwht when tfspfx() rets 1
#if defined( __cplusplus )
extern Cffblk tfsfb;          // ffblk structure from current file   
#endif
extern FILE *tfsfp;           // file ptr while tfsrdl() rets TFSLIN  

INT                                //   returns number of files            
tfsopn(                            // prep to scan text file(s)            
CHAR *fname);                      // may use wildcards, may use pth prefix

INT                                //   rets 0=done non-0=still scanning   
tfsrdl(VOID);                      // read a line from the file(s)         

GBOOL                              //   returns TRUE=prefix'd              
tfspfx(                            // is current line pfx'd with prefix stg
CHAR *prefix);                     //   prefix to check for                

VOID
tfsdpr(VOID);                      // after tfspfx() == 1,use "deeper" pfx 

VOID
tfsabt(VOID);                      // abort file scanning                  

//--- tfsrdl() return values and tfstate codes ---
#define TFSDUN 0                         // tfsrdl() done scanning file(s) 
#define TFSBGN 1    // tfsopn() has been called, tfsrdl() calls will begin 
#define TFSBOF 2                  // tfsrdl() is about to start a new file 
#define TFSLIN 3                            // tfsrdl() has a line for you 
#define TFSEOF 4                           // tfsrdl() is done with a file 


#if defined( __cplusplus )
}   // end extern "C"
#endif

#endif                             // __TFSCAN_H