/***************************************************************************
 *                                                                         *
 *   STZCPY.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for copying a string with zero fill.    *
 *                                                                         *
 *                                            - R. Stein   2/3/92          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 5 $"

CHAR *                             /*   returns ptr to destination         */
stzcpy(                            /* copy a string with limit and zero fil*/
CHAR *dst,                         /*   destination buffer                 */
const CHAR *src,                   /*   source buffer                      */
UINT num)                          /*   # of bytes in dest, includes '\0'  */
{
     UINT i;
     CHAR *orgdst;

     orgdst=dst;
     for (i=0 ; i < num-1 && *src != '\0' ; i++) {
          *dst++=*src++;
     }
     for ( ; i < num ; i++) {
          *dst++='\0';
     }
     return(orgdst);
}

CHAR *                             /*   returns ptr to destination buffer  */
stzcat(                            /* concatenate on a string, same limits */
CHAR *dst,                         /*   destination buffer                 */
const CHAR *src,                   /*   source buffer                      */
UINT num)                          /*   # of bytes in dest, includes '\0'  */
{
     UINT dstlen;

     dstlen=strlen(dst);
     stzcpy(&dst[dstlen],src,num-dstlen);
     return(dst);
}
