/***************************************************************************
 *                                                                         *
 *   STRRPL.C                                                              *
 *                                                                         *
 *   Copyright (c) 1994-1997 Galacticomm, Inc.  All Rights Reserved.       *
 *                                                                         *
 *   This is the GCOMM.LIB routine for replacing all occurences of a       *
 *   specific character in a string with another character.  Replacement   *
 *   is done in-place.  The string passed is also returned.                *
 *                                                                         *
 *                                                  - R. Stein 9/28/94     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

CHAR *                             /*   returns ptr to string              */
strrpl(                            /* replace characters in a string       */
CHAR *str,                         /*   string to do replacing in, NUL-term*/
CHAR och,                          /*   character to replace (0x01 to 0xFF)*/
CHAR nch)                          /*   new character (0x01 to 0xFF)       */
{
     CHAR *cp;

     for (cp=str; (cp=strchr(cp,och)) != NULL ; cp++) {
          *cp=nch;
     }
     return(str);
}
