/***************************************************************************
 *                                                                         *
 *   STGIDX.C                                                              *
 *                                                                         *
 *   Copyright (c) 1993-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   stgidx() is a string scanner routine that searches for a character    *
 *   in a string and returns 0 to strlen-1 if found, or -1 if not.         *
 *   (This is like findstg() except no special '-' character and points    *
 *   to the start of the string found and searches for a character,        *
 *   not a string)                                                         *
 *                                                                         *
 *                                            - R. Stein 1/17/93           *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

INT                                /*   returns index of character in stg  */
stgidx(                            /* find occur of a character in a stg   */
CHAR *string,                      /*   string to search                   */
CHAR ch)                           /*   character to search for            */
{
     CHAR *cp;

     if ((cp=strchr(string,ch)) == NULL) {
          return(-1);
     }
     return((INT)(cp-string));
}
