/***************************************************************************
 *                                                                         *
 *   SPR.C                                                                 *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine which takes parameters just like the    *
 *   standard C printf() ("long" values supported and all), and which      *
 *   returns a pointer to a statically-allocated buffer containing the     *
 *   result.  It may be called up to 4 times in rapid succession (such     *
 *   as in the parameter list of a single function call) without           *
 *   returning the same buffer.                                            *
 *                                                                         *
 *                                            - T. Stryker 2/3/92          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 5 $"

CHAR *                             /*   returns buffer to converted string */
spr(                               /* galacticomm flavor of sprintf()      */
CHAR *ctlstg,                      /*   control string                     */
...)                               /*   variable arguments                 */
{
     CHAR *cp;
     va_list ap;
     static INT cycle=0;
     static CHAR result[4][120];

     cp=result[cycle=(cycle+1)&3];
     va_start(ap,ctlstg);
     vsprintf(cp,ctlstg,ap);
     va_end(ap);
     if (strlen(cp) >= sizeof(result[0])) {
          catastro("OVERSIZED SPR() CALL FROM %04X:%04X\n\"%s\"",
                   ((USHORT *)(&ctlstg))[-1],
                   ((USHORT *)(&ctlstg))[-2],cp);
     }
     return(cp);
}

