/***************************************************************************
 *                                                                         *
 *   SKPANS.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for skipping over ANSI in a string.     *
 *                                                                         *
 *                                                 - C. Robert 5/26/92     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

CHAR *                             /*   returns ptr to string              */
skpans(                            /* ret a ptr to the first non-ANSI byte */
CHAR *stg)                         /*   string to skip ANSI in             */
{
     INT inans=0;

     while (*stg != '\0') {
          if (inans && isalpha(*stg)) {
               inans=0;
          }
          else if (*stg == ESC && *(stg+1) == '[') {
               inans=1;
          }
          else if (!inans) {
               return(stg);
          }
          stg++;
     }
     return(stg);
}
