/***************************************************************************
 *                                                                         *
 *   SFXVAL.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   These are GCOMM.LIB routines for converting numeric dynapak suffixes, *
 *   which may have been mangled by olthan or ogthan, into the proper      *
 *   numeric equivalent                                                    *
 *                                                                         *
 *                                            - J. Alvrus  1/4/95          *
 *                                                                         *
 ***************************************************************************/

#define FILREV "$Revision: 5 $"

#include "gcomm.h"
#include "gcspsrv.h"

GBOOL                              /*   returns FALSE if str not numeric   */
isfxval(                           /* convert numeric dpk suffix to int    */
UINT *result,                      /*   buffer to place result             */
CHAR *str)                         /*   numeric portion of suffix string   */
{                                  /*   (takes olthan/ogthan into account) */
     SHORT changeby;
     CHAR *cp,tmpstr[SFXSIZ];

     ASSERT(result != NULL);
     ASSERT(str != NULL);
     ASSERT(strlen(str) < SFXSIZ);
     stlcpy(tmpstr,str,SFXSIZ);
     cp=tmpstr+strlen(tmpstr)-1;
     changeby=0;
     if (!isdigit(*cp)) {
          changeby=*cp < '0' ? -1 : 1;
          *cp-=changeby;
     }
     if (!alldgs(tmpstr)) {
          return(FALSE);
     }
     sscanf(tmpstr,"%u",result);
     *result+=changeby;
     return(TRUE);
}

GBOOL                              /*   returns FALSE if str not numeric   */
lsfxval(                           /* convert numeric dpk suffix to long   */
ULONG *result,                     /*   buffer to place result             */
CHAR *str)                         /*   numeric portion of suffix string   */
{                                  /*   (takes olthan/ogthan into account) */
     INT changeby;
     CHAR *cp,tmpstr[SFXSIZ];

     ASSERT(result != NULL);
     ASSERT(str != NULL);
     ASSERT(strlen(str) < SFXSIZ);
     stlcpy(tmpstr,str,SFXSIZ);
     cp=tmpstr+strlen(tmpstr)-1;
     changeby=0;
     if (!isdigit(*cp)) {
          changeby=*cp < '0' ? -1 : 1;
          *cp-=changeby;
     }
     if (!alldgs(tmpstr)) {
          return(FALSE);
     }
     sscanf(tmpstr,"%lu",result);
     *result+=changeby;
     return(TRUE);
}
