/***************************************************************************
 *                                                                         *
 *   SAMETO.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for determining if a short string is    *
 *   equal to a longer string, up to the end of the short one (upper/      *
 *   lower case differences aside).  Returns 1 if so, 0 otherwise.         *
 *                                                                         *
 *                                            - T. Stryker 2/3/92          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 5 $"

GBOOL                              /*   returns TRUE=short matches         */
sameto(                            /* compare short string to long string  */
const CHAR *shorts,                /*   short string to compare            */
const CHAR *longs)                 /*   long string to compare             */
{
     while (*shorts != '\0') {
          if (tolower(*shorts) != tolower(*longs)) {
               return(FALSE);
          }
          shorts++;
          longs++;
     }
     return(TRUE);
}
