/***************************************************************************
 *                                                                         *
 *   REPMEM.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for replicating a string multiple       *
 *   times into a buffer.                                                  *
 *                                                                         *
 *                                            - S. Brinker 2/3/92          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

VOID
repmem(                            /* replicate what into where for totsiz */
VOID *where,                       /*   buffer to do replication           */
CHAR *what,                        /*   pattern to replicate               */
INT totsiz)                        /*   total size of "where" buffer       */
{
     INT len,i,looplim;

     len=strlen(what);
     looplim=totsiz-len+1;
     for (i=0 ; i < looplim ; i+=len) {
          movmem(what,(CHAR *)where+i,len);
     }
     if (i < totsiz) {
          movmem(what,(CHAR *)where+i,totsiz-i);
     }
}
