/***************************************************************************
 *                                                                         *
 *   PROFAN.C                                                              *
 *                                                                         *
 *   Alternative to Galacticomm's profanity detection library file.        *
 *   Courtesy of Logicom 305/581-0092                                      *
 *                                                                         *
 *                              Aug 16, 1988 - By D. Arnel                 *
 *                                                                         *
 *   Modified to follow more closely to profan.asm such as updating        *
 *   pfnptr.                                                               *
 *                                                                         *
 *                              - Mahesh Neelakanta 11/8/94                *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 2 $"

CHAR *pfnptr=NULL;                 /* ptr to the profanity                 */
CHAR *pfnlst=NULL;

static CHAR aWords[] = { 'n','a','l',1,
                         's','s','h','o','l',3,
                         's','s','w','i','p','e',3,
                         's','s',1,
                         0
};
static CHAR bWords[] = { 'l','o','w',1,
                         'i','t','c','h',1,
                         'o','s','o','m',2,
                         'o','w','e','l',2,
                         'r','e','a','s','t',1,
                         0
};
static CHAR cWords[] = { 'l','i','t','o','r',2,
                         'o','c','k',1,
                         'r','a','p',1,
                         'r','o','t','c','h',1,
                         'u','m',1,
                         'u','n','n','i','l',3,
                         'u','n','t',3,
                         0
};
static CHAR dWords[] = { 'i','c','k',1,
                         0
};
static CHAR eWords[] = { 'j','a','c','u',2,
                         'r','e','c','t',1,
                         0
};
static CHAR fWords[] = { 'a','g','g','o','t',3,
                         'a','r','t',1,
                         'e','c','a',2,
                         'e','l','l','a','t','i','o',2,
                         'o','n','d','l',2,
                         'o','r','e','s','k','i','n',2,
                         'u','c','k',3,
                         'v','c','k',3,
                         0
};
static CHAR gWords[] = { 'a','y',1,
                         0
};
static CHAR hWords[] = { 'a','r','d','o','n',3,
                         'o','m','o',1,
                         0
};
static CHAR iWords[] = { 0
};
static CHAR jWords[] = { 'e','r','k',1,
                         'e','w',1,
                         0
};
static CHAR kWords[] = { 0
};
static CHAR lWords[] = { 'i','c','k',1,
                         0
};
static CHAR mWords[] = { 'a','s','t','u','r','b',3,
                         'e','m','b','e','r',1,
                         0
};
static CHAR nWords[] = { 'i','p','p','l',2,
                         0
};
static CHAR oWords[] = { 'r','g','a','s','m',2,
                         0
};
static CHAR pWords[] = { 'e','e',1,
                         'e','n','i','s',2,
                         'i','s','s',2,
                         'r','i','c','k',1,
                         'u','b','i','c',2,
                         'u','s','s','y',2,
                         0
};
static CHAR qWords[] = { 'u','e','e','r',3,
                         0
};
static CHAR rWords[] = { 0
};
static CHAR sWords[] = { 'c','r','o','t','u','m',2,
                         'h','i','t',3,
                         'u','c','k',1,
                         0
};
static CHAR tWords[] = { 'u','r','d',1,
                         'w','a','t',1,
                         0
};
static CHAR uWords[] = { 'r','i','n','a','t',2,
                         'r','i','n','e',1,
                         't','e','r','u','s',2,
                         0
};
static CHAR vWords[] = { 'a','g','i','n','a',2,
                         'u','l','v','a',2,
                         0
};
static CHAR wWords[] = { 'h','o','r','e',2,
                         0
};
static CHAR xWords[] = { 0
};
static CHAR yWords[] = { 0
};
static CHAR zWords[] = { 0
};
CHAR *profList[26]={ aWords,bWords,cWords,dWords,eWords,fWords,gWords,
                     hWords,iWords,jWords,kWords,lWords,mWords,nWords,
                     oWords,pWords,qWords,rWords,sWords,tWords,uWords,
                     vWords,wWords,xWords,yWords,zWords
};

INT                                /*   returns level of profanity         */
profan(                            /* checks level of profanity in string  */
CHAR *src)                         /*   string to check                    */
{
     CHAR srcChar,profChar;
     CHAR *pProfStr;
     CHAR *pSrc;
     INT profLevel=0;

     for (srcChar=src[0] ; srcChar != '\0' ; srcChar=*(++src)) {
          srcChar=tolower(srcChar);
          if (srcChar < 'a' || srcChar > 'z') {
               continue;
          }
          pProfStr=profList[srcChar-'a'];
          for (profChar=*pProfStr++; profChar != '\0' ; profChar=*pProfStr++) {
               for (pSrc=src+1,srcChar=pSrc[0] ;
                     srcChar != '\0' && srcChar != ' ' ; srcChar=*(++pSrc)) {
                    srcChar=tolower(srcChar);
                    if (srcChar < 'a' || srcChar > 'z') {
                         continue;
                    }
                    if (srcChar != profChar) {
                         break;
                    }
                    profChar=*pProfStr++;
               }
               if (profChar <= 3) {
                    if (profLevel < profChar) {
                         profLevel=profChar;
                         pfnptr=src;
                    }
               }
               else {
                    while (*pProfStr++ > 3) {
                    }
               }
          }
     }
     return(profLevel);
}
