/***************************************************************************
 *                                                                         *
 *   PRF.CPP                                                               *
 *                                                                         *
 *   Copyright (C) 1994-1995 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   prf functions in C.                                                   *
 *                                                                         *
 *                                        - Mahesh Neelakanta 4/27/94      *
 *                                                                         *
 ***************************************************************************/

#include "gcommlib.h"

CHAR *prfbuf;                      // output buffer staging area           
CHAR *prfptr;                      // pointer to prf buffer                
INT pfbsiz;
INT clsave;
INT ilingo;
INT mltflg=0;                      // which prfbuffer to use               

extern CHAR** prfpointers;
extern INT clingo;
extern INT nlingo;
extern CHAR* linuse;

extern CHAR *getMsgBlk(int);
extern VOID cklonl(VOID);

VOID
prfmlt(                            // multilingual version of prfmsg()     
INT msgnum,                        //   message number to use              
...)                               //   variable arguments                 
{
     va_list ap;
     va_start(ap,msgnum);
     cklonl();
     clsave=clingo;
     for (clingo=0 ; clingo < nlingo ; clingo++) {
          if (linuse[clingo]) {
               prfptr=prfpointers[clingo];
               vsprintf(prfptr,getMsgBlk(msgnum),ap);
               prfptr=prfbuf+strlen(prfbuf); /* point to the '\0' */
               prfpointers[clingo]=prfptr;
          }
     }
     prfptr=prfpointers[0];
     clingo=clsave;
     mltflg=1;
     va_end(ap);
}

VOID
pmlt(                              // multilingual version of prf()        
CHAR *fmt,                         //   control string                     
...)                               //   variable arguments                 
{
     va_list ap;
     va_start(ap,fmt);
     cklonl();
     for (ilingo=0; ilingo < nlingo ;ilingo++) {
          if (linuse[ilingo]) {
               prfptr=prfpointers[ilingo];
               vsprintf(prfptr,fmt,ap);
               prfptr=prfbuf+strlen(prfbuf);
               prfpointers[ilingo]=prfptr;
          }
     }
     prfptr=prfpointers[0];
     mltflg=1;
     va_end(ap);
}

VOID
iniprf(                            // initialize prf buffer                
CHAR *pbuf,                        //   ptr to dest of prf buffer          
INT psiz)                          //   size of prf buffer                 
{
     prfbuf=pbuf;
     pfbsiz=psiz-1;
     clrprf();
}

VOID
outprf(                            // output prfbuf to usrnum              
INT usrnum)                        //   usrnum to send data to             
{
     extern INT btuxmt(INT,CHAR *);
     btuxmt(usrnum,prfbuf);
     prfptr=prfbuf;
}

VOID
prf(                               // puts data into prfbuf                
CHAR *fmt,                         //   control string                     
...)                               //   variable arguments                
{
     va_list ap;
     va_start(ap,fmt);
     vsprintf(prfptr,fmt,ap);
     prfptr=prfbuf+strlen(prfbuf);
     va_end(ap);
     mltflg=0;
}

VOID
prfmsg(                            // puts data into prfbuf using msg block
INT msgnum,                        //   message number to use              
...)                               //   variable arguments                 
{
     va_list ap;
     CHAR *str;

     str=getMsgBlk(msgnum);
     va_start(ap,msgnum);
     vsprintf(prfptr,str,ap);
     prfptr=prfbuf+strlen(prfbuf);
     va_end(ap);
     mltflg=0;
}

VOID
clrprf(VOID)                       // clears prfbuf and reset pointer
{
     prfptr=prfbuf;
     *prfbuf='\0';
}