/***************************************************************************
 *                                                                         *
 *   MEMSTP.C                                                              *
 *                                                                         *
 *   Copyright (c) 1994-1997 Galacticomm, Inc.  All Rights Reserved.       *
 *                                                                         *
 *   This is the GCOMM.LIB routine for stripping a byte from a             *
 *   block of binary bytes.  Returns the number of bytes remaining.        *
 *                                                                         *
 *                                                  - R. Stein 7/24/94     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

INT                                /*   returns number of remaining bytes  */
memstp(                            /* strip a byte from a block of bytes   */
CHAR *block,                       /*   block to strip from                */
INT nbytes,                        /*   number of bytes in block           */
CHAR byt)                          /*   byte to strip (0x00 to 0xFF)       */
{
     CHAR *bp;
     INT nmov;

     while (nbytes > 0 && (bp=(CHAR *)memchr(block,byt,nbytes)) != NULL) {
          if ((nmov=nbytes-((INT)(bp-block))-1) > 0) {
               movmem(bp+1,bp,nmov);
          }
          nbytes--;
     }
     return(nbytes);
}
