/***************************************************************************
 *                                                                         *
 *   MDFGETS.C                                                             *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine (similar to the standard C fgets()      *
 *   routine) which gets a line into a buffer of a specified size.         *
 *   Unlike fgets(), it converts newline into carriage return, and it      *
 *   expects the last line of the file not to end in a newline.            *
 *                                                                         *
 *                                            - T. Stryker 2/3/92          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 5 $"

CHAR *                             /*   returns ptr to buf                 */
mdfgets(                           /* server flavor of fgets()             */
CHAR *buf,                         /*   buffer to store line in            */
INT size,                          /*   size of buffer (just in case)      */
FILE *fp)                          /*   file pointer                       */
{
     INT i,c;

     ASSERT(fp != NULL);
     ASSERT(buf != NULL);
     for (i=0 ; i < size-1 ; i++) {
          switch (c=fgetc(fp)) {
          case '\r':
               i--;
               break;
          case '\n':
               buf[i++]='\r';
               buf[i]='\0';
               return(buf);
          case EOF:
               if (i == 0) {
                    return(NULL);
               }
               else if (buf[i-1] == 26) {
                    buf[i-1]='\0';
               }
               else {
                    buf[i]='\0';
               }
               return(buf);
          default:
               buf[i]=c;
          }
     }
     buf[i]='\0';
     return(buf);
}
