/***************************************************************************
 *                                                                         *
 *   MAJORBBS.H                                                            *
 *                                                                         *
 *   Copyright (c) 1987-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the main Worldgroup header file.                              *
 *                                                                         *
 *                                            - T. Stryker 6/24/86         *
 *                                                                         *
 ***************************************************************************/

#ifndef __MAJORBBS_H
#define __MAJORBBS_H

#include "brkthu.h"
#include "locknkey.h"
#include "usracc.h"
#include "autorip.h"

#define VERSIZ          9     // size of ASCII rendition of versions       
#define SBVSIZ         40     // size of ASCII rendition of sub-ver        

#define MAXNTERM      256          // maximum allowed value of nterms      
#define INPSIZ        256          // input buffer size for each channel   
#define OUTSIZ     outbsz          // config param: output buffer size/chan
#define MTXSIZ        400          // maximum message-text string size     
#define DFTIMX        127          // default input-char count max per line
#define NCOMTY          8          // number of computer type codes        
#define NACMTY (NCOMTY-4)          // # of computer type codes in use      
#define NAGEBK          5          // number of age brackets tallied       
#define AUDSIZ        132          // size of audit trail records          
#define CTNUOS          2          // screen len code used for "continuous"
#define XTRIES         10          // # of times to inject X's fo "go" cmd 
#define TVRSIZ         16          // maximum size of a text variable name 
#define MAXSEL         25          // maximum number of selections per page
#define FNMSIZ         80          // maximum size for file and path       
#define PNMSIZ         16          // maximum size for menu page names     
#define MNMSIZ         25          // maximum size for module names        
#define CMDSIZ         60          // maximum size for command strings     
#define SHDSIZ         31          // maximum size for short descriptions  
#define LNDSIZ         50          // maximum size for long descriptions   
#define TITLSZ         43          // maximum size for menu page titles    
#define AIDSIZ          9          // maximum size for C/S appids          
#define FNSIZE      (8+1)          // size of filename (w/o ext) w/ NUL    
#define FNEXSZ  (8+1+3+1)          // filename and ext, with '.' and NUL   

#define NUMGRPS        17          // # of channel groups fm BBSMAJOR.MSG  
#define TPERSC         18          // real-time irpts/sec (== Flash rate)  
#define MAXXRF         16          // max # of displayed possible uid x-ref
#define GENSIZ       8192          // max size of a generic user dbase rec 
#define ZAPINT          5          // interval to decrement zaptbl values  
#define ZAPMAX         60          // max value of a zaptbl entry          
#define ANNOSIZE        4          // reserved size hooked announcement mem

                                   // System editor call                   
extern INT (*bgnedt)(INT,CHAR *,INT,CHAR *,SHORT (*)(SHORT),INT);

                                   // flags that can be passed to bgnedt() 
#define ED_FILIMP       1          //   allow importing from DOS files     
#define ED_READON       2          //   "read only" mode                   
#define ED_CLRTOP       4          //   clear topic buffer upon entry      
#define ED_CLRTXT       8          //   clear text buffer upon entry       
#define ED_FILESD      16          //   use "file" flavor of editor        
#define ED_LINEMO      32          //   force use of the line editor       
#define ED_FIXTOP      64          //   don't allow changing of topic field

                              // flags passed to the editor's whndun() rou 
#define ED_QUITEX     256          //   user quit the editing session 

                                   // is this user editing from here?      
extern INT (*inedit)(INT usn,SHORT (*exipnt)(SHORT));

                                   // editor import hooking routine        
extern VOID (*edtimr)(GBOOL (*imradr)());


extern VOID (*edtpfn)(INT pfnlvl); // editor set pfn level (after bgnedt)  

struct user {                      // volatile per-user info maintained    
     ULONG flags;                  //   runtime flags                      
     ULONG tckrst;                 //   lngtck when channel reset (rstchn()
     ULONG tckonl;                 //   lngtck when logging on (lonstf())  
     LONG baud;                    //   baud rate (obsoletes usrptr->baud) 
     INT usrcls;                   //   class (offline, or type of online) 
     INT *keys;                    //   dyn. alloc'd array of key bits     
     INT state;                    //   state (module number in effect)    
     INT substt;                   //   substt (for convenience of module) 
     INT lofstt;                   //   state of final lofrou() routine    
     INT usetmr;                   //   usage timer (for nonlive timeouts) 
     INT minut4;                   //   total minutes of use, times 4      
     INT countr;                   //   general purpose counter            
     INT pfnacc;                   //   profanity accumulator              
     INT nazapc;                   //   no-activity auto-logoff counter    
     INT linlim;                   //   "logged in" module loop limit      
     INT lingo;                    //   user lang, 0 to nlingo-1 (LINGO.H) 
     INT entstt;                   //   entered A/A mode for this state    
     struct clstab *cltptr;        //   ptr to guys current class in table 
     VOID (*polrou)();             //   pointer to current poll routine    
     SHORT crdrat;                 //   credit-consumption rate            
     USHORT tspxt;                 //   ticker time when SPX terminated    
     CHAR col;                     //   current column for secret char echo
     CHAR wid;                     //   line width for secret char echo    
     CHAR ech;                     //   char to echo for secret char echo  
     CHAR byecnt;                  //   count-down for byenow() time-out   
     CHAR lcstat;                  //   LAN chan state  0=nonlan/nonhdw    
};

struct usrmnu {            // user's menuing-specific variables    
     CHAR curpag[PNMSIZ];          //   current menu page                  
     CHAR parpag[PNMSIZ];          //   parent menu page                   
     CHAR selchrs[MAXSEL];         //   select characters currently avail  
     CHAR pages[MAXSEL][PNMSIZ];   //   pages/file names for select chars  
     CHAR optdsp[MAXSEL];          //   instructions on how to display opts
     INT keyreq[MAXSEL];           //   key required for each select char  
     FILE *fp;                     //   ptr to file currently being viewed 
     CHAR mnuttl[TITLSZ];          //   menu page title                    
};

extern struct usrmnu *mnuusr;

struct pglink {                    // menu page menu selection data struct 
     SHORT position;               //   idx of position in WGSMTREE editor 
     CHAR selchr;                  //   select character for page          
     CHAR iconame[FNSIZE];         //   C/S display icon name              
     CHAR destpage[PNMSIZ];        //   destination page name              
     CHAR optdsp;                  //   instructions on how to display opts
     CHAR keyreq[KEYSIZ];          //   key required for each page         
     CHAR shortd[SHDSIZ];          //   selection name                     
     CHAR longd[LNDSIZ];           //   longer description of option       
};

struct mnupag {                    // menu page data struct (dfa layout)   
     CHAR menutype[1];             //   menu page type, "A"=A/A or "C"=C/S 
     CHAR pagnam[PNMSIZ];          //   menu page name                     
     CHAR parpag[PNMSIZ];          //   parent menu page                   
     CHAR fname[GCSTRPTH];         //   file name for menus/displayed files
     CHAR modnam[MNMSIZ];          //   module name to enter (module lnk)  
     CHAR cmdstg[CMDSIZ];          //   command string for entry to module 
     CHAR golock[KEYSIZ];          //   lock placed on "go"ing to this page
     SHORT flags;                  //   flags for cond'l/mod pages, etc    
     CHAR mnuttl[TITLSZ];          //   menu page title/menu window caption
     SHORT npages;                 //   number of pages stored             
     LONG ichange;                 //   time code for menu icon change     
     struct pglink page[MAXSEL];   //   variable number of pages stored    
};
extern struct mnupag *menupg;

                                   // defines for flags for above struct   
#define AUTPAG      1              //   auto-select page                   
#define MDLPAG      2              //   module link page                   
#define FILPAG      4              //   file display page                  
#define CNGOTO      8              //   can "go" to this page              
#define DFTDSP     16              //   use default menu display           
#define DISABL     32              //   page is currently disabled         
#define TPOTRE     64              //   page is top of a menu tree         
#define NOMPHD    128              //   no module page hdr if module page  
#define NOFPHD    256              //   no file page hdr if file page      
                                   //    (c/s mode: launch the file)       
#define CSMPAG    512              //   C/S module link page               

extern INT mnudnl;                 // user downloading BBSMENU.DAT (or -1) 

                                   // user usrcls codes                    
#define VACANT 0                   //   vacant, offline                    
#define ONLINE 1                   //   online, not logged on              
#define BBSPRV 2                   //   online, private class (internal)   
#define SUPIPG 3                   //   signup in progress                 
#define SUPLON 4                   //   supplemental logon in progress     
#define SUPLOF 5                   //   supplemental logoff in progress    
#define ACTUSR 6                   //   logged on and active               

                         // VACANT usrcls state codes:                     
#define JSTRST   0       // just reset, awaiting command confirmation      
#define EMTATZ  -1       // emitting ATZ, awaiting completion              
#define EKLVEC  -2       // emitting kill-vector, awaiting completion      
#define W4KILL  -3       // waiting for kill-system to take effect         
#define ATZDUN  -4       // ATZ OK received, waiting 1/10 sec extra        
#define ESTVEC  -5       // emitting startup string, awaiting completion   
#define W4ISOK  -6       // waiting for OK in response to init string      
#define AWAITC  -7       // awaiting call                                  
#define XERING  -8       // XE1201/3 phone rang, answered, awaiting carrier
#define HARING  -9       // Hayes-style phone rang, answd, awaiting carrier
#define HPAUSE -10       // Hayes-style post-connect 2-second pause        
#define AUTSNS -11       // Auto sensors doing their stuff (AUTSNS.C)      
#define WAIT29 -20       // wait to be able to send X.29 string            
#define W4SPXT -21       // wait for old SPX session to terminate          
#define WCDICN -30       // wait for a GCDI channel to connect to server   
#define CRESET -31       // pending channel reset                          

                                   // Menuing System's sub-state codes     
#define JSTLON -1                  //   just logged on: goto TOP page      
#define JSTRET 0                   //   just ret'd from module: goto parent
#define SITTIN 1                   //   user is sitting at a menu prompt   
#define MNUFIL 2                   //   a menu file is being displayed     
#define OTHFIL 3                   //   a file page is being displayed     
#define FINDIN 4                   //   user is trying to "find" a page    

                                   // standard profanity thresholds        
#define WRNPFN 7                   //   warning level                      
#define MAXPFN 12                  //   logoff level                       

                                   // user runtime flag bit values         
#define NOINJO 0x00000001L         //   unable to receive injoth() msgs    
#define INJOIP 0x00000002L         //   injoth() operation in progress     
#define BYEBYE 0x00000004L         //   going away, just wait for msg done 
#define NOHDWE 0x00000008L         //   no hardware, emulation chan only   
#define OPCHAT 0x00000010L         //   chatting-with-sysop flag           
#define ACTIVE 0x00000020L         //   channel-is-active (gen'ing status) 
#define MASTER 0x00000040L         //   user has the "master key" flag     
#define IS2698 0x00000080L         //   channel-is-2698 (XE2400)           
#define NOZAP  0x00000100L         //   don't logoff freeloader flag       
#define ISRIAL 0x00000200L         //   channel-is-serial-port             
#define X2MAIN 0x00000400L         //   exit-to-main-menu when sysop chat  
#define CONCEX 0x00000800L         //   commands concatenated -- exit fast 
#define ISX25  0x00001000L         //   channel-is-X.25                    
#define NOGLOB 0x00002000L         //   don't interpret global commands    
#define INVISB 0x00004000L         //   user is "invisible" to others      
#define ABOIP  0x00008000L         //   abort output in-progress           
#define MONALL 0x00010000L         //   monitor all in progress            
#define MONINP 0x00020000L         //   monitor input in progress          
#define ONEMIN 0x00040000L         //   got one-min. warning of logoff     
#define NON550 0x00080000L         //   real hardware isn't 16550          
#define IS1201 0x00100000L         //   Model 16 or 4, using XECOM 1201's  
#define ISGCDI 0x00200000L         //   GCDI channel                       
#define MONHID 0x00400000L         //   Hide input from the monitor screen 
#define ISGCSU 0x00800000L         //   user is a C/S client               
#define WSGCSU 0x01000000L         //   user was C/S client (now in ASCII) 
#define GCSLON 0x02000000L         //   C/S logon routines have been called
#define GCSDUN 0x04000000L         //   C/S signup acct info being recorded

#define NO_MESSAGE  0              // param to byenow() for "no message"   
#define PAMSG  -1                  // parm to byenow() for, prf()'d already

                                   // special GSBL status codes:           
#define FSESTS       191           // FSE status cycle code                
#define POLSTS       192           // poll stat code (like CYCLE, but auto)

#define CLOX29       230      // btux29() call produced window-full error  
#define ERRX29       231      // btux29() produced some other fatal error  
#define CYCLE        240      // cycle-thru-other-users pseudo-status code 
#define RELOG        241      // re-log-in pseudo-status code              
#define CDICONN      242      // custom interface call connected           

extern
struct module {                    // module interface block               
     CHAR descrp[MNMSIZ];          //   description for main menu          
     GBOOL (*lonrou)(VOID);        //   user logon supplemental routine    
     GBOOL (*sttrou)(VOID);        //   input routine if selected          
     VOID (*stsrou)(VOID);         //   status-input routine if selected   
     GBOOL (*injrou)(VOID);        //   "injoth" routine for this module   
     GBOOL (*lofrou)(VOID);        //   user logoff supplemental routine   
     VOID (*huprou)(VOID);         //   hangup (lost carrier) routine      
     VOID (*mcurou)(VOID);         //   midnight cleanup routine           
     VOID (*dlarou)(CHAR *uid);    //   delete-account routine             
     VOID (*finrou)(VOID);         //   finish-up (sys shutdown) routine   
} **module;

extern INT nmods;                  // number of modules currently online

extern
INT
    conhdl,                        // handle to array of connect functions 
    dschdl,                        // handle to array of disconnect   "    
    mcuhdl,                        // handle to array of auto-cleanup "    
    dlahdl,                        // handle to array of delete-acct  "    
    finhdl,                        // handle to array of shutdown     "    
    ffinhdl,                       // handle to array of final shutdown "  
    s2aahdl,                       // handle to array of C/S->A/A       "  
    s2cshdl,                       // handle to array of A/A->C/S       "  
    annohdl;                       // handle to array of announcement   "  

extern CHAR *annomem;              // per-request logon announcement mem.  

extern
struct mdstats {                   // module statistics data structure     
     CHAR mdname[MNMSIZ];          //   name of module (key for btrieve)   
     ULONG seconds;                //   number of hours consumed in module 
     ULONG creds;                  //   number of creds consumed in module 
} *mdstats;

extern
struct textvar {                   // text variable structure              
     CHAR name[TVRSIZ];            //   name of text variable              
     CHAR *(*varrou)(VOID);        //   pointer to text variable function  
} *txtvars;

extern INT ntvars;                 // number of text variables in memory

extern
struct sysvbl {                    // system-variable btrieve record layout
     CHAR key[4];                  //   4-character dummy key of "key"     
     CHAR dspopt[6];               //   display options by position number 
     LONG calls[8];                //   number of calls this month/baud rt 
     CHAR lonmsg[MTXSIZ];          //   log-on message in effect           
     LONG dwnlds;                  //   total downloads to date            
     LONG uplds;                   //   total uploads to date              
     LONG msgtot;                  //   msg (E-mail/Forums) total to date  
     USHORT emlopn;                //   E-mail open at the moment          
     USHORT sigopn;                //   Forum messages open at the moment  
     SHORT hisign;                 //   highest Forum number used to date  
     CHAR monmal;                  //   id of screen to display on aux CRT 
     CHAR savmin;                  //   Minutes to save screen             
} sv;

extern
struct sysvb2 {                    // second system variable btrieve layout
     CHAR ky2[4];                  //   4-character dummy key of "ky2"     
     USHORT matrix[NCOMTY][NAGEBK];//   matrix of accts (computer/age)     
     SHORT nliniu[48];             //   number of lines in use per hlf/hr  
     SHORT lstzer;                 //   date of last zeroing of stats      
     LONG x25kps;                  //   X.25 kilopackets sent or received  
     USHORT x25ps;                 //   fractional X.25 kilopackets        
     LONG x25mbs;                  //   X.25 megabytes sent or received    
     LONG x25bs;                   //   fractional X.25 megabytes          
     ULONG numact;                 //   total number of user accounts      
     ULONG numfem;                 //   number of female users             
     ULONG numcor;                 //   number of corporate users          
     ULONG numans;                 //   number of ANSI users               
     ULONG paidpst;                //   credits paid-for so far            
     ULONG freepst;                //   credits given away free so far     
     LONG totcalls;                //   total calls-to-date                
     SHORT lastmcu;                //   date of last midnight cleanup      
} sv2;

extern
struct sysvb3 {                    // third system variable btrieve layout 
     CHAR ky3[4];                  //   4-character dummy key of "ky3"     
     LONG secghr[NUMGRPS-1][24];   //   seconds used (channel grp/hr)      
     LONG crdghr[NUMGRPS-1][24];   //   credits consumed (channel grp/hr)  
} sv3;

extern INT digalw;                 // digits allowed in User-IDs?          

#define   UIDFND     0             // hdluid(): found user-id              
#define   UIDPMT    -1             // hdluid(): uid not found: re-prompt   
#define   UIDCAL    -2             // hdluid(): uid not found: call again  

extern INT nterms;     // this many simultaneous users are supported
extern INT hichp1;     // highest channel number in use, plus 1     
extern INT usrnum;     // global user-number (channel) in effect    
extern INT othusn;     // general purpose other-user channel number 
extern INT uisusn;     // uinsys() other-user channel number        

extern struct user *usrptr;   // global pointer to user data in effect
extern struct user *othusp;   // gen purp other-user user structure ptr

extern HMCVFILE mjrmb;        // executive named-message file block hdl    

extern INT *channel;          // array of channel codes (as displayed)     

extern ULONG lngtck;          // 4-gig second counter (0L=server UP)       

extern INT *grpnum;           // array of group numbers, by channel number 

extern CHAR chanty[];         // array of btusdf() codes for LAN chan grps 
extern CHAR grtype[];         // array of Group Type codes:                
extern CHAR *grtsub[];        // array of GCDI channel type names          
extern CHAR version[];        // main version code, in form X.YY           
extern CHAR subvers[];        // sub-version info, ext ed rls letters      
extern CHAR echtyp[];         // array of echo options                     

extern CHAR *startv[NUMGRPS]; // array of ptrs to startup AT-commands
extern CHAR *mdmatz[NUMGRPS]; // array of ptrs to modem reset strings
extern CHAR *mdmbsy[NUMGRPS]; // array of ptrs to modem busy-out stgs
extern CHAR *mdmnan[NUMGRPS]; // array of ptrs to modem no-answer stgs

#define GTNONE   0            // group type code:  No channels             
#define GTMODEM  1            // group type code:  Modem channels          
#define GTMLOCK  2            // group type code:  Locked modem channels   
#define GTSERIAL 3            // group type code:  Serial channels         
#define GTX25    4            // group type code:  X.25 channels           
#define GTLAN    5            // group type code:  LAN channels            
#define GTOTHER  6            // group type code:  GCDI channels           

extern CHAR *chantn[];        // LAN channel type names               

extern CHAR input[INPSIZ];    // raw user input data buffer             
extern CHAR *margv[INPSIZ/2]; // ptrs to word starts,like argv[]    
extern CHAR *margn[INPSIZ/2]; // ptrs to word ends, for rstrin()    
extern CHAR *nxtcmd;          // ptr to next char for command concat

extern INT
    margc,                    // number of words in margv[], a la argc     
    inplen,                   // overall raw input string length           
    pfnlvl,                   // profanity level of current input (0-3)    
    pfceil,                   // profanity-detection ceiling               
    status,                   // raw status from btusts, where appropriate 
    shortm,                   // display short (0) or long (1) menus on x? 
    numcat;                   // number of concat'd commands so far        

#define GLBMAX 50             // max number of global command handlers     

extern INT nglobs;            // # of global command handlers in operation  
extern INT (*globs[GLBMAX])(VOID);// array to glbl cmd hdlr funcs  

extern VOID (*hdlcon)(VOID);  // "handle connect" function pointer   
                              // -- if calling this rou, don't do anything 
                              // afterwards.  Save what's in this ptr and  
                              // replace it (like an interrupt handler) to 
                              // do something special at connect time.     
                              // ditto for these next three:               

extern VOID (*hdlc25)(VOID);  // handle incoming X.25 call stg (margv)
extern VOID (*hdlnrg)(VOID);  // handle non-RING strings during AWAITC
extern VOID (*hdlrng)(VOID);  // hndle RING(non X25)during AWAITC,HARING
extern INT (*hdlcnc)(VOID);   // handle non-RING whatever during HARING
extern VOID (*hdlrst)(VOID);  // handle channel reset                  
extern INT (*gomvec)(VOID);   // vector for cmd stg handling in gomodl()
extern VOID (*loncdi)(VOID);  // handle logon audit trail msg-GCDI chan
extern VOID (*hdlrlg)(VOID);  // handle relogging on a new user      
extern VOID (*hdlzap)(VOID);  // handle zapping an idle channel      
extern INT (*hdlsmp)(VOID);   // handle sample vs paying channel determin
extern VOID (*shomal_hook)(VOID);// replaceable hook into shomal   
extern GBOOL (*iserrf)(INT chan);// is this channel "error free"?     

//extern jmp_buf eximod;        // exit-module longjmp save block     

extern CHAR *prfptr;
extern CHAR *prfbuf;

#define PFBSIZ      outbsz    // size of prfbuf variable            

extern INT emubel;            // emulation bell period                
extern INT vdasiz;            // max size requirement of volatile data
extern CHAR *vdarea;          // ptr to first vda element(bkwd. comp.)

extern CHAR *vdaptr;          // user's pointer to volatile data area 
extern CHAR *vdatmp;          // general-purpose temp vda-size area   
extern CHAR *sysstg[];        // system type description strings      
extern CHAR *ansstg[];        // ANSI support flavor strings          

extern UINT syslod;           // system loading (1 percent units)     

extern ULONG rsptim;          // avg response time, in 1/65536 sec units

extern VOID (*hangups)(VOID); // always call 1st on hangup vector   

extern VOID
     (*tjoinrou)(USHORT forum),    // teleconference JOINT routine    
     (*ntfysopr)(CHAR *audrec),    // notify remote sysop routine     
     (*emlsdrou)(VOID);            // Send Email to Sysop/ New User rou

extern INT
    (*pagerou)(CHAR *to,CHAR *msg),// teleconference page routine  
    (*pageset)(VOID),              // page setting routine              
    (*cspagerou)(CHAR *to,CHAR *msg);// c/s page routine           

extern VOID(*spageset)(GBOOL on,GBOOL ok);// set page settings rou 

extern INT(*gpirou)(INT usn); // global page interval routine       

extern INT gpagint;           // global page interval,use if gpirou==NULL

extern INT
    nreccl,                        // number of recent calls to record     
    sysrec;                        // include MASTERs in /RECENT list?     

extern
struct recalls {                   // recent calls data structure          
     USHORT logon;                 //   logon time (packed)                
     USHORT logoff;                //   logoff time (packed)               
     CHAR userid[UIDSIZ];          //   user-id of caller                  
} *recents;                   // array of most recent callers         

extern DFAFILE *genbb;        // generic user data file btrieve file ptr

struct bbsgen {               // generic user data records for main exec   
     CHAR userid[UIDSIZ];     //   User-ID                                 
     CHAR modnam[MNMSIZ];     //   Module Name ("Main Executive")          
     CHAR lngnam[LNGSIZ];     //   default language name                   
                              //   (add fields here, default to all-0's)   
};
#define BBSGMX "Main Executive" // 2nd field of all "struct bbsgen" rec'ds 

extern CHAR *bbsttl;     // Title of your BBS                         */
extern CHAR *company;    // Your company name                         */
extern CHAR *addres1;    // Address                                   */
extern CHAR *addres2;    // Address                                   */
extern CHAR *dataph;     // The first phone line connected to server  */
extern CHAR *liveph;     // The first phone line reserved 4 live users*/
extern CHAR *chghour;    // Connect time charge per hour              */
extern CHAR *chgmin;     // Minimum charge                            */
extern CHAR *chgtime;    // Minimum connect time                      */
extern CHAR *syskey;     // key distinguishing sysop-types            */
extern CHAR *glbkey;     // key for "sysop" power: /l                 */
extern CHAR *glbkeyi;    // key for "sysop" power: /invis             */
extern CHAR *sampky;     // key required to log on reserved channels  */
extern CHAR *mmuatr;     // default attribute for main menu selections*/
extern CHAR *ansdim;     // dimmed attribute for main menu selections */

                              // reset-mode                                
#define NORMRS 0              //   normal reset                            
#define BUSYRS 'B'            //   busy-out                                
#define NANSRS 'N'            //   no-answer                               

extern INT outbsz;       // output buffer size per channel            
extern INT sampln;       // number of "free sample" channels          
extern INT mmucrr;       // Main menu credit consumption rate per min 
extern INT outata;       // output ATA to modems when answering?      
extern INT csvcrr;       // C/S credit consumption rate per minute    
extern INT rsmode;       // reset-mode code for channels              
extern INT *rsmodes;     // reset-mode array by channel number        
extern INT vispsw;       // make passwords visible in detail displays?
extern INT maxcat;       // maximum number of concat'd commands       
extern INT svrate;       // how many seconds between saving sysvbls?  
extern INT lonaud;       // make audit trail entry for each logon?    
extern INT kilipg;       // kill-system command in progress           

extern CHAR eurmsk;           // 0x7F if U.S.A. only, 0xFF if European     

extern CHAR btrset[80];            // parameters we're passing to Btrieve       

extern INT multsk;                 // is a multitasker being used?              
extern INT mulmth;                 // if multitasking what method is used       

                                   // methods used when multitasker is used     
#define TIMER  1                   //   using alternate timer source method     
#define COMIRP 2                   //   using COM port interrupt method         

extern struct bbsgen genbuf;       //reading Main Exec records from BBSGEN.DAT

VOID joint(USHORT chan);           // teleconference entry pt for other modules 

                                   // Signup question indexes              
#define TBLLNG 1                   //   language preference                
#define TBLANS 2                   //   can you display ANSI graphics?     
#define TBLNAM 3                   //   what's your real name?             
#define TBLAD1 4                   //   what's your address? (line 1)      
#define TBLAD2 5                   //   what's your address? (line 2)      
#define TBLAD3 6                   //   what's your address? (line 3)      
#define TBLAD4 7                   //   what's your address? (line 4)      
#define TBLPHO 8                   //   what's your phone number?          
#define TBLSYS 9                   //   what's your system type?           
#define TBLBDY 10                  //   what is your birthday?             
#define TBLSEX 11                  //   are you male or female?            
#define TBLSUP 12                  //   sysop-configurable signup questions
#define TBLUSE 13                  //   use your real name as your User-ID?
#define TBLUID 14                  //   what User-ID do you want to use?   
#define ASTSIZ 15                  //   number of entries in asktbl[]      

// *NOTE: update these TBLx constants and asktbl[][] in SIGNUP.C in sync
extern INT asktbl[][3];     // table of signup question parameters

                                   // user information edit key indexes    
#define UIEKYNAM 0                 //   first and last names               
#define UIEKYCOM 1                 //   company name                       
#define UIEKYADR 2                 //   address                            
#define UIEKYPHO 3                 //   phone number                       
#define UIEKYSYS 4                 //   system type                        
#define UIEKYANS 5                 //   ANSI preference                    
#define UIEKYSCW 6                 //   screen width                       
#define UIEKYSCL 7                 //   screen height                      
#define UIEKYEDT 8                 //   editor preference                  
#define UIEKYPAU 9                 //   screen pause setting               
#define UIEKYSEX 10                //   sex                                
#define UIEKYPSW 11                //   password                           
#define UIEKYTSZ 12                //   number of entries in uiekytbl[]    

// NOTE: update these UIEKYxxx constants and uiekytbl[] in UINFED.C in sync
extern CHAR *uiekytbl[];   // table of user information edit keys

#define   DUNINS    999            // morsup() return state for all done

extern INT
    sgnusz,                   // maximum size of user-ids for new signups  
    safpsw,                   // can a User-Id or "password" be a password 
    digalw,                   // digits allowed in User-IDs?               
    fulalw,                   // full names allowed as User-IDs?           
    namdft;                   // how do you handle user-ids?               

typedef GBOOL AUTOSENSE(           // Autosensor routine, 0=working 1=done 
     UINT snccon,                  // since connect, 1/16 sec (see note)   
     CHAR *incbuf,                 // bytes coming in (not NUL terminated) 
     INT nbytes);                  // number of bytes coming in            

         // NOTE: the snccon parameter will always be 0 when initiating an
         // autosensing session, and always at least 1 thereafter.        

extern CHAR *poslng;               // possible languages autosensed        
extern USHORT *austim;             // array[nterms] of the time of bgnaus()
extern INT numcand;                // # of candidates -- cntcand() ret val 
extern INT fstcand;                // first candidate -- cntcand() ret val 
extern CHAR maxcand;               // best candidate  -- cntcand() ret val 
extern USHORT auswait;             // master timeout, 1/16 of second units 
extern INT numaus;                 // number of autosense handlers         

#define LONOK  0                   // chkuid(): user can log on, passw next
#define LONALR 1                   // chkuid(): user logged on already     
#define LONDBT 2                   // chkuid(): doesn't have SAMPKY key    
#define LONSUS 3                   // chkuid(): user suspended             
#define LONUNK 4                   // chkuid(): User-ID not on file        
#define LONAPP 5                   // chkuid(): app-specific rejection     

extern INT (*chkuid)(CHAR *userid);// vector for approving User-ID 
extern INT (*chkpsw)(CHAR *psword);// vector for approving password
extern INT (*chkacc)(VOID);        // handle final accounting of logon
extern GBOOL (*vallon)(VOID);      // vector for final logon validation
extern VOID (*setpfn)(CHAR *inp);  // profanity checker routine    
extern GBOOL (*oesrou)(INT unum);  // vector for BYEBYE disconnection

extern VOID (*syscyc)(VOID);       // system-cycle vector (tail is prctask())
extern VOID (*chncyc)(VOID);       // channel-cycle vector (tail is dwopr()) 

extern INT lstunm;          // last user-number returned by btuscn()
extern INT newunm;          // new userno just ret'd by btuscn()    

extern INT actdet;          // activity detected in this chan cycle 

#define sptrak {sftrak=__FILE__;sltrak=__LINE__;} // tracking source posit 
extern INT sltrak;          // source line tracking                 
extern CHAR *sftrak;       // source file tracking                 

extern LONG mxbaudl[];             // max baud rates, by chan grp as longs 

// return values for incusr() if user is rejected (besides VACANT)         
#define ISCURU -1                  // this is the current user             
#define UIDNGD -2                  // channel active, but invalid User-ID  
#define INVSON -3                  // INVISB flag is on                    

extern INT curdlls;                // # of dlls currently loaded           

// MAJORBBS.C
VOID ckrsch(VOID);
VOID globalcmd(INT (*rouptr)());
VOID rtihdlr(VOID (*rouptr)(VOID));
VOID xltctls(CHAR *txtbuf);
INT usridx(INT chan);
VOID begin_polling(INT unum,VOID (*rouptr)());
VOID stop_polling(INT unum);
VOID hook_connect(VOID (*conrou)(VOID));
VOID hook_disconnect(VOID (*dscrou)(VOID));
VOID hook_cleanup(VOID (*mcurou)(VOID));
VOID hook_delacct(VOID (*dlarou)(CHAR *userid));
VOID hook_shutdown(VOID (*finrou)(VOID));
VOID hook_finalshutdown(VOID (*ffinrou)(VOID));
VOID hook_swt2aa(VOID (*s2aarou)(VOID));
VOID hook_swt2cs(VOID (*s2csrou)(VOID));
VOID hook_announce(VOID (*annorou)(VOID));
VOID dovecs(INT vechdl);
INT register_textvar(CHAR *name,CHAR *(*varrou)());
INT findtvar(CHAR *name);
INT register_module(struct module *mod);
INT findmod(CHAR *name);
VOID dclvda(INT size);
VOID alcvda(VOID);
CHAR *vdaoff(INT unum);
VOID rcdbaud(LONG baud);
VOID powprf(VOID);
INT bdspec(VOID);
VOID updcal(VOID);
VOID kiletc(CHAR *legend);
VOID othtrm(VOID);
VOID condex(VOID);
INT dftuid(CHAR *userid);
INT dftpsw(CHAR *psword);
INT dftacc(VOID);
VOID usrflags(VOID);
GBOOL dftlon(VOID);
INT lngswt(VOID);
VOID injacr(VOID);
VOID clrinp(VOID);
INT sampok(VOID);
VOID hdlinp(VOID);
GBOOL uidxst(CHAR *uid);
VOID clrxrf(VOID);
VOID addxrf(CHAR *newuid);
VOID delxrf(CHAR *userid);
INT hdluid(CHAR *stg);
VOID delgen(CHAR *userid);
INT getgen(struct bbsgen *genbuf,CHAR *userid);
VOID setgen(struct bbsgen *genbuf);
INT onsys(CHAR *uid);
INT onsysn(CHAR *uid,INT invis);
INT uinsys(CHAR *uid);
INT onbbs(CHAR *uid,INT invis);
INT instat(CHAR *uid,INT qstate);
INT fmtx3(CHAR *prmstg);

CHAR *                             //   returns empty string               
catfix1(VOID);                     // global default catastro() txt, part 1

VOID prepff(VOID);
VOID ckmcu(VOID);
VOID zapdec(VOID);
GBOOL absdtdy(VOID);
VOID midnit(VOID);
VOID mjrdla(CHAR *userid);
CHAR *getin(VOID);
VOID parsin(VOID);
VOID paccin(VOID);
VOID paccit(VOID);
VOID dftpfn(CHAR *inp);
VOID rstrin(VOID);
VOID chkdft(CHAR c);
CHAR getdft(VOID);
VOID byenow(INT msgnum,...);
VOID byendl(INT msgnum,...);
VOID setbbye(VOID);
VOID imdrop(VOID);
LONG lincst(INT unum);
VOID rstchn(VOID);
VOID rstx25(CHAR *dspstg,CHAR dspc);
VOID rstlan(INT ishard);
VOID rstcdi(INT ishard);
INT bbsfvc(CHAR *chtype);
INT numcdi(CHAR *chtype);
INT ningrp(INT group);
INT numonl(INT state);
INT bbscon(INT unum);
VOID bbsdsc(INT unum);
VOID rstrxf(VOID);
ULONG hrtval(VOID);
INT hpkrou(INT chan,CHAR c);
VOID stansi(VOID);
VOID echon(VOID);
VOID echonu(INT usrnum);
VOID echsec(CHAR ech,INT lwidth);
INT injoth(VOID);
VOID dftinj(VOID);
VOID lonstf(VOID);
VOID nxtlon(VOID);
VOID audlon(VOID);
VOID bgnlof(VOID);
VOID nxtlof(VOID);
GBOOL mainu(VOID);
VOID curusr(INT uno);
VOID usrson(VOID);
INT incusr(INT unum,GBOOL iginv,GBOOL inccur);
INT glorys(VOID);
INT glorec(VOID);
VOID glolok(VOID);
VOID gloinv(VOID);
VOID musthn(VOID);
VOID dfsthn(VOID);
CHAR *getMsgBlk(INT msgnum);
VOID kiloop(VOID);
VOID bootem(CHAR *who);
VOID kilchn(INT num);
VOID loscar(VOID);
VOID addannom(CHAR *message,CHAR *appid,CHAR *cmdstg);
VOID addanno(CHAR *message);
VOID dclanno(INT size);
VOID aschup(VOID);
VOID hupall(VOID);
VOID mjrfin(VOID);

VOID
initmsg(
USHORT size);

VOID
freekey(VOID); // free usrptr->keys

struct user *                      //   returns ptr to user structure      
usroff(                            // obtains the user struct at an offset 
INT usrnum);                       //   offset to use                      

// MENUING.C
VOID inimnu(VOID);
INT iniarip(VOID);
INT globalgo(VOID);
GBOOL xitmod(VOID);
VOID enapag(CHAR *pagnam);
VOID dispag(CHAR *pagnam);
VOID bgnfnd(VOID);
VOID cntfnd(VOID);
VOID chk4mtch(VOID);
VOID abtfnd(VOID);
INT gopage(CHAR *pagnam,INT lngmnu,INT reting);
INT gomodl(VOID);
INT entmdl(INT modnum,CHAR *cmdstg);
INT gomutl(VOID);
INT gocond(VOID);
INT gomenu(INT lngmnu);
INT gofile(VOID);
INT dspmnu(INT lngmnu);
struct usrmnu *mnuoff(INT unum);
VOID redolocks(INT inserted);
INT opnans(CHAR *filnam);
INT opfile(CHAR *filnam);
INT rdfile(VOID);
VOID clfile(VOID);
VOID xltmnu(CHAR *buffer);
CHAR *xlttxv(CHAR *buffer,INT size);
INT grbtxv(CHAR *buffer);
INT selnum(CHAR selchr);
INT pagstt(CHAR *pagnam);
CHAR *pagcstg(CHAR *pagnam);
VOID clsmnu(VOID);
// OPRLOW.C
VOID inilopr(INT mxscn,INT auxena);
VOID endlopr(VOID);
CHAR *actvscn(INT scnhdl);
CHAR *actvscnsp(INT scnhdl,INT x1,INT y1,INT x2,INT y2,INT scr);
VOID updbckgnd(VOID);
VOID conupd(VOID);
VOID occhdl(VOID);
UINT keyhit(UINT scan);
VOID scngoaway(INT scnhdl);
VOID scn2mai(INT scnhdl);
VOID scn2aux(INT scnhdl);
VOID mai2aux(VOID);
VOID shobox(INT w,INT sho);
VOID unsavscns(VOID);
VOID savscns(VOID);
VOID memswap(CHAR *source,CHAR *dest,INT length);
INT baudat(ULONG baud,INT blink);
VOID cls(CHAR *buf,INT atr);
CHAR *dbytes(ULONG bytes);
// SIGNUP.C
VOID inisup(VOID);
INT signup(VOID);
INT uinfok(INT pmtmsn,INT minlen,INT maxsiz,CHAR *stgptr);
INT unumok(INT pmtmsn,INT minnum,INT maxnum,INT *number);
INT udatok(INT pmtmsn,CHAR *stgptr);
INT okbday(CHAR *stg);
INT usexok(VOID);
VOID lnglist(INT all);
VOID lngfoot(INT all);
INT valuid(CHAR *stg);
VOID stripb(CHAR *stg);
VOID makhdl(CHAR *stg);
VOID zonkhl(CHAR *stg);
INT isuplo(CHAR *stg);
INT loadup(VOID);
GBOOL loadacc(CHAR *userid);
VOID dftans(CHAR dft);
VOID shwusr(struct usracc *usaptr);
VOID finsup(VOID);
INT valpsw(CHAR *psw);
INT issupc(INT c);
VOID supdfts(VOID);
INT morsup(INT supstt);
VOID abosup(INT supstt);
VOID endsup(VOID);
VOID supcyc(VOID);
VOID suphup(VOID);
VOID cntsup(VOID);
// CNCUTL.C
VOID bgncnc(VOID);
INT endcnc(VOID);
CHAR cncchr(VOID);
INT cncint(VOID);
LONG cnclon(VOID);
CHAR *cncuid(VOID);
CHAR *cncsig(VOID);
CHAR cncyesno(VOID);
CHAR *cncwrd(VOID);
CHAR *cncbgw(CHAR *buffer,INT sizbuf);
CHAR *cncall(VOID);
CHAR morcnc(VOID);
INT cnchex(VOID);
CHAR *cncnum(VOID);
INT cnclng(VOID);
// ACCSCN.C
VOID actrep(VOID);
VOID actdis(VOID);
UINT actkey(UINT scncod);
// AUDIT.C
VOID audrep(VOID);
VOID auddis(VOID);
UINT audkey(UINT scncod);
// EMULATE.C
VOID emulupd(VOID);
UINT emulkey(UINT scncod);
VOID oprmks(INT chr);
VOID emuchn(INT chn2em);
VOID emuset(INT chn2em);
VOID emdisp(CHAR *stg);
VOID lvchat(VOID);
VOID winupdt(VOID);
// MONITOR.C
UINT monkey(UINT scncod);
VOID monrep(VOID);
VOID mondis(VOID);
VOID shomal(VOID);
// SUMMARY.C
VOID sumocc(VOID);
UINT sumkey(UINT scncod);
VOID softgroup(VOID);
VOID squiet(VOID);
VOID sseldsp(VOID);
VOID smsgdsp(VOID);
VOID sscnsav(VOID);
VOID skill(VOID);
VOID sentmin(VOID);
VOID sauxcrt(VOID);
VOID scklmod(VOID);
VOID ssndac(VOID);
VOID sentamt(VOID);
VOID sentapf(VOID);
VOID sentuid(VOID);
VOID dwtxte(VOID);
VOID sselpos(VOID);
VOID sinpchn(VOID);
VOID sinpch2(VOID);
VOID sumrep(VOID);
VOID sumdis(VOID);
VOID inisho(VOID);
VOID inisho2(VOID);
VOID finsho(VOID);
VOID dwopr(VOID);
VOID iniaud(VOID);
VOID shocst(CHAR *tex1,CHAR *tex2,...);
VOID scroat(INT dirct);
VOID shochn(CHAR *legend);
VOID shochb(CHAR *legend,INT blink);
VOID shochl(CHAR *legend,CHAR sing,INT attr);
VOID loadgph(INT min);
INT linsusd(VOID);
VOID doaditbx(VOID);
VOID quiesk(INT blk);
VOID zappo(VOID);
VOID plosk(INT sktnum);
VOID zapskl(VOID);
VOID lblsk(INT sknum,CHAR *lblstg);
VOID acckey(VOID);
VOID bckspc(VOID);
VOID hdlskm(CHAR *echstg,INT opistt);
VOID hdlskc(INT opistt);
VOID hdlsk(CHAR *echstg,INT opistt);
VOID retkey(VOID);
VOID auxups(CHAR snum);
VOID collap(VOID);
VOID fupkil(VOID);
VOID snd2ch(INT chan,CHAR *text);
VOID snd2al(CHAR *text);
VOID dftbel(INT local);
VOID savdisp(VOID);
CHAR *chlpfn(VOID);
VOID psmatm(VOID);
VOID psmatms(CHAR *pagmsg);
// USERS.C 
UINT usskey(UINT scncod);
VOID ussrep(VOID);
VOID ussocc(VOID);
VOID ussdis(VOID);
VOID updbank(INT bnk);
VOID usrchl(VOID);
VOID usrchan(INT chan);
// ABOUT.C 
UINT abokey(UINT scncod);
VOID aborep(VOID);
// LOCAL.C 
VOID lsesupd(VOID);
UINT lseskey(UINT scncod);
VOID oprmk2(INT chr);
VOID entlse(INT chn2em);
// PLBBS.C 
VOID callinits(VOID);
VOID setbparm(VOID);
// EMULATE.C 
VOID entcht(VOID);
// AUTSNS.C 
VOID iniaus(VOID);
VOID regautsns(AUTOSENSE *aushdl);
GBOOL bgnaus(GBOOL foreal);
GBOOL prcaus(VOID);
VOID setbyprot(CHAR *prot,CHAR value);
INT cntcand(VOID);
INT lngposn(INT chc);
// BBSRIP.C
VOID inirmdl (VOID);
VOID ripcls (VOID);
// DBGMEM.C
VOID dbgohf(VOID);
VOID dbgchf(VOID);
// MNUUTL.C
VOID unpack(struct mnupag *menupage);
VOID repack(struct mnupag *menupage);
VOID savepage(struct mnupag *menupage,GBOOL insert);

VOID
updclk(VOID);                      // updates system clock                 

VOID
locchn(                            // setup local session channel for GCDI 
INT chan);                         //   channel number for session         

VOID
aboutos(VOID);                     // print OS specific data on about scrn 

VOID
wginit(VOID);                      // OS specific start up routine for WG  

GBOOL                              //   returns TRUE if run as a service   
isRunAsService(VOID);              // is WGSERVER.EXE running as a service 

#endif                             // __MAJORBBS_H
