/***************************************************************************
 *                                                                         *
 *   LOCKNKEY.H                                                            *
 *                                                                         *
 *   Copyright (c) 1991-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the header file for the suite of routines contained in        *
 *   LOCKNKEY.C.                                                           *
 *                                                                         *
 *                                   - S. Brinker and C. Robert  10/3/91   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This routine will first clear a user's list of keys, then read in     *
 *   all his keys from disk (including all the keys on the keyring).  You  *
 *   should use this routine when assigning an online user a different     *
 *   keyring.                                                              *
 *                                                                         *
 *        VOID                                                             *
 *        loadkeys(           load keys from disk into usrptr->keys        *
 *        CHAR *keyring)           name of keyring to load (NULL if none)  *
 *                                                                         *
 *                                                                         *
 *   These three routines can be used to test if a certain user has a key  *
 *   or not.  The uidkey() routine reads the Btrieve file, and should      *
 *   therefore only be used when checking a user not online (otherwise     *
 *   use haskey() for "usrptr" checks and othkey() for "othusp" checks).   *
 *                                                                         *
 *        INT                      1=user has key, 0=user doesn't have key *
 *        haskey(             does current user have the key to this lock? *
 *        CHAR *lock)              name of lock for which key is used      *
 *                                                                         *
 *        INT                      1=user has key, 0=user doesn't have key *
 *        othkey(             does other user have the key to this lock?   *
 *        CHAR *lock)              name of lock for which key is used      *
 *                                                                         *
 *        INT                      1=user has key, 0=user doesn't have key *
 *        uidkey(             does other user have the key to this lock?   *
 *        CHAR *uid                user-id to check (whether online or not)*
 *        CHAR *lock)              name of lock for which key is used      *
 *                                                                         *
 *                                                                         *
 *   These next two routines can be used to give and remove keys from a    *
 *   user.  You can either pass them a single key name, or a list of       *
 *   keys, each separated from each other by a single space, and           *
 *   terminated with a NULL (e.g., "CUSTOMER COSYSOP BETATEST\0").  They   *
 *   both will update the user's access in real-time if he is online.      *
 *                                                                         *
 *   You can also use these routines to add or remove keys from a keyring  *
 *   by passing a keyring name with a leading ampersand ('&') tacked on    *
 *   for the "uid" parameter.                                              *
 *                                                                         *
 *        INT                      0=couldn't give key, 1=key granted      *
 *        givkey(             give a userid a particular (update if online)*
 *        CHAR *uid,               user-id (or keyring) to give key to     *
 *        CHAR *keylist)           list of lock for which key is used      *
 *                                                                         *
 *        VOID                                                             *
 *        rmvkey(             remove a key from a userid (update if online)*
 *        CHAR *uid,               user-id (or keyring) to remove key from *
 *        CHAR *keylist)           name of lock for which key is used      *
 *                                                                         *
 *                                                                         *
 *   You can also manage your own ASCII lists of keys (each key separated  *
 *   by a space, the entire list NULL-terminated).  This routine can be    *
 *   used to determine if a key name is in a given list or not (and if so, *
 *   give you the option of removing it or not).  To add keys to your own  *
 *   lists, just strcat() a space and the key name to your list.           *
 *                                                                         *
 *        INT                      1=key in list, 0=key not in list        *
 *        fndkey(             is a certain key in a ASCII list of keys     *
 *        CHAR *lock,              name of lock for which key is used      *
 *        CHAR *keylist,           ptr to NULL-termin. list of key names   *
 *        INT remove)              if found, remove from list? 0=no, 1=yes *
 *                                                                         *
 ***************************************************************************/

#ifndef __LOCKNKEY_H
#define __LOCKNKEY_H

#define KEYSIZ      16        // max size of key name (and class name also)
#define LOKSIZ      48        // max size of lock name (can have ands/ors) 
#define RINGID      '&'       // first character for a "keyring"-id        
#define KLSTOF      30        // offset of keylist into "keyrec" (kysbuf)  
#define RINGSZ      1024      // size of largest possible keyring record   
#define RSZBLK      20        // block size for alcrsz() calls in locknkey 

extern CHAR **locks;          // dynamically resized list of known locks   

extern INT nlocks;            // current number of known locks in memory
extern INT npkeys;            // current number of pseudokeys in memory

extern
struct pskeys {               // psuedokeys data structure definition
     CHAR pskbeg[KEYSIZ];     // beginning of pseudokey name (sameto)
     INT (*pskrou)(INT unum,CHAR *lock); // does unum have this pseudokey?
} *pkeys;                     // dynamic array of regustered pseudokeys

extern CHAR *kysbuf;          // pointer to one-shot internal keys buffer

// LOCKNKEY.C 03/04/92 11.12.42

VOID
inikys(VOID);                      // initialize the locks & keys interface

INT
register_pseudok(                  // register a new pseudokey             
CHAR *pskbeg,                      // beginning of pseudokey               
INT (*pskrou)(INT unum,CHAR *lock));// routine for validating pseudokey    

VOID
nkyrec(                            // create a new key record              
CHAR *uid);                        // for this user-id or keyring          

VOID
loadkeys(                          // load a user's keys into memory       
CHAR *keyring);                    // keyring name for this user           

VOID
usetkey(                           // turn cur user's bit on for this key  
CHAR *lock);                       // key name to turn on                  

INT
haskno(                            // does this user have this key number  
INT bitno);                        // bit number for this key              

INT
gen_haskey(                        // general haskey() for any user routine
CHAR *lock,                        // lock name the key is for             
INT unum,                          // user number we're dealing with       
struct user *uptr);                // user pointer we're dealing with      

INT
low_haskey(                        // low-level haskey() hdlr (no ands/ors)
CHAR *lock,                        // lock name the key is for             
INT unum,                          // user number we're dealing with       
struct user *uptr);                // user pointer we're dealing with      

INT
scnpsk(                            // scan through pseudo-keys for a lock  
INT unum,                          // user number trying to use key        
CHAR *lock);                       // lock name the key is for             

INT
uhsmkey(                           // passed user have this key (in msg)?  
CHAR *uid,                         // user-id (online or offline)          
INT mnum);                         // message number with key name         

INT
hasmkey(                           // does cur usr have key in message?    
INT mnum);                         // message number with key name         

INT
uhskey(                            // does passed user have this key?      
CHAR *uid,                         // user-id (online or offline)          
CHAR *lock);                       // key name to check for                

INT
haskey(                            // does the current user have this key? 
CHAR *lock);                       // lock name to check for               

INT
othkey(                            // does other user have this key(othusn)
CHAR *lock);                       // lock name to check for               

INT
uidkey(                            // does passed user have this key?      
CHAR *uid,                         // user-id to look up (not online)      
CHAR *lock);                       // lock name to check for               

INT
getlst(                            // get a list of keys from BTRIEVE      
CHAR *uid,                         // user-id or keyring name to get       
CHAR *buffer);                     // buffer to put end result             

INT
findkey(                           // find a key (or remove) in list       
CHAR *lock,                        // lock name to search for              
CHAR *keylist,                     // pointer to list of keys              
INT remove);                       // remove? (1=yes 0=no)                 

INT
givkey(                            // give user or keyring list of keys    
CHAR *uid,                         // uid or keyring name to update        
CHAR *keylist);                    // list of keys to give                 

INT
addkyu(                            // add a key to the kysbuf buffer       
CHAR *keyptr,                      // pointer to the key name              
INT update);                       // update the BTRIEVE record?           

VOID
ustkey(                            // turn off user's bit for this key     
CHAR *lock);                       // key name to turn off                 

VOID
rmvkey(                            // remove a list of keys from user      
CHAR *uid,                         // user (or keyring) to remove from     
CHAR *keylist);                    // list of keys to remove               

INT
lockbit(                           // find bit number for a certain lock   
CHAR *lock,                        // lock name to look for                
INT ins);                          // insert if not found? (1 or 0)        

INT
keynam(                            // validate a proposed keyname          
CHAR *keyname);                    // name to validate, 0=bad 1=ok         

INT
loknam(                            // validate a proposed lock name        
CHAR *lokname);                    // name to validate, 0=bad 1=ok         

VOID
dlkeys(                            // locks & keys delete account routine  
CHAR *uid);                        // user's account that was deleted      

VOID
clslnk(VOID);                      // locks & keys system shutdown routine 

VOID
axschg(                            // access changed for passed User-ID    
CHAR *uid);

#endif // __LOCKNKEY_H