/***************************************************************************
 *                                                                         *
 *   L2AS.C                                                                *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   These are the GCOMM.LIB routines for converting long integers to      *
 *   ASCII.  Either may be called up to 4 times in rapid succession (for   *
 *   example, in successive parameters in a printf() list), without        *
 *   getting into overlapping-buffer problems.                             *
 *                                                                         *
 *   l2as() returns strings between "-2147483648" and "2147483647".        *
 *   ul2as() returns strings between "0" and "4294967296".                 *
 *                                                                         *
 *   The buffers pointed to by the return value are also big enough        *
 *   to be passed to commas() (which inserts comma characters in-place).   *
 *                                                                         *
 *                                            - T. Stryker 2/3/92          *
 *                                            - R. Stein 7/9/94            *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

static CHAR tkastg[4][16];        /* max commas(l2as())="-2,147,483,648"  */
static INT cycle=0;

CHAR *                             /*   returns converted string           */
l2as(                              /* long-to-ASCII conversion utility     */
LONG longin)                       /*   long to convert                    */
{
     cycle=((cycle+1)&3);
     sprintf(tkastg[cycle],"%ld",longin);
     return(tkastg[cycle]);
}

CHAR *                             /*   returns converted string           */
ul2as(                             /* unsigned long-to-ASCII conv utility  */
ULONG ulongin)                     /*   unsigned long to convert           */
{
     cycle=((cycle+1)&3);
     sprintf(tkastg[cycle],"%lu",ulongin);
     return(tkastg[cycle]);
}
