/***************************************************************************
 *                                                                         *
 *   ISGOODPT.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1996 Galacticomm, Inc.    All Rights Reserved.          *
 *                                                                         *
 *   This is the GCOMM.LIB routine for determining if a pointer is         *
 *   valid.                                                                *
 *                                                                         *
 *                                            - R. Stein 2/12/93           *
 *                                            - Ilya Minkin 01/24/96       *
 *                                                                         *
 ***************************************************************************/

#include "gcommlib.h"

extern CHAR *pinstd;
CHAR *pinstd;                      // validated pointer to use             
                                   // pinstd == prt if ptr is valid, points
                                   // to an error message otherwise        
UINT                               //   return # of accessable bytes       
goodblk(                           // is blk of memory addressable w/o GP? 
VOID *ptr,                         //   pointer to block of bytes          
UINT nbytes)                       //   number of bytes to check           
{
     if (ptr == NULL) {
          pinstd="<null pointer>";
          return(0);
     }
     if (IsBadReadPtr(ptr,nbytes) || IsBadWritePtr(ptr,nbytes)) {
          pinstd="<invalid pointer>";
          return(0);
     }
     pinstd=(CHAR *)ptr;
     return(nbytes);
}

GBOOL                              //   return TRUE if stg pointer is valid
goodstg(                           // validate string pointer              
CHAR *ptr)                         //   pointer to validate                
{
     if (IsBadStringPtr(ptr,0xFFFF)) {
          pinstd="<invalid string>";
          return(FALSE);
     }
     pinstd=ptr;
     return(TRUE);
}

GBOOL                              //   return TRUE if pointer is valid    
goodcptr(                          // validate function pointer            
VOID *ptr)                         //   pointer to validate                
{
     if (ptr == NULL) {
          pinstd="<null pointer>";
          return(FALSE);
     }
     if (IsBadCodePtr((FARPROC)ptr)) {
          pinstd="<invalid pointer>";
          return(FALSE);
     }
     pinstd=(CHAR *)ptr;
     return(TRUE);
}

GBOOL                              //   return TRUE if pointer is valid    
goodptr(                           // validate pointer                     
VOID *ptr)                         //   pointer to validate                
{
     if (ptr == NULL) {
          pinstd="<null pointer>";
          return(FALSE);
     }
     // This check validate R/W access to the first byte ptr points to     
     if (IsBadReadPtr(ptr,1) || IsBadWritePtr(ptr,1)) {
          pinstd="<invalid pointer>";
          return(FALSE);
     }
     pinstd=(CHAR *)ptr;
     return(TRUE);
}