/***************************************************************************
 *                                                                         *
 *   ISTXVC.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for determining if a character is       *
 *   valid as part of a text variable name.                                *
 *                                                                         *
 *                                            - T. Stryker 2/3/92          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

GBOOL                              /*   returns TRUE=valid FALSE=invalid   */
istxvc(                            /* is this a valid text variable char   */
INT c)                             /*   character to check                 */
{
     return(((c >= 'A' && c <= 'Z')
          || (c >= 'a' && c <= 'z')
          || (c == '_') || (c == '?')
          || (c >= '0' && c <= '9')
          || (c >= '' && c <= '')
          || (c >= '' && c <= '')) ? TRUE : FALSE);
}
