/***************************************************************************
 *                                                                         *
 *   ISRUNPGM.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1996 Galacticomm, Inc.    All Rights Reserved.          *
 *                                                                         *
 *   Determine if a program is runable.                                    *
 *                                                                         *
 *                                        - Craig Yap 01/10/96             *
 *                                                                         *
 ***************************************************************************/

#include "gcommlib.h"

GBOOL                              //   returns TRUE=prognam is found      
isrunpgm(                          // find a runnable program by name      
Cffblk *fb,                        //   ffblk structure to fill in         
CHAR *prognam)                     //   program name to look for w/o ext   
{
     CHAR pgName[GCMAXPTH];

     stlcpy(pgName,prognam,GCMAXPTH);
     stlcat(pgName,".*",GCMAXPTH);
     if (fnd1st(fb,pgName,0)) {
          do {
               if (samend(fb->ff_name,".COM")
                || samend(fb->ff_name,".EXE")
                || samend(fb->ff_name,".BAT")
                || samend(fb->ff_name,".PIF")
                || samend(fb->ff_name,".CMD")) {
                    return(TRUE);
               }
          } while (fndnxt(fb));
     }
     return(FALSE);
}